/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.ArrayList;

public class DestinyBond
extends StatusBase {
    public DestinyBond() {
        super(StatusType.DestinyBond);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        user.addStatus(new DestinyBond(), user);
        user.bc.sendToAll("pixelmon.effect.applydestinybond", user.getNickname());
    }

    @Override
    public void onAttackUsed(PixelmonWrapper user, Attack attack) {
        user.removeStatus(this);
    }

    @Override
    public void onDamageReceived(PixelmonWrapper user, PixelmonWrapper pokemon, Attack a, int damage, DamageTypeEnum damagetype) {
        if (pokemon.isFainted() && (damagetype == DamageTypeEnum.ATTACK || damagetype == DamageTypeEnum.ATTACKFIXED) && !user.bc.getTeamPokemon(pokemon.getParticipant()).contains(user)) {
            user.bc.sendToAll("pixelmon.effect.destinybond", pokemon.getNickname());
            user.doBattleDamage(pokemon, user.getHealth(), DamageTypeEnum.STATUS);
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        if (MoveChoice.canOutspeedAnd2HKO(bestOpponentChoices, pw, userChoice.createList())) {
            userChoice.raiseWeight(75.0f);
        }
    }
}

