/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.rules.clauses.tiers;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.rules.clauses.BattleClause;
import com.pixelmonmod.pixelmon.entities.npcs.registry.PokemonForm;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.EnumNecrozma;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.items.heldItems.ItemMegaStone;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class Tier
extends BattleClause {
    protected Predicate<PokemonForm> condition;
    private static final Set<EnumSpecies> ignoreForms = new HashSet<EnumSpecies>(Arrays.asList(EnumSpecies.Burmy, EnumSpecies.Castform, EnumSpecies.Gastrodon, EnumSpecies.Shellos, EnumSpecies.Unown));

    public Tier(String id) {
        this(id, p -> true);
    }

    public Tier(String id, Predicate<PokemonForm> condition) {
        super(id);
        this.condition = condition;
    }

    @Override
    public final boolean validateSingle(Pokemon pokemon) {
        ItemHeld heldItem;
        EnumSpecies species = pokemon.getSpecies();
        PokemonForm pokemonForm = new PokemonForm(species, pokemon.getForm(), pokemon.getGender());
        if (pokemonForm.form != -1 && (ignoreForms.contains(species) || !Entity3HasStats.hasForms(species))) {
            pokemonForm.form = -1;
        }
        if (PixelmonWrapper.canMegaEvolve(heldItem = pokemon.getHeldItemAsItemHeld(), species, pokemonForm.form)) {
            if (heldItem instanceof ItemMegaStone) {
                pokemonForm.form = ((ItemMegaStone)heldItem).form;
            } else if (species == EnumSpecies.Necrozma) {
                pokemonForm.form = EnumNecrozma.ULTRA.getForm();
            }
        }
        return this.condition.test(pokemonForm);
    }

    @Override
    public final boolean validateTeam(List<Pokemon> team) {
        return super.validateTeam(team);
    }

    public String getTierDescription() {
        return this.getLocalizedName();
    }
}

