/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.log.MoveResults;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.SkillLink;

public class TripleKick
extends SpecialAttackBase {
    private transient int count = 0;

    @Override
    public AttackResult applyEffectStart(PixelmonWrapper user, PixelmonWrapper target) {
        boolean hasSubstitute = false;
        if (this.count != 0) {
            return AttackResult.proceed;
        }
        boolean missed = false;
        user.inMultipleHit = true;
        while (this.count < 3 && user.isAlive() && target.isAlive() && !missed) {
            MoveResults[] results;
            ++this.count;
            hasSubstitute = target.hasStatus(StatusType.Substitute);
            for (MoveResults result : results = user.useAttackOnly()) {
                if (result.result == AttackResult.failed || result.result == AttackResult.missed) {
                    --this.count;
                    missed = true;
                }
                user.attack.moveResult.damage += result.damage;
                user.attack.moveResult.fullDamage += result.fullDamage;
                user.attack.moveResult.accuracy = result.accuracy;
            }
            user.attack.getMove().setBasePower(user.attack.getMove().getBasePower() + 10);
            if (!(user.getBattleAbility() instanceof SkillLink)) continue;
            user.attack.getMove().setAccuracy(-1);
        }
        user.inMultipleHit = false;
        user.attack.doMove(user, target);
        if (this.count > 0) {
            user.attack.sendEffectiveChat(user, target);
            user.bc.sendToAll("multiplehit.times", user.getNickname(), this.count);
        }
        this.count = 0;
        user.attack.getMove().setBasePower(10);
        user.attack.savedPower = 10;
        user.attack.getMove().setAccuracy(90);
        Attack.postProcessAttackAllHits(user, target, user.attack, user.attack.moveResult.damage, DamageTypeEnum.ATTACK, hasSubstitute);
        if (!hasSubstitute) {
            Attack.applyContactLate(user, target);
        }
        return AttackResult.hit;
    }
}

