/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.animations.particles;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.battles.attacks.animations.StandardParticleAnimationData;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.AttackSystemBase;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.EnumEffectType;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleMathHelper;
import com.pixelmonmod.pixelmon.client.particle.particles.AttackEffect;
import com.pixelmonmod.pixelmon.enums.EnumType;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AttackExplosion
extends AttackSystemBase<ExplosionData> {
    @Override
    @SideOnly(value=Side.CLIENT)
    public void execute(Minecraft mc, World w, double x, double y, double z, float scale, boolean shiny, double ... args) {
        for (int i = 0; i < ((ExplosionData)this.data).power; ++i) {
            mc.field_71452_i.func_78873_a((Particle)new ParticleArcanery(w, ((ExplosionData)this.data).atTarget ? (double)this.endPos[0] : x, ((ExplosionData)this.data).atTarget ? (double)this.endPos[1] : y, ((ExplosionData)this.data).atTarget ? (double)this.endPos[2] : z, 0.0, 0.0, 0.0, ((ExplosionData)this.data).makeEffect(this).setNoise(30.0)));
        }
    }

    @Override
    public void onConstruct(AttackEffect effect) {
        Vec3d vec = ParticleMathHelper.generatePointInSphere(effect.speed, effect.rand);
        effect.mX = vec.field_72450_a;
        effect.mY = vec.field_72448_b;
        effect.mZ = vec.field_72449_c;
    }

    @Override
    public void onInit(ParticleArcanery particle, AttackEffect effect) {
        particle.setScale(2.0f);
    }

    @Override
    public void onEnable(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    public void onUpdate(ParticleArcanery particle, AttackEffect effect) {
        if (!effect.eol) {
            if (effect.ticker > 5) {
                effect.eol = true;
            }
            particle.setRGBA(particle.func_70534_d(), particle.func_70542_f(), particle.func_70535_g(), particle.getAlphaF() * 0.99f);
        }
    }

    @Override
    public void onTarget(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    public void onUpdateEol(ParticleArcanery particle, AttackEffect effect) {
        particle.setMotion(particle.getMotionX() * 0.95, particle.getMotionY() * 0.95, particle.getMotionZ() * 0.95);
        particle.setRGBA(particle.func_70534_d(), particle.func_70542_f(), particle.func_70535_g(), particle.getAlphaF() * 0.8f);
    }

    @Override
    public void onUpdateLast(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    public void onPreRender(ParticleArcanery particle, float partialTicks, AttackEffect effect) {
    }

    @Override
    public void onPostRender(ParticleArcanery particle, float partialTicks, AttackEffect effect) {
    }

    @Override
    public boolean hasCustomRenderer(AttackEffect effect) {
        return false;
    }

    @Override
    public void onRender(ParticleArcanery particle, Tessellator tessellator, float partialTicks, AttackEffect effect) {
    }

    public static class ExplosionData
    extends StandardParticleAnimationData {
        public boolean atTarget = false;

        @Override
        public void initFromAttack(AttackBase attack, int effectivePower, EnumType effectiveType) {
            if (this.speed == -1.0f) {
                this.speed = 1.2f + RandomHelper.rand.nextFloat();
            }
            super.initFromAttack(attack, effectivePower, effectiveType);
        }

        @Override
        public void writeToByteBuffer(ByteBuf buf) {
            super.writeToByteBuffer(buf);
            buf.writeBoolean(this.atTarget);
        }

        @Override
        public ExplosionData readFromByteBuffer(ByteBuf buf) {
            super.readFromByteBuffer(buf);
            this.atTarget = buf.readBoolean();
            return this;
        }

        @Override
        public EnumEffectType getEffectEnum() {
            return EnumEffectType.EXPLOSION;
        }
    }
}

