/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.modifiers.ModifierBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.modifiers.ModifierType;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.EnumType;
import java.util.ArrayList;
import java.util.List;

public abstract class EffectBase {
    public ArrayList<ModifierBase> modifiers = new ArrayList();
    private boolean persists;

    public EffectBase() {
        this(false);
    }

    public EffectBase(boolean persists) {
        this.persists = persists;
    }

    public AttackResult applyEffectStart(PixelmonWrapper user, PixelmonWrapper target) {
        return AttackResult.proceed;
    }

    public abstract void applyEffect(PixelmonWrapper var1, PixelmonWrapper var2);

    public boolean checkChance() {
        for (ModifierBase m : this.modifiers) {
            if (m.type != ModifierType.Chance) continue;
            boolean b = (float)RandomHelper.rand.nextInt(100) < m.value * (float)(m.multiplier == null ? 1 : m.multiplier);
            m.multiplier = 1;
            return b;
        }
        return true;
    }

    public boolean isChance() {
        for (ModifierBase m : this.modifiers) {
            if (m.type != ModifierType.Chance) continue;
            return true;
        }
        return false;
    }

    public float getChance() {
        for (ModifierBase m : this.modifiers) {
            if (m.type != ModifierType.Chance) continue;
            return m.value;
        }
        return 100.0f;
    }

    public void changeChance(int multiplier) {
        for (ModifierBase m : this.modifiers) {
            if (m.type != ModifierType.Chance) continue;
            m.multiplier = multiplier;
        }
    }

    public abstract boolean cantMiss(PixelmonWrapper var1);

    public boolean doesPersist(PixelmonWrapper user) {
        return this.persists;
    }

    public void applyMissEffect(PixelmonWrapper user, PixelmonWrapper target) {
    }

    public void applyEarlyEffect(PixelmonWrapper user) {
    }

    public void dealtDamage(PixelmonWrapper attacker, PixelmonWrapper defender, Attack attack, DamageTypeEnum damageType) {
    }

    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
    }

    protected float getWeightWithChance(float weight) {
        float chance = this.getChance() / 100.0f;
        return chance >= 0.5f ? weight : chance;
    }

    public double modifyTypeEffectiveness(List<EnumType> effectiveTypes, EnumType moveType, double baseEffectiveness) {
        return baseEffectiveness;
    }
}

