/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.attackAnimations.AttackAnimation;
import com.pixelmonmod.pixelmon.api.events.battles.AttackEvents;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.TargetingInfo;
import com.pixelmonmod.pixelmon.battles.attacks.ZMove;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.StatsEffect;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.attackModifiers.AttackModifierBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.attackModifiers.CriticalHit;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.attackModifiers.MultipleHit;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.Assurance;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.BeatUp;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.Fling;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.TripleKick;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.multiTurn.MultiTurnCharge;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.multiTurn.MultiTurnSpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.log.MoveResults;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.rules.clauses.SkyBattle;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AngerPoint;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.KeenEye;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Merciless;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Overcoat;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.ParentalBond;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Sniper;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.SuperLuck;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Unaware;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.battle.AttackCategory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Attack {
    public static final float EFFECTIVE_NORMAL = 1.0f;
    public static final float EFFECTIVE_SUPER = 2.0f;
    public static final float EFFECTIVE_MAX = 4.0f;
    public static final float EFFECTIVE_NOT = 0.5f;
    public static final float EFFECTIVE_BARELY = 0.25f;
    public static final float EFFECTIVE_NONE = 0.0f;
    public static final int ATTACK_PHYSICAL = 0;
    public static final int ATTACK_SPECIAL = 1;
    public static final int ATTACK_STATUS = 2;
    public static final int NEVER_MISS = -1;
    public static final int IGNORE_SEMIINVULNERABLE = -2;
    private AttackBase baseAttack;
    private AttackBase overrideAttack = null;
    public int pp;
    public int ppLevel;
    public int movePower;
    public int moveAccuracy;
    public boolean cantMiss;
    private boolean disabled;
    public MoveResults moveResult;
    public float damageResult;
    public AttackBase savedAttack;
    public int savedPower;
    public int savedAccuracy;
    private Integer overridePPMax = null;
    private AttackCategory overrideAttackCategory = null;
    private EnumType overrideType = null;
    public transient boolean hasPlayedAnimationOnce = false;

    public Attack(AttackBase base) {
        this.initializeAttack(base);
    }

    public Attack(String moveName) {
        AttackBase.getAttackBase(moveName).ifPresent(this::initializeAttack);
        if (this.getMove() == null) {
            Pixelmon.LOGGER.error("No attack found with name: " + moveName);
        }
    }

    public Attack(int attackIndex) {
        AttackBase.getAttackBase(attackIndex).ifPresent(this::initializeAttack);
        if (this.getMove() == null) {
            Pixelmon.LOGGER.error("No attack found with index: " + attackIndex);
        }
    }

    public void initializeAttack(AttackBase base) {
        this.baseAttack = base;
        this.movePower = this.getMove().getBasePower();
        this.pp = this.getMove().getPPBase();
    }

    public AttackBase getMove() {
        return this.overrideAttack != null ? this.overrideAttack : this.baseAttack;
    }

    public AttackBase getActualMove() {
        return this.baseAttack;
    }

    public int getMaxPP() {
        return this.overridePPMax != null ? this.overridePPMax : this.getMove().getPPBase() + (int)((double)this.getMove().getPPBase() * 0.2 * (double)this.ppLevel);
    }

    public void overridePPMax(int pp) {
        this.overridePPMax = pp == -1 ? null : Integer.valueOf(pp);
    }

    public Integer getOverriddenPPMax() {
        return this.overridePPMax;
    }

    public AttackCategory getAttackCategory() {
        return this.overrideAttackCategory != null ? this.overrideAttackCategory : this.getMove().getAttackCategory();
    }

    public void overrideAttackCategory(AttackCategory category) {
        this.overrideAttackCategory = category;
    }

    public EnumType getType() {
        return this.overrideType != null ? this.overrideType : this.getMove().getAttackType();
    }

    public void overrideType(EnumType type) {
        this.overrideType = type;
    }

    public void resetMove() {
        this.overrideAttack = null;
        this.overrideType(null);
        this.overrideAttackCategory(null);
    }

    public boolean use(PixelmonWrapper user, PixelmonWrapper target, MoveResults moveResults) {
        return this.use(user, target, moveResults, null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean use(PixelmonWrapper user, PixelmonWrapper target, MoveResults moveResults, ZMove zMove) {
        void var21_52;
        boolean shouldNotLosePP;
        block70: {
            block66: {
                int n;
                ArrayList<PixelmonWrapper> opponents;
                Optional<AttackBase> opt;
                boolean z;
                boolean bl = z = zMove != null;
                if (z && (opt = AttackBase.getAttackBase(zMove.attackName)).isPresent()) {
                    this.overrideAttack = opt.get();
                    this.overrideAttackCategory(this.getActualMove().getAttackCategory());
                }
                this.moveResult = moveResults;
                this.damageResult = -1.0f;
                if (user.bc == null || target.bc == null) {
                    return false;
                }
                if (!this.checkSkyBattle(user.bc)) {
                    user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
                    moveResults.result = AttackResult.failed;
                    return false;
                }
                AbilityBase userAbility = user.getBattleAbility();
                AbilityBase targetAbility = target.getBattleAbility();
                if (!this.canHit(user, target) && !this.canHitNoTarget()) {
                    moveResults.result = AttackResult.notarget;
                    return true;
                }
                if (user == target) {
                    for (PixelmonWrapper activePokemon : user.bc.getActiveUnfaintedPokemon()) {
                        for (StatusBase status : activePokemon.getStatuses()) {
                            if (!status.stopsSelfStatusMove(activePokemon, user, this)) continue;
                            moveResults.result = AttackResult.failed;
                            return true;
                        }
                    }
                    if (!user.bc.simulateMode) {
                        for (AttackAnimation anim : this.getMove().animations) {
                            if (anim.usedOncePerTurn() && this.hasPlayedAnimationOnce || user != target && !(user.entity.func_70032_d((Entity)target.entity) < 20.0f)) continue;
                            BattleControllerBase.currentAnimations.add(anim.instantiate(user, target, this));
                        }
                    }
                    this.applySelfStatusMove(user, moveResults);
                    return true;
                }
                if (user.targets.size() == 1 && (opponents = user.bc.getOpponentPokemon(user.getParticipant())).size() > 1) {
                    for (PixelmonWrapper pixelmonWrapper : opponents) {
                        if (pixelmonWrapper == target) continue;
                        for (StatusBase status : pixelmonWrapper.getStatuses()) {
                            if (!status.redirectAttack(user, pixelmonWrapper, this)) continue;
                            target = pixelmonWrapper;
                            break;
                        }
                        if (!pixelmonWrapper.getBattleAbility().redirectAttack(user, pixelmonWrapper, this)) continue;
                        target = pixelmonWrapper;
                        break;
                    }
                }
                ArrayList<EffectBase> effects = new ArrayList<EffectBase>(this.getMove().effects);
                if (z && !zMove.attackName.equals(this.getMove().getAttackName()) && this.getAttackCategory() != AttackCategory.STATUS) {
                    effects.clear();
                    effects.addAll(zMove.effects);
                }
                for (EffectBase effectBase : effects) {
                    try {
                        if (effectBase.applyEffectStart(user, target) == AttackResult.proceed) continue;
                        return true;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                int[] modifiedMoveStats = userAbility.modifyPowerAndAccuracyUser(z ? zMove.basePower : this.getMove().getBasePower(), this.getMove().getAccuracy(), user, target, this);
                for (PixelmonWrapper teammate : user.bc.getTeamPokemon(user)) {
                    modifiedMoveStats = teammate.getBattleAbility().modifyPowerAndAccuracyTeammate(modifiedMoveStats[0], modifiedMoveStats[1], user, target, this);
                }
                modifiedMoveStats = targetAbility.modifyPowerAndAccuracyTarget(modifiedMoveStats[0], modifiedMoveStats[1], user, target, this);
                boolean bl2 = false;
                if (modifiedMoveStats[1] < 0) {
                    n = modifiedMoveStats[1];
                }
                modifiedMoveStats = user.getUsableHeldItem().modifyPowerAndAccuracyUser(modifiedMoveStats, user, target, this);
                modifiedMoveStats = target.getUsableHeldItem().modifyPowerAndAccuracyTarget(modifiedMoveStats, user, target, this);
                int beforeSize = user.getStatuses().size();
                for (int i = 0; i < beforeSize; ++i) {
                    StatusBase statusBase = user.getStatus(i);
                    modifiedMoveStats = statusBase.modifyPowerAndAccuracyUser(modifiedMoveStats[0], modifiedMoveStats[1], user, target, this);
                    if (user.getStatuses().size() != beforeSize) break;
                }
                for (StatusBase statusBase : target.getStatuses()) {
                    modifiedMoveStats = statusBase.modifyPowerAndAccuracyTarget(modifiedMoveStats[0], modifiedMoveStats[1], user, target, this);
                }
                for (StatusBase statusBase : user.bc.globalStatusController.getGlobalStatuses()) {
                    modifiedMoveStats = statusBase.modifyPowerAndAccuracyTarget(modifiedMoveStats[0], modifiedMoveStats[1], user, target, this);
                }
                if (n < 0 && modifiedMoveStats[1] >= 0) {
                    modifiedMoveStats[1] = n;
                }
                this.movePower = modifiedMoveStats[0];
                this.moveAccuracy = Math.min(modifiedMoveStats[1], 100);
                this.cantMiss = false;
                if (user.entity != null && target.entity != null) {
                    user.entity.func_70671_ap().func_75651_a((Entity)target.entity, 0.0f, 0.0f);
                }
                double accuracy = this.moveAccuracy;
                if (this.moveAccuracy >= 0) {
                    double combinedAccuracy;
                    int evasion = target.getBattleStats().getEvasionStage();
                    if (user.bc.globalStatusController.hasStatus(StatusType.Gravity)) {
                        evasion = Math.max(-6, evasion - 2);
                    }
                    if (user.getBattleAbility() instanceof KeenEye) {
                        evasion = Math.min(0, evasion);
                    }
                    if ((combinedAccuracy = (double)(user.getBattleStats().getAccuracyStage() - evasion)) > 6.0) {
                        combinedAccuracy = 6.0;
                    } else if (combinedAccuracy < -6.0) {
                        combinedAccuracy = -6.0;
                    }
                    accuracy = (double)this.moveAccuracy * ((double)user.getBattleStats().GetAccOrEva(combinedAccuracy) / 100.0);
                }
                ArrayList<StatusBase> allStatuses = new ArrayList<StatusBase>(target.getStatuses());
                allStatuses.addAll(target.bc.globalStatusController.getGlobalStatuses().stream().collect(Collectors.toList()));
                shouldNotLosePP = false;
                for (int i = 0; i < effects.size(); ++i) {
                    EffectBase effectBase = effects.get(i);
                    if (!(effectBase instanceof MultiTurnSpecialAttackBase)) continue;
                    shouldNotLosePP = ((MultiTurnSpecialAttackBase)effectBase).shouldNotLosePP(user);
                }
                for (StatusBase statusBase : user.getStatuses()) {
                    try {
                        if (!statusBase.stopsIncomingAttackUser(target, user)) continue;
                        return !shouldNotLosePP;
                    }
                    catch (Exception exc) {
                        user.bc.battleLog.onCrash(exc, "Error calculating stopsIncomingAttack for " + statusBase.type.toString() + " for attack " + this.getMove().getLocalizedName());
                    }
                }
                for (StatusBase statusBase : allStatuses) {
                    try {
                        if (!statusBase.stopsIncomingAttack(target, user)) continue;
                        this.onMiss(user, target, moveResults, statusBase);
                        return !shouldNotLosePP;
                    }
                    catch (Exception exc) {
                        user.bc.battleLog.onCrash(exc, "Error calculating stopsIncomingAttack for " + statusBase.type.toString() + " for attack " + this.getMove().getLocalizedName());
                    }
                }
                if (!target.getBattleAbility(user).allowsIncomingAttack(target, user, this) || !target.getUsableHeldItem().allowsIncomingAttack(target, user, this)) {
                    try {
                        this.onMiss(user, target, moveResults, targetAbility);
                        return !shouldNotLosePP;
                    }
                    catch (Exception exc) {
                        user.bc.battleLog.onCrash(exc, "Error calculating allowsIncomingAttack for attack " + this.getMove().getLocalizedName());
                    }
                }
                if (!user.getBattleAbility().allowsOutgoingAttack(user, target, this)) {
                    this.onMiss(user, target, moveResults, targetAbility);
                    return !shouldNotLosePP;
                }
                if (this.hasNoEffect(user, target)) {
                    user.bc.sendToAll("pixelmon.battletext.noeffect", target.getNickname());
                    this.onMiss(user, target, moveResults, (Object)EnumType.Mystery);
                    return !shouldNotLosePP;
                }
                if (!shouldNotLosePP) {
                    targetAbility.preProcessAttack(target, user, this);
                    userAbility.preProcessAttackUser(user, target, this);
                }
                boolean bl3 = this.cantMiss = z || this.cantMiss(user) || this.moveAccuracy < 0;
                if (user.bc.simulateMode) {
                    this.moveResult.accuracy = this.moveAccuracy;
                    accuracy = 100.0;
                }
                EffectBase critModifier = null;
                if (!this.cantMiss && !RandomHelper.getRandomChance((int)accuracy)) break block66;
                AttackResult attackResult = AttackResult.proceed;
                AttackResult applyEffectResult = AttackResult.proceed;
                for (EffectBase e : effects) {
                    try {
                        void var21_45;
                        block69: {
                            block67: {
                                block68: {
                                    if (!(e instanceof AttackModifierBase)) break block67;
                                    if (!(e instanceof CriticalHit)) break block68;
                                    critModifier = e;
                                    break block69;
                                }
                                applyEffectResult = ((AttackModifierBase)e).applyEffectDuring(user, target);
                                if (applyEffectResult == AttackResult.proceed) break block69;
                                AttackResult attackResult2 = applyEffectResult;
                                break block69;
                            }
                            if (e instanceof SpecialAttackBase) {
                                applyEffectResult = ((SpecialAttackBase)e).applyEffectDuring(user, target);
                                if (applyEffectResult != AttackResult.proceed) {
                                    AttackResult attackResult3 = applyEffectResult;
                                }
                            } else if (e instanceof MultiTurnSpecialAttackBase && (applyEffectResult = ((MultiTurnSpecialAttackBase)e).applyEffectDuring(user, target)) != AttackResult.proceed) {
                                AttackResult attackResult4 = applyEffectResult;
                                break;
                            }
                        }
                        if (var21_45 == AttackResult.succeeded || var21_45 == AttackResult.failed || var21_45 == AttackResult.charging || var21_45 == AttackResult.notarget) {
                            moveResults.result = var21_45;
                            continue;
                        }
                        if (var21_45 != AttackResult.hit) continue;
                        if (target.isAlive()) {
                            moveResults.result = AttackResult.hit;
                            continue;
                        }
                        moveResults.result = AttackResult.killed;
                    }
                    catch (Exception exc) {
                        user.bc.battleLog.onCrash(exc, "Error in applyEffect for " + e.getClass().toString() + " for attack " + this.getMove().getLocalizedName());
                    }
                }
                if (moveResults.result == AttackResult.succeeded || moveResults.result == AttackResult.hit || moveResults.result == AttackResult.killed || moveResults.result == AttackResult.charging) {
                    this.doMove(user, target);
                }
                if (applyEffectResult == AttackResult.proceed) {
                    if (userAbility instanceof ParentalBond) {
                        user.inMultipleHit = true;
                        user.inParentalBond = true;
                        for (EffectBase e : effects) {
                            if (e instanceof BeatUp || e instanceof Fling || e instanceof MultiTurnCharge || e instanceof MultipleHit || e instanceof TripleKick) {
                                user.inMultipleHit = false;
                                user.inParentalBond = false;
                                continue;
                            }
                            if (!(e instanceof Assurance)) continue;
                            this.getMove().setBasePower(this.getMove().getBasePower() * 2);
                        }
                    }
                    this.doMove(user, target);
                    this.hasPlayedAnimationOnce = true;
                    this.executeAttackEffects(user, target, moveResults, critModifier, 1.0f);
                    if (user.inParentalBond && this.getAttackCategory() != AttackCategory.STATUS && target.isAlive() && user.isAlive() && user.targets.size() == 1) {
                        for (EffectBase e : effects) {
                            if (!(e instanceof Assurance)) continue;
                            this.getMove().setBasePower(this.getMove().getBasePower() * 2);
                        }
                        user.inMultipleHit = false;
                        user.inParentalBond = false;
                        this.executeAttackEffects(user, target, moveResults, critModifier, 0.25f);
                        user.bc.sendToAll("multiplehit.times", user.getNickname(), 2);
                    }
                    user.inParentalBond = false;
                    for (EffectBase e : effects) {
                        if (!(e instanceof SpecialAttackBase)) continue;
                        ((SpecialAttackBase)e).applyAfterEffect(user);
                    }
                }
                break block70;
            }
            this.onMiss(user, target, moveResults, null);
        }
        boolean bl = false;
        while (var21_52 < target.getStatusSize()) {
            int sizeBefore = target.getStatusSize();
            target.getStatus((int)var21_52).onAttackEnd(target);
            if (sizeBefore > target.getStatusSize()) {
                --var21_52;
            }
            ++var21_52;
        }
        if (!user.bc.simulateMode) {
            EnumUpdateType[] enumUpdateTypeArray = new EnumUpdateType[]{EnumUpdateType.HP, EnumUpdateType.Moveset};
            if (user.getPlayerOwner() != null) {
                user.update(enumUpdateTypeArray);
            }
            if (target.getPlayerOwner() != null) {
                target.update(enumUpdateTypeArray);
            }
        }
        if (target.isFainted()) {
            shouldNotLosePP = false;
        }
        return !shouldNotLosePP;
    }

    public boolean hasNoEffect(PixelmonWrapper user, PixelmonWrapper target) {
        boolean hasNoEffect;
        boolean bl = hasNoEffect = this.getTypeEffectiveness(user, target) == 0.0 && (this.getAttackCategory() != AttackCategory.STATUS || this.isAttack("Poison Gas", "Poison Powder", "Thunder Wave", "Toxic"));
        if (!hasNoEffect && target.hasType(EnumType.Grass) && Overcoat.isPowderMove(this)) {
            hasNoEffect = true;
        }
        for (int o = 0; o < this.getMove().effects.size(); ++o) {
            if (!(this.getMove().effects.get(o) instanceof MultiTurnSpecialAttackBase) || !((MultiTurnSpecialAttackBase)this.getMove().effects.get(o)).ignoresType(user)) continue;
            hasNoEffect = false;
            break;
        }
        return hasNoEffect;
    }

    private void executeAttackEffects(PixelmonWrapper user, PixelmonWrapper target, MoveResults moveResults, EffectBase critModifier, float damageMultiplier) {
        double crit = Attack.calcCriticalHit(critModifier, user, target);
        int power = (int)((float)this.doDamageCalc(user, target, crit) * damageMultiplier);
        this.damageResult = power;
        if (this.getAttackCategory() == AttackCategory.STATUS) {
            power = 0;
        } else if (target.isAlive()) {
            if (crit > 1.0) {
                if (user.targets.size() > 1) {
                    user.bc.sendToAll("pixelmon.battletext.criticalhittarget", target.getNickname());
                } else {
                    user.bc.sendToAll("pixelmon.battletext.criticalhit", new Object[0]);
                }
            }
            this.damageResult = target.doBattleDamage(user, power, DamageTypeEnum.ATTACK);
            moveResults.result = target.isAlive() ? AttackResult.hit : AttackResult.killed;
        } else {
            this.damageResult = -1.0f;
            moveResults.result = AttackResult.notarget;
        }
        AttackResult tempResult = this.applyAttackEffect(user, target);
        if (tempResult != null) {
            moveResults.result = tempResult;
        }
        Attack.applyContactLate(user, target);
        if (this.canRemoveBerry()) {
            target.getUsableHeldItem().tookDamage(user, target, this.damageResult, DamageTypeEnum.ATTACK);
        }
    }

    public void doMove(PixelmonWrapper user, PixelmonWrapper target) {
        EntityLivingBase owner;
        if (user.bc.simulateMode || user.entity == null || target.entity == null) {
            return;
        }
        if (user.entity.field_70165_t == 0.0 && user.entity.field_70163_u == 0.0 && user.entity.field_70161_v == 0.0 && (owner = user.getParticipant().getEntity()) != null) {
            user.entity.func_70012_b(owner.field_70165_t, owner.field_70163_u, owner.field_70161_v, owner.field_70177_z, 0.0f);
        }
        if (!user.bc.simulateMode) {
            for (AttackAnimation anim : this.getMove().animations) {
                if (anim.usedOncePerTurn() && this.hasPlayedAnimationOnce) continue;
                BattleControllerBase cfr_ignored_0 = user.bc;
                BattleControllerBase.currentAnimations.add(anim.instantiate(user, target, this));
            }
        }
    }

    public int doDamageCalc(PixelmonWrapper userWrapper, PixelmonWrapper targetWrapper, double crit) {
        StatsType defenseStat;
        StatsType attackStat;
        if (this.movePower <= 0) {
            return 0;
        }
        AbilityBase userAbility = userWrapper.getBattleAbility();
        double stab = 1.0;
        if (this.hasSTAB(userWrapper)) {
            stab = 1.5;
        }
        stab = userAbility.modifyStab(stab);
        AttackEvents.StabEvent stabEvent = new AttackEvents.StabEvent(userWrapper, targetWrapper, stab);
        Pixelmon.EVENT_BUS.post((Event)stabEvent);
        stab = stabEvent.stabMultiplier;
        double type = this.getTypeEffectiveness(userWrapper, targetWrapper);
        double critical = crit;
        double modifier = stab * type * critical;
        double attack = 0.0;
        double defense = 0.0;
        double level = userWrapper.getLevelNum();
        if (this.getAttackCategory() == AttackCategory.SPECIAL) {
            attackStat = StatsType.SpecialAttack;
            defenseStat = this.isAttack("Psyshock", "Psystrike", "Secret Sword") ? StatsType.Defence : StatsType.SpecialDefence;
        } else {
            attackStat = StatsType.Attack;
            defenseStat = StatsType.Defence;
        }
        attack = userWrapper.getBattleStats().getStatWithMod(attackStat);
        defense = targetWrapper.getBattleStats().getStatWithMod(defenseStat);
        if (crit > 1.0) {
            attack = Math.max((double)userWrapper.getBattleStats().getStatFromEnum(attackStat), attack);
            defense = Math.min((double)targetWrapper.getBattleStats().getStatFromEnum(defenseStat), defense);
        }
        if (this.isAttack("Chip Away", "Sacred Sword") || userAbility instanceof Unaware) {
            defense = targetWrapper.getBattleStats().getStatFromEnum(defenseStat);
        }
        if (this.isAttack("Beat Up") || targetWrapper.getBattleAbility(userWrapper) instanceof Unaware) {
            attack = userWrapper.getBattleStats().getStatFromEnum(attackStat);
        }
        double dmgRand = (double)RandomHelper.getRandomNumberBetween(85, 100) / 100.0;
        if (userWrapper.bc.simulateMode) {
            dmgRand = 1.0;
        }
        double damageBase = (2.0 * level / 5.0 + 2.0) * attack * (double)this.movePower * 0.02 / defense + 2.0;
        double damage = damageBase * modifier * dmgRand;
        damage = userWrapper.getUsableHeldItem().preProcessAttackUser(userWrapper, targetWrapper, this, damage);
        damage = targetWrapper.getUsableHeldItem().preProcessAttackTarget(userWrapper, targetWrapper, this, damage);
        if (userWrapper.targets.size() > 1) {
            damage *= 0.75;
        }
        AttackEvents.DamageEvent damageEvent = new AttackEvents.DamageEvent(userWrapper, targetWrapper, damage);
        Pixelmon.EVENT_BUS.post((Event)damageEvent);
        damage = damageEvent.damage;
        if (damage < 1.0 && damage > 0.0 && this.movePower > 0) {
            damage = 1.0;
        }
        return (int)damage;
    }

    public void applySelfStatusMove(PixelmonWrapper user, MoveResults moveResults) {
        if (user.entity != null) {
            user.entity.func_70671_ap().func_75651_a((Entity)user.entity, 0.0f, 0.0f);
        }
        for (int j = 0; j < this.getMove().effects.size(); ++j) {
            EffectBase e = this.getMove().effects.get(j);
            try {
                if (e instanceof StatsEffect) {
                    AttackResult statsResult = ((StatsEffect)e).applyStatEffect(user, user, this.getMove());
                    if (moveResults.result == AttackResult.succeeded) continue;
                    moveResults.result = statsResult;
                    continue;
                }
                if (e instanceof SpecialAttackBase) {
                    if (e.applyEffectStart(user, user) != AttackResult.proceed) {
                        return;
                    }
                    this.moveResult.result = ((SpecialAttackBase)e).applyEffectDuring(user, user);
                    continue;
                }
                if (e instanceof MultiTurnSpecialAttackBase) {
                    this.moveResult.result = ((MultiTurnSpecialAttackBase)e).applyEffectDuring(user, user);
                    continue;
                }
                if (e instanceof StatusBase) {
                    e.applyEffect(user, user);
                    continue;
                }
                if (!(e instanceof CriticalHit) || user.getBattleStats().increaseCritStage(2)) continue;
                user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
                continue;
            }
            catch (Exception exc) {
                user.bc.battleLog.onCrash(exc, "Error in applyEffect for " + e.getClass().toString() + " for attack " + this.getMove().getLocalizedName());
            }
        }
        user.getUsableHeldItem().onStatModified(user);
        if (!user.bc.simulateMode) {
            NPCTrainer trainer;
            if (user.getPlayerOwner() != null) {
                user.update(EnumUpdateType.HP);
                user.setTemporaryMoveset(user.temporaryMoveset);
            }
            if (user.entity == null || (trainer = user.entity.getTrainer()) != null) {
                // empty if block
            }
        }
        if (moveResults.result == AttackResult.proceed) {
            moveResults.result = AttackResult.succeeded;
        }
    }

    public AttackResult applyAttackEffect(PixelmonWrapper user, PixelmonWrapper target) {
        AttackResult returnResult = null;
        for (int j = 0; j < this.getMove().effects.size(); ++j) {
            EffectBase e = this.getMove().effects.get(j);
            try {
                if (e instanceof StatsEffect) {
                    StatsEffect statsEffect = (StatsEffect)e;
                    boolean abilityAllowsChange = target.getBattleAbility(user).allowsStatChange(target, user, statsEffect);
                    if (abilityAllowsChange) {
                        for (PixelmonWrapper ally : target.bc.getTeamPokemon(target)) {
                            if (ally.getBattleAbility().allowsStatChangeTeammate(ally, target, user, statsEffect)) continue;
                            abilityAllowsChange = false;
                            break;
                        }
                    }
                    if (!abilityAllowsChange) continue;
                    AttackResult statsResult = statsEffect.applyStatEffect(user, target, this.getMove());
                    if (returnResult == AttackResult.succeeded) continue;
                    returnResult = statsResult;
                    continue;
                }
                if (e instanceof StatusBase) {
                    boolean shouldApply = true;
                    for (int i = 0; i < target.getStatusSize(); ++i) {
                        StatusBase et = target.getStatus(i);
                        if (user != target || !et.stopsStatusChange(et.type, target, user)) continue;
                        shouldApply = false;
                        break;
                    }
                    if (!shouldApply) continue;
                    e.applyEffect(user, target);
                    continue;
                }
                e.applyEffect(user, target);
                continue;
            }
            catch (Exception exc) {
                user.bc.battleLog.onCrash(exc, "Error in applyEffect for " + e.getClass().toString() + " for attack " + this.getMove().getLocalizedName());
            }
        }
        user.getUsableHeldItem().onStatModified(user);
        return returnResult;
    }

    public static void applyContact(PixelmonWrapper user, PixelmonWrapper target) {
        if (!target.hasStatus(StatusType.Substitute)) {
            target.getUsableHeldItem().applyEffectOnContact(user, target);
            user.getBattleAbility().applyEffectOnContactUser(user, target);
            target.getBattleAbility().applyEffectOnContactTarget(user, target);
        }
    }

    public static void applyContactLate(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.attack != null && user.attack.getMove().getMakesContact() && !target.hasStatus(StatusType.Substitute)) {
            target.getBattleAbility().applyEffectOnContactTargetLate(user, target);
        }
    }

    public static void postProcessAttackAllHits(PixelmonWrapper user, PixelmonWrapper target, Attack attack, float power, DamageTypeEnum damageType, boolean onSubstitute) {
        if (!user.inParentalBond) {
            for (EffectBase effect : attack.getMove().effects) {
                effect.dealtDamage(user, target, attack, damageType);
            }
            if (!onSubstitute) {
                target.getBattleAbility().tookDamageTargetAfterMove(user, target, attack);
                target.getUsableHeldItem().postProcessAttackTarget(user, target, attack, power);
            }
            user.getUsableHeldItem().dealtDamage(user, target, attack, damageType);
        }
    }

    public void onMiss(PixelmonWrapper user, PixelmonWrapper target, MoveResults results, Object cause) {
        try {
            for (EffectBase effect : this.getMove().effects) {
                if (!(effect instanceof MultiTurnSpecialAttackBase) || !((MultiTurnSpecialAttackBase)effect).isCharging(user, target)) continue;
                results.result = ((MultiTurnSpecialAttackBase)effect).applyEffectDuring(user, target);
                if (results.result != AttackResult.charging) continue;
                return;
            }
            if (cause instanceof StatusBase) {
                ((StatusBase)cause).stopsIncomingAttackMessage(target, user);
            } else if (cause instanceof AbilityBase) {
                ((AbilityBase)cause).allowsIncomingAttackMessage(target, user, this);
            } else if (cause instanceof EnumType) {
                user.bc.sendToAll("pixelmon.battletext.noeffect", target.getNickname());
            } else {
                user.bc.sendToAll("pixelmon.battletext.missedattack", target.getNickname());
                results.result = AttackResult.missed;
            }
            for (EffectBase effect : this.getMove().effects) {
                effect.applyMissEffect(user, target);
            }
            user.getUsableHeldItem().onMiss(user, target);
        }
        catch (Exception exc) {
            user.bc.battleLog.onCrash(exc, "Error in applyMissEffect for attack " + this.getMove().getTranslatedName());
        }
        if (results.result != AttackResult.missed) {
            results.result = AttackResult.failed;
        }
    }

    public boolean hasSTAB(PixelmonWrapper user) {
        return user.hasType(this.getType());
    }

    public void setDisabled(boolean value, PixelmonWrapper pixelmon) {
        this.setDisabled(value, pixelmon, false);
    }

    public void setDisabled(boolean value, PixelmonWrapper pixelmon, boolean switching) {
        this.disabled = value;
        if (pixelmon != null && pixelmon.getParticipant() instanceof PlayerParticipant) {
            pixelmon.setTemporaryMoveset(pixelmon.temporaryMoveset);
        }
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public static double calcCriticalHit(EffectBase e, PixelmonWrapper user, PixelmonWrapper target) {
        if (target.getBattleAbility(user).preventsCriticalHits(user) || target.hasStatus(StatusType.LuckyChant)) {
            return 1.0;
        }
        int critStage = 1;
        critStage += user.getUsableHeldItem().adjustCritStage(user);
        AbilityBase userAbility = user.getBattleAbility();
        if (userAbility instanceof SuperLuck) {
            ++critStage;
        }
        if (user.attack.isAttack("Focus Energy") && !user.getBattleStats().increaseCritStage(2)) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            user.attack.moveResult.result = AttackResult.failed;
        }
        float percent = 0.0625f;
        if (e != null && e instanceof CriticalHit) {
            critStage += ((CriticalHit)e).stages;
        }
        if ((critStage += user.getBattleStats().getCritStage()) == 2) {
            percent = 0.125f;
        } else if (critStage == 3) {
            percent = 0.5f;
        } else if (critStage >= 4) {
            percent = 1.0f;
        }
        if (user.bc.simulateMode && percent < 1.0f && !Merciless.willApply(user, target, user.attack)) {
            percent = 0.0f;
        }
        percent = user.getBattleAbility().adjustCriticalHitChance(user, target, user.attack, percent);
        double crit = 1.0;
        if (RandomHelper.getRandomChance(percent)) {
            AbilityBase targetAbility = target.getBattleAbility();
            if (targetAbility instanceof AngerPoint && !user.bc.simulateMode) {
                ((AngerPoint)targetAbility).wasCrit = true;
            }
            crit = 1.5;
            if (userAbility instanceof Sniper) {
                crit *= 1.5;
            }
        }
        AttackEvents.CriticalHitEvent critEvent = new AttackEvents.CriticalHitEvent(user, target, crit);
        Pixelmon.EVENT_BUS.post((Event)critEvent);
        return critEvent.critMultiplier;
    }

    public boolean canHit(PixelmonWrapper pixelmon1, PixelmonWrapper pixelmon2) {
        return pixelmon2 != null && !pixelmon2.isFainted();
    }

    public boolean doesPersist(PixelmonWrapper pw) {
        if (this.isAttack("Fly", "Bounce")) {
            return pw.hasStatus(StatusType.Flying);
        }
        for (int i = 0; i < this.getMove().effects.size(); ++i) {
            EffectBase e = this.getMove().effects.get(i);
            try {
                if (!e.doesPersist(pw)) continue;
                return true;
            }
            catch (Exception exc) {
                pw.bc.battleLog.onCrash(exc, "Error in doesPersist for " + e.getClass().toString() + " for attack " + this.getMove().getLocalizedName());
            }
        }
        return pw.hasStatus(StatusType.Recharge);
    }

    public boolean cantMiss(PixelmonWrapper user) {
        if (this.cantMiss) {
            return true;
        }
        for (int i = 0; i < this.getMove().effects.size(); ++i) {
            EffectBase e = this.getMove().effects.get(i);
            try {
                if (!e.cantMiss(user)) continue;
                return true;
            }
            catch (Exception exc) {
                user.bc.battleLog.onCrash(exc, "Error in cantMiss for " + e.getClass().toString() + " for attack " + this.getMove().getLocalizedName());
            }
        }
        return false;
    }

    public void sendEffectiveChat(PixelmonWrapper user, PixelmonWrapper target) {
        String s = null;
        if (this.getAttackCategory() != AttackCategory.STATUS) {
            float effectiveness = (float)this.getTypeEffectiveness(user, target);
            if (effectiveness == 0.0f) {
                user.bc.sendToAll("pixelmon.battletext.noeffect", target.getNickname());
                return;
            }
            if (effectiveness == 0.5f || effectiveness == 0.25f) {
                s = "pixelmon.battletext.wasnoteffective";
            } else if (effectiveness == 2.0f || effectiveness == 4.0f) {
                s = "pixelmon.battletext.supereffective";
            }
            if (s != null) {
                if (user.targets.size() > 1) {
                    user.bc.sendToAll(s.concat("target"), target.getNickname());
                } else {
                    user.bc.sendToAll(s, new Object[0]);
                }
            }
        }
    }

    public static boolean dealsDamage(Attack attack) {
        return attack != null && attack.getMove().getBasePower() > 0;
    }

    public void saveAttack() {
        this.savedPower = this.getMove().getBasePower();
        this.savedAccuracy = this.getMove().getAccuracy();
        this.savedAttack = this.getMove();
    }

    public void restoreAttack() {
        this.getMove().setBasePower(this.savedPower);
        this.getMove().setAccuracy(this.savedAccuracy);
        this.resetMove();
    }

    public boolean isAttack(List<String> attacks) {
        for (String attack : attacks) {
            if (!this.isAttack(attack)) continue;
            return true;
        }
        return false;
    }

    public boolean isAttack(String ... attacks) {
        for (String a : attacks) {
            if (!this.getMove().getAttackName().equalsIgnoreCase(a)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAttack(List<Attack> attackList, String ... attackNames) {
        for (Attack attack : attackList) {
            if (attack == null || !attack.isAttack(attackNames)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOffensiveAttackType(List<Attack> attackList, EnumType type) {
        for (Attack attack : attackList) {
            if (attack == null || attack.getType() != type || attack.getAttackCategory() == AttackCategory.STATUS) continue;
            return true;
        }
        return false;
    }

    public void createMoveChoices(PixelmonWrapper pw, ArrayList<MoveChoice> choices, boolean includeAllies) {
        ArrayList<PixelmonWrapper> targets = new ArrayList<PixelmonWrapper>();
        TargetingInfo info = this.getMove().getTargetingInfo();
        if (info.hitsSelf) {
            targets.add(pw);
        }
        if (info.hitsAdjacentAlly && (includeAllies || info.hitsAll)) {
            targets.addAll(pw.bc.getTeamPokemonExcludeSelf(pw));
        }
        if (info.hitsAdjacentFoe) {
            targets.addAll(pw.bc.getOpponentPokemon(pw));
        }
        if (info.hitsAll) {
            choices.add(new MoveChoice(pw, this, targets));
        } else {
            for (PixelmonWrapper target : targets) {
                ArrayList<PixelmonWrapper> targetArray = new ArrayList<PixelmonWrapper>(1);
                targetArray.add(target);
                choices.add(new MoveChoice(pw, this, targetArray));
            }
        }
    }

    public ArrayList<MoveChoice> createMoveChoices(PixelmonWrapper pw, boolean includeAllies) {
        ArrayList<MoveChoice> choices = new ArrayList<MoveChoice>();
        this.createMoveChoices(pw, choices, includeAllies);
        return choices;
    }

    public ArrayList<Attack> createList() {
        ArrayList<Attack> list = new ArrayList<Attack>(1);
        list.add(this);
        return list;
    }

    public boolean equals(Object compare) {
        if (compare == null || !(compare instanceof Attack)) {
            return false;
        }
        return this.getMove().getAttackName().equalsIgnoreCase(((Attack)compare).getMove().getAttackName());
    }

    public int hashCode() {
        if (this.getMove() == null) {
            return 0;
        }
        return this.getMove().getAttackName().hashCode();
    }

    public String toString() {
        return this.getMove().getAttackName();
    }

    public double getTypeEffectiveness(PixelmonWrapper user, PixelmonWrapper target) {
        ArrayList effectiveTypes = target.getEffectiveTypes(user, target);
        if (effectiveTypes.contains((Object)EnumType.Flying) && this.getMove().isAttack("Thousand Arrows")) {
            effectiveTypes = Lists.newArrayList(effectiveTypes);
            effectiveTypes.removeIf(type -> type == EnumType.Flying);
            if (effectiveTypes.isEmpty()) {
                effectiveTypes.add(EnumType.Normal);
            }
        }
        double effectiveness = EnumType.getTotalEffectiveness(effectiveTypes, this.getType());
        for (EffectBase e : this.getMove().effects) {
            effectiveness = e.modifyTypeEffectiveness(effectiveTypes, this.getType(), effectiveness);
        }
        if (user.bc.rules.hasClause("inverse")) {
            effectiveness = EnumType.inverseEffectiveness((float)effectiveness);
        }
        AttackEvents.TypeEffectivenessEvent event = new AttackEvents.TypeEffectivenessEvent(user, target, effectiveness);
        Pixelmon.EVENT_BUS.post((Event)event);
        return event.getMultiplier();
    }

    public boolean canRemoveBerry() {
        return this.isAttack("Bug Bite", "Pluck", "Knock Off");
    }

    public Attack copy() {
        Attack newAttack = new Attack(this.getMove());
        newAttack.pp = this.pp;
        return newAttack;
    }

    public boolean checkSkyBattle(BattleControllerBase bc) {
        return !bc.rules.hasClause("sky") || SkyBattle.isMoveAllowed(this);
    }

    public boolean canHitNoTarget() {
        return this.isAttack("Doom Desire", "Future Sight", "Imprison", "Spikes", "Stealth Rock", "Sticky Web", "Toxic Spikes");
    }

    public boolean isSoundBased() {
        return this.getMove().getFlags().sound;
    }

    public static boolean hasAttack(int attackIndex) {
        return attackIndex != -1 && AttackBase.getAttackBase(attackIndex).isPresent();
    }

    public static boolean hasAttack(String moveName) {
        return AttackBase.getAttackBase(moveName).isPresent() && AttackBase.getAttackBase(moveName).get().getAttackId() != -1;
    }

    public static AttackBase[] getAttacks(String[] nameList) {
        AttackBase[] attacks = new AttackBase[nameList.length];
        for (int i = 0; i < nameList.length; ++i) {
            attacks[i] = AttackBase.getAttackBase(nameList[i].toLowerCase()).orElse(null);
            if (attacks[i] != null) continue;
            Pixelmon.LOGGER.error("No attack found with name: " + nameList[i]);
        }
        return attacks;
    }
}

