/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.util;

import com.google.common.collect.ImmutableList;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.spawning.SpawnSet;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnInfoPokemon;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.util.helpers.RCFileHelper;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class SetLoader {
    private static HashMap<String, SpawnSet> loadedSets = new HashMap();
    public static Class<? extends SpawnSet> targetedSpawnSetClass = SpawnSet.class;
    public static final String SPAWN_SET_ROOT = "pixelmon/spawning/";
    public static final String DEFAULT_SPAWN_SET_FOLDER = "default";

    public static <T> ImmutableList<T> getAllSets() {
        ArrayList<SpawnSet> loadedSetsT = new ArrayList<SpawnSet>();
        for (SpawnSet spawnSet : loadedSets.values()) {
            loadedSetsT.add(spawnSet);
        }
        return ImmutableList.copyOf(loadedSetsT);
    }

    public static void clearAll() {
        loadedSets.clear();
    }

    public static <T> T getSet(String name) {
        return (T)loadedSets.get(name);
    }

    public static void export(String dir, String name) {
        SpawnSet spawnSet = loadedSets.get(name);
        if (spawnSet != null) {
            spawnSet.export(dir);
        }
    }

    public static void exportAll(String dir) {
        for (SpawnSet spawnSet : loadedSets.values()) {
            spawnSet.export(dir);
        }
    }

    public static ArrayList<SpawnSet> importSetsFrom(String dir) {
        ArrayList<SpawnSet> setList = new ArrayList<SpawnSet>();
        File file = new File(dir);
        if (file.exists()) {
            ArrayList<File> jsons = new ArrayList<File>();
            if (file.isDirectory()) {
                SetLoader.recursiveSetSearch(dir, jsons);
            } else if (dir.endsWith(".json")) {
                jsons.add(file);
            }
            while (!jsons.isEmpty()) {
                File json = jsons.remove(0);
                try {
                    SpawnSet spawnSet = SpawnSet.deserialize(new FileReader(json));
                    if (spawnSet.spawnInfos == null) {
                        Pixelmon.LOGGER.log(Level.WARN, "There was a nulled spawnInfo list in set: " + spawnSet.id);
                        continue;
                    }
                    spawnSet.spawnInfos.removeIf(spawnInfo -> {
                        if (spawnInfo instanceof SpawnInfoPokemon) {
                            return !PixelmonConfig.isGenerationEnabled(((SpawnInfoPokemon)spawnInfo).getSpecies().getGeneration());
                        }
                        return false;
                    });
                    setList.add(spawnSet);
                    loadedSets.put(spawnSet.id, spawnSet);
                }
                catch (Exception e) {
                    Pixelmon.LOGGER.error(json.getName() + " has JSON syntax problems! Here's a long error:");
                    e.printStackTrace();
                }
            }
        }
        return setList;
    }

    public static void recursiveSetSearch(String dir, ArrayList<File> jsons) {
        File file = new File(dir);
        for (String name : file.list()) {
            File subFile = new File(dir + "/" + name);
            if (subFile.isFile() && name.endsWith(".json")) {
                jsons.add(subFile);
                continue;
            }
            if (!subFile.isDirectory()) continue;
            SetLoader.recursiveSetSearch(dir + "/" + name, jsons);
        }
    }

    public static void addSet(SpawnSet set) {
        loadedSets.put(set.id, set);
    }

    public static String getSpawnSetPath() {
        return SPAWN_SET_ROOT + PixelmonConfig.spawnSetFolder;
    }

    public static void checkForMissingSpawnSets() {
        File file = new File("pixelmon/spawning/default/");
        file.mkdirs();
        SetLoader.retrieveSpawnSetsFromAssets("");
    }

    public static ArrayList<SpawnSet> retrieveSpawnSetsFromAssets(String folder) {
        ArrayList<SpawnSet> spawnSets = new ArrayList<SpawnSet>();
        try {
            Path path = RCFileHelper.pathFromResourceLocation(new ResourceLocation("pixelmon", "spawning/" + folder));
            List<Path> setPaths = RCFileHelper.listFilesRecursively(path, entry -> entry.getFileName().toString().endsWith(".json") && !entry.getFileName().toString().contains("BetterSpawnerConfig"), true);
            for (Path setPath : setPaths) {
                try {
                    Path lowerPath = setPath;
                    String root = "/assets/pixelmon/spawning/";
                    String assetPath = "";
                    while (!lowerPath.getParent().endsWith("spawning")) {
                        assetPath = lowerPath.getParent().getFileName().toString() + "/" + assetPath;
                        lowerPath = lowerPath.getParent();
                    }
                    InputStream iStream = SetLoader.class.getResourceAsStream(root + assetPath.toString() + setPath.getFileName());
                    if (iStream == null) {
                        Pixelmon.LOGGER.log(Level.WARN, "Couldn't find internal spawning JSON at " + root + assetPath.toString() + setPath.getFileName());
                        continue;
                    }
                    String json = "";
                    SpawnSet set = null;
                    try {
                        Scanner s = new Scanner(iStream);
                        s.useDelimiter("\\A");
                        json = s.hasNext() ? s.next() : "";
                        s.close();
                        set = SpawnSet.deserialize(json);
                        if (set.spawnInfos != null && !set.spawnInfos.isEmpty()) {
                            set.spawnInfos.removeIf(spawnInfo -> {
                                if (!(spawnInfo instanceof SpawnInfoPokemon)) {
                                    return false;
                                }
                                SpawnInfoPokemon spawnInfoPokemon = (SpawnInfoPokemon)spawnInfo;
                                EnumSpecies species = EnumSpecies.getFromNameAnyCase(spawnInfoPokemon.getPokemonSpec().name);
                                if (species == null) {
                                    Pixelmon.LOGGER.warn("Bad pokemon name: " + spawnInfoPokemon.getPokemonSpec().name + " in " + spawnInfo.set.id + ".set.json");
                                }
                                return species == null || !PixelmonConfig.isGenerationEnabled(species.getGeneration());
                            });
                        }
                    }
                    catch (Exception e) {
                        Pixelmon.LOGGER.error("Couldn't load spawn JSON: " + root + assetPath.toString() + setPath.getFileName());
                        throw e;
                    }
                    spawnSets.add(set);
                    if (PixelmonConfig.useExternalJSONFilesSpawning) {
                        String primaryPath = "./pixelmon/spawning/default";
                        String relevantPath = "";
                        while (!setPath.getParent().endsWith("spawning")) {
                            relevantPath = setPath.getParent().getFileName().toString() + "/" + relevantPath;
                            setPath = setPath.getParent();
                        }
                        File file = new File(primaryPath + "/" + relevantPath + set.id + ".set.json");
                        if (!file.exists()) {
                            file.getParentFile().mkdirs();
                            PrintWriter pw = new PrintWriter(file);
                            pw.write(json);
                            pw.flush();
                            pw.close();
                        }
                    } else {
                        loadedSets.put(set.id, set);
                    }
                    try {
                        iStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return spawnSets;
    }
}

