/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.checkspawns;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.calculators.ICheckSpawns;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.spawning.util.SpatialData;
import com.pixelmonmod.pixelmon.api.world.MutableLocation;
import com.pixelmonmod.pixelmon.config.BetterSpawnerConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class RayTraceCheckSpawns
implements ICheckSpawns {
    public String node;
    public LocationType locationType;
    public Predicate<IBlockState> isValidBlock;

    public RayTraceCheckSpawns(LocationType locationType, Predicate<IBlockState> isValidBlock, String node) {
        this.locationType = locationType;
        this.isValidBlock = isValidBlock;
        this.node = node;
    }

    @Override
    public String getPermissionNode() {
        return this.node;
    }

    @Override
    public void checkSpawns(AbstractSpawner spawner, ICommandSender sender, List<String> arguments) {
        RayTraceResult result;
        EntityPlayerMP target = null;
        if (!(sender instanceof EntityPlayerMP)) {
            PlayerList playerList = sender.func_184102_h().func_184103_al();
            for (String argument : arguments) {
                if (!spawner.name.equals(argument) && (target = playerList.func_152612_a(argument)) != null) break;
            }
            if (target == null) {
                sender.func_145747_a((ITextComponent)this.translate(TextFormatting.RED, "spawning.error.mustbeplayer", new Object[0]));
                return;
            }
        }
        if (target == null) {
            target = (EntityPlayerMP)sender;
        }
        if ((result = ForgeHooks.rayTraceEyes((EntityLivingBase)target, (double)5.0)) == null || result.field_72313_a != RayTraceResult.Type.BLOCK) {
            sender.func_145747_a((ITextComponent)this.translate(TextFormatting.RED, "spawning.error.notlookingatblock", target.func_70005_c_()));
            return;
        }
        if (this.isValidBlock != null && !this.isValidBlock.test(target.func_71121_q().func_180495_p(result.func_178782_a()))) {
            sender.func_145747_a((ITextComponent)this.translate(TextFormatting.RED, "spawning.error.invalidblock", new Object[0]));
            return;
        }
        SpatialData data = spawner.calculateSpatialData((World)target.func_71121_q(), result.func_178782_a(), 10, true, b -> true);
        SpawnLocation spawnLocation = new SpawnLocation((Entity)target, new MutableLocation((World)target.func_71121_q(), result.func_178782_a()), Lists.newArrayList((Object[])new LocationType[]{this.locationType}), data.baseBlock, data.uniqueSurroundingBlocks, target.func_71121_q().func_180494_b(result.func_178782_a()), BetterSpawnerConfig.doesBlockSeeSky(target.func_71121_q().func_180495_p(result.func_178782_a())), 6, 0);
        sender.func_184102_h().func_152344_a(() -> {
            ArrayList<SpawnInfo> spawns = spawner.getSuitableSpawns(spawnLocation);
            HashMap<SpawnLocation, List<SpawnInfo>> possibleSpawns = new HashMap<SpawnLocation, List<SpawnInfo>>();
            possibleSpawns.put(spawnLocation, spawns);
            Map<String, Double> percentages = spawner.selectionAlgorithm.getPercentages(spawner, possibleSpawns);
            List<TextComponentBase> messages = this.generateMessages(percentages, arguments);
            messages.add(0, (TextComponentBase)this.translate(TextFormatting.AQUA, "spawning.checkspawns.possiblespawns", new Object[0]));
            messages.forEach(arg_0 -> ((ICommandSender)sender).func_145747_a(arg_0));
        });
    }
}

