/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.checkspawns;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.calculators.ICheckSpawns;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.spawning.util.SpatialData;
import com.pixelmonmod.pixelmon.api.world.MutableLocation;
import com.pixelmonmod.pixelmon.config.BetterSpawnerConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class GenericTriggerCheckSpawns
implements ICheckSpawns {
    public String node;
    public LocationType locationType;

    public GenericTriggerCheckSpawns(LocationType locationType, String node) {
        this.locationType = locationType;
        this.node = node;
    }

    @Override
    public String getPermissionNode() {
        return this.node;
    }

    @Override
    public void checkSpawns(AbstractSpawner spawner, ICommandSender sender, List<String> arguments) {
        EntityPlayerMP target = null;
        if (!(sender instanceof EntityPlayerMP)) {
            PlayerList playerList = sender.func_184102_h().func_184103_al();
            for (String argument : arguments) {
                if (!spawner.name.equals(argument) && (target = playerList.func_152612_a(argument)) != null) break;
            }
            if (target == null) {
                sender.func_145747_a((ITextComponent)this.translate(TextFormatting.RED, "spawning.error.mustbeplayer", new Object[0]));
                return;
            }
        }
        if (target == null) {
            target = (EntityPlayerMP)sender;
        }
        SpatialData data = spawner.calculateSpatialData((World)target.func_71121_q(), target.func_180425_c(), 6, true, s -> true);
        SpawnLocation spawnLocation = new SpawnLocation((Entity)target, new MutableLocation((World)target.func_71121_q(), target.func_180425_c()), Lists.newArrayList((Object[])new LocationType[]{this.locationType}), data.baseBlock, data.uniqueSurroundingBlocks, target.func_71121_q().func_180494_b(target.func_180425_c()), BetterSpawnerConfig.doesBlockSeeSky(target.func_71121_q().func_180495_p(target.func_180425_c())), 6, 1);
        sender.func_184102_h().func_152344_a(() -> {
            ArrayList<SpawnInfo> spawns = spawner.getSuitableSpawns(spawnLocation);
            HashMap<SpawnLocation, List<SpawnInfo>> possibleSpawns = new HashMap<SpawnLocation, List<SpawnInfo>>();
            possibleSpawns.put(spawnLocation, spawns);
            Map<String, Double> percentages = spawner.selectionAlgorithm.getPercentages(spawner, possibleSpawns);
            List<TextComponentBase> messages = this.generateMessages(percentages, arguments);
            messages.add(0, (TextComponentBase)this.translate(TextFormatting.AQUA, "spawning.checkspawns.possiblespawns", new Object[0]));
            messages.forEach(arg_0 -> ((ICommandSender)sender).func_145747_a(arg_0));
        });
    }
}

