/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.events.spawning.CreateSpawnerEvent;
import com.pixelmonmod.pixelmon.api.spawning.IRarityTweak;
import com.pixelmonmod.pixelmon.api.spawning.ISpawnerCondition;
import com.pixelmonmod.pixelmon.api.spawning.ISpawningTweak;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.SpawnSet;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.selection.LocationWeightedAlgorithm;
import com.pixelmonmod.pixelmon.api.spawning.calculators.ICheckSpawns;
import com.pixelmonmod.pixelmon.api.spawning.calculators.ISelectionAlgorithm;
import com.pixelmonmod.pixelmon.api.spawning.conditions.RarityMultiplier;
import com.pixelmonmod.pixelmon.api.spawning.conditions.SpawnCondition;
import com.pixelmonmod.pixelmon.api.spawning.util.SpatialData;
import com.pixelmonmod.pixelmon.api.world.BlockCollection;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class AbstractSpawner {
    public final String name;
    public final ArrayList<UUID> spawned = new ArrayList();
    public ISelectionAlgorithm selectionAlgorithm = new LocationWeightedAlgorithm();
    public ICheckSpawns checkSpawns = ICheckSpawns.getDefault();
    public List<ISpawningTweak> tweaks = new ArrayList<ISpawningTweak>();
    public List<ISpawnerCondition> conditions = new ArrayList<ISpawnerCondition>();
    public List<IRarityTweak> rarityTweaks = new ArrayList<IRarityTweak>();
    public List<RarityMultiplier> rarityMultipliers = new ArrayList<RarityMultiplier>();
    public volatile boolean isBusy = false;
    public long lastSpawnTime;
    public List<SpawnSet> spawnSets = new ArrayList<SpawnSet>();
    public transient HashMap<Biome, List<SpawnInfo>> cacheSets = null;

    public AbstractSpawner(String name) {
        this.name = name;
    }

    public boolean shouldDoSpawning() {
        return !this.isBusy;
    }

    public ArrayList<SpawnInfo> getSuitableSpawns(SpawnLocation spawnLocation) {
        ArrayList<SpawnInfo> suitableSpawns = new ArrayList<SpawnInfo>();
        if (this.cacheSets != null) {
            if (!this.cacheSets.containsKey(spawnLocation.biome)) {
                return new ArrayList<SpawnInfo>();
            }
            for (SpawnInfo spawnInfo : this.cacheSets.get(spawnLocation.biome)) {
                if (!spawnInfo.fits(this, spawnLocation)) continue;
                suitableSpawns.add(spawnInfo);
            }
        } else {
            for (SpawnSet set : this.spawnSets) {
                suitableSpawns.addAll(set.suitableSpawnsFor(this, spawnLocation));
            }
        }
        return suitableSpawns;
    }

    public boolean fits(SpawnInfo spawnInfo, SpawnLocation spawnLocation) {
        for (ISpawnerCondition condition : this.conditions) {
            if (condition.fits(this, spawnInfo, spawnLocation)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public SpawnInfo getWeightedSpawnInfo(SpawnLocation spawnLocation) {
        ArrayList<SpawnInfo> suitableSpawns = this.getSuitableSpawns(spawnLocation);
        if (suitableSpawns.isEmpty()) {
            return null;
        }
        return this.selectionAlgorithm.choose(this, spawnLocation, suitableSpawns);
    }

    public SpatialData calculateSpatialData(World world, BlockPos centre, int max, boolean includeDownwards, Predicate<Block> condition) {
        int[] nArray;
        IBlockState state = world.func_180495_p(centre);
        if (!condition.test(state.func_177230_c())) {
            return new SpatialData(0, world.func_180495_p(centre.func_177977_b()).func_177230_c(), Lists.newArrayList((Object[])new Block[]{state.func_177230_c()}));
        }
        int r = 1;
        int[] xs = new int[]{-1, 1};
        if (includeDownwards) {
            int[] nArray2 = new int[2];
            nArray2[0] = -1;
            nArray = nArray2;
            nArray2[1] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        }
        int[] ys = nArray;
        int[] zs = new int[]{-1, 1};
        int radius = r;
        block0: while (radius <= max) {
            for (int xMul : xs) {
                for (int zMul : zs) {
                    for (int yMul : ys) {
                        state = world.func_180495_p(centre.func_177982_a(xMul * r, yMul * r, zMul * r));
                        if (condition.test(state.func_177230_c())) continue;
                        r = radius;
                        break block0;
                    }
                }
            }
            r = radius++;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
        ArrayList<Block> uniqueSurroundingBlocks = new ArrayList<Block>();
        for (int xOffset = -r; xOffset <= r; ++xOffset) {
            for (int yOffset = -r; yOffset <= r; ++yOffset) {
                for (int zOffset = -r; zOffset <= r; ++zOffset) {
                    int z;
                    int y;
                    int x = xOffset + centre.func_177958_n();
                    Block block = world.func_180495_p((BlockPos)pos.func_181079_c(x, y = yOffset + centre.func_177956_o(), z = zOffset + centre.func_177952_p())).func_177230_c();
                    if (uniqueSurroundingBlocks.contains(block)) continue;
                    uniqueSurroundingBlocks.add(block);
                }
            }
        }
        return new SpatialData(r, world.func_180495_p(centre.func_177977_b()).func_177230_c(), uniqueSurroundingBlocks);
    }

    public BlockCollection getTrackedBlockCollection(Entity entity, float horizontalTrackFactor, float verticalTrackFactor, int horizontalSliceRadius, int verticalSliceRadius, int minDistFromCentre, int maxDistFromCentre) {
        BlockPos centre = entity.func_180425_c().func_177963_a((double)horizontalTrackFactor * entity.field_70159_w, (double)verticalTrackFactor * entity.field_70181_x, (double)horizontalTrackFactor * entity.field_70179_y);
        float theta = RandomHelper.getRandomNumberBetween(0.0f, (float)Math.PI * 2);
        int r = RandomHelper.getRandomNumberBetween(minDistFromCentre, maxDistFromCentre);
        int xDisplacement = (int)((double)r * Math.cos(theta));
        int zDisplacement = (int)((double)r * Math.sin(theta));
        centre = centre.func_177982_a(xDisplacement, 0, zDisplacement);
        return new BlockCollection(entity, entity.field_70170_p, centre.func_177958_n() - horizontalSliceRadius, centre.func_177958_n() + horizontalSliceRadius, centre.func_177956_o() - verticalSliceRadius, centre.func_177956_o() + verticalSliceRadius, centre.func_177952_p() - horizontalSliceRadius, centre.func_177952_p() + horizontalSliceRadius);
    }

    public boolean hasTweak(Class<? extends ISpawningTweak> clazz) {
        return CollectionHelper.containsA(this.tweaks, clazz);
    }

    @Nullable
    public <T extends ISpawningTweak> T getTweak(Class<T> clazz) {
        return (T)((ISpawningTweak)CollectionHelper.getFirst(this.tweaks, clazz));
    }

    public boolean hasCondition(Class<? extends ISpawnerCondition> clazz) {
        return CollectionHelper.containsA(this.conditions, clazz);
    }

    @Nullable
    public <T extends ISpawnerCondition> T getCondition(Class<T> clazz) {
        return (T)((ISpawnerCondition)CollectionHelper.getFirst(this.conditions, clazz));
    }

    public static class SpawnerBuilder<T extends AbstractSpawner> {
        public HashMap<Biome, List<SpawnInfo>> cacheMap = new HashMap();
        public List<SpawnSet> spawnSets = new ArrayList<SpawnSet>();
        public ISelectionAlgorithm selectionAlgorithm = new LocationWeightedAlgorithm();
        public ICheckSpawns checkSpawns = ICheckSpawns.getDefault();
        public List<ISpawningTweak> tweaks = new ArrayList<ISpawningTweak>();
        public List<ISpawnerCondition> conditions = new ArrayList<ISpawnerCondition>();
        public List<RarityMultiplier> rarityMultipliers = new ArrayList<RarityMultiplier>();

        public <E extends SpawnerBuilder<T>> E addSpawnSets(SpawnSet ... spawnSets) {
            for (SpawnSet spawnSet : spawnSets) {
                this.spawnSets.add(spawnSet);
            }
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E addSpawnSets(Collection<SpawnSet> spawnSets) {
            this.spawnSets.addAll(spawnSets);
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E setSpawnSets(SpawnSet ... spawnSets) {
            this.spawnSets.clear();
            return this.addSpawnSets(spawnSets);
        }

        public <E extends SpawnerBuilder<T>> E setSpawnSets(List<SpawnSet> spawnSets) {
            this.spawnSets = spawnSets;
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E setupCache() {
            this.cacheMap.clear();
            for (SpawnSet set : this.spawnSets) {
                for (SpawnInfo info : set) {
                    ArrayList<Biome> biomes = new ArrayList<Biome>();
                    Biome.field_185377_q.forEach(biomes::add);
                    if (info.condition != null && info.condition.biomes != null && !info.condition.biomes.isEmpty()) {
                        biomes.removeIf(biome -> !info.condition.biomes.contains(biome));
                    }
                    if (info.compositeCondition != null && info.compositeCondition.conditions != null) {
                        for (SpawnCondition condition : info.compositeCondition.conditions) {
                            if (condition.biomes == null || condition.biomes.isEmpty()) continue;
                            for (Biome biome2 : condition.biomes) {
                                if (biomes.contains(biome2)) continue;
                                biomes.add(biome2);
                            }
                        }
                    }
                    for (Biome biome3 : biomes) {
                        if (!this.cacheMap.containsKey(biome3)) {
                            this.cacheMap.put(biome3, new ArrayList());
                        }
                        this.cacheMap.get(biome3).add(info);
                    }
                }
            }
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E setSelectionAlgorithm(ISelectionAlgorithm selectionAlgorithm) {
            this.selectionAlgorithm = selectionAlgorithm;
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E setCheckSpawns(ICheckSpawns checkSpawns) {
            this.checkSpawns = checkSpawns;
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E addTweak(ISpawningTweak tweak) {
            this.tweaks.add(tweak);
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E setTweaks(List<ISpawningTweak> tweaks) {
            this.tweaks = tweaks;
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E addCondition(ISpawnerCondition condition) {
            this.conditions.add(condition);
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E setConditions(List<ISpawnerCondition> conditions) {
            this.conditions = conditions;
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E addRarityMultiplier(RarityMultiplier rarityMultiplier) {
            this.rarityMultipliers.add(rarityMultiplier);
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E setRarityMultipliers(List<RarityMultiplier> rarityMultipliers) {
            this.rarityMultipliers = rarityMultipliers;
            return (E)((SpawnerBuilder)this.getThis());
        }

        public T apply(T spawner) {
            ((AbstractSpawner)spawner).spawnSets = this.spawnSets;
            ((AbstractSpawner)spawner).selectionAlgorithm = this.selectionAlgorithm;
            ((AbstractSpawner)spawner).checkSpawns = this.checkSpawns;
            ((AbstractSpawner)spawner).tweaks = new ArrayList<ISpawningTweak>(this.tweaks);
            ((AbstractSpawner)spawner).conditions = this.conditions;
            ((AbstractSpawner)spawner).rarityMultipliers = this.rarityMultipliers;
            if (this.cacheMap != null && !this.cacheMap.isEmpty()) {
                ((AbstractSpawner)spawner).cacheSets = this.cacheMap;
            }
            Pixelmon.EVENT_BUS.post((Event)new CreateSpawnerEvent((AbstractSpawner)spawner, this));
            return spawner;
        }

        protected <E> E getThis() {
            return (E)this;
        }
    }
}

