/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon;

import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.FormData;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.EnumGreninja;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ImportExportForm {
    private static ImportExportForm instance;
    private Map<EnumSpecies, Map<Short, String>> speciesMap = new HashMap<EnumSpecies, Map<Short, String>>();
    private Map<String, FormData> nameMap = new HashMap<String, FormData>();

    static ImportExportForm getInstance() {
        if (instance == null) {
            instance = new ImportExportForm();
        }
        return instance;
    }

    private ImportExportForm() {
        this.addFormData(EnumSpecies.Unown, (short)0, "");
        this.addFormData(EnumSpecies.Unown, (short)26, "?");
        this.addFormData(EnumSpecies.Unown, (short)27, "!");
        for (short i = 1; i < 26; i = (short)(i + 1)) {
            this.addFormData(EnumSpecies.Unown, i, Character.toString((char)(65 + i)));
        }
        String[] burmyForms = new String[]{"Sandy", "Trash"};
        this.addSpeciesFormData(EnumSpecies.Burmy, burmyForms);
        this.addSpeciesFormData(EnumSpecies.Wormadam, burmyForms);
        this.addSpeciesFormData(EnumSpecies.Castform, "Snowy", "Rainy", "Sunny");
        this.addSpeciesFormData(EnumSpecies.Deoxys, "attack", "Defense", "speed");
    }

    private void addSpeciesFormData(EnumSpecies species, String ... formNames) {
        this.addFormData(species, (short)0, "");
        for (int i = 0; i < formNames.length; i = (int)((short)(i + 1))) {
            String formName = formNames[i];
            this.addFormData(species, (short)(i + 1), formName);
        }
    }

    private void addFormData(EnumSpecies species, short formIndex, String formName) {
        Map<Object, Object> formMap;
        if (this.speciesMap.containsKey(species)) {
            formMap = this.speciesMap.get(species);
        } else {
            formMap = new HashMap();
            this.speciesMap.put(species, formMap);
        }
        String fullFormName = species.name;
        if (!formName.isEmpty()) {
            fullFormName = fullFormName + "-" + formName;
        }
        formMap.put(formIndex, fullFormName);
        this.nameMap.put(fullFormName, new FormData(species, formIndex));
    }

    String getFormName(EnumSpecies species, short formIndex) {
        IEnumForm form = species.getFormEnum(formIndex);
        if (!(form.isDefaultForm() || form.getFormSuffix().isEmpty() || form instanceof Gender)) {
            if (form == EnumGreninja.BATTLE_BOND) {
                return species.name;
            }
            String s = form.getFormSuffix();
            if (s.equals("alolan")) {
                s = "alola";
            }
            return species.name + "-" + s.substring(1, 2).toUpperCase() + s.substring(2);
        }
        return species.name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Optional<FormData> getFormData(String formName) {
        EnumSpecies species;
        if (!formName.contains("-")) return Optional.empty();
        String pokemon = formName.substring(0, formName.indexOf("-"));
        String form = formName.substring(formName.indexOf("-"));
        if (form.equalsIgnoreCase("-alola")) {
            form = "-alolan";
        }
        if ((species = EnumSpecies.getFromNameAnyCase(pokemon)) == null) return Optional.empty();
        for (IEnumForm enumForm : EnumSpecies.formList.get((Object)species)) {
            if (!enumForm.getFormSuffix().equalsIgnoreCase(form)) continue;
            return Optional.of(new FormData(species, enumForm.getForm()));
        }
        if (!this.nameMap.containsKey(formName)) return Optional.empty();
        return Optional.of(this.nameMap.get(formName));
    }
}

