/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.moveskills;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.moveskills.MoveSkillCooldownEvent;
import com.pixelmonmod.pixelmon.api.events.moveskills.UseMoveSkillEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.moveskills.RegisterMoveSkillPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MoveSkill {
    public static final ArrayList<MoveSkill> moveSkills = new ArrayList();
    public final ResourceLocation skillId;
    @Deprecated
    public String id;
    public String name;
    public ArrayList<String> descriptions = new ArrayList();
    public ResourceLocation sprite;
    public int cooldownTicks = 100;
    public int range = 3;
    public ArrayList<Integer> anyMoves = new ArrayList();
    public ArrayList<Integer> combinationMoves = new ArrayList();
    public ArrayList<PokemonSpec> ableSpecs = new ArrayList();
    public ArrayList<PokemonSpec> intrinsicSpecs = new ArrayList();
    public boolean usePP = false;
    public Map<EnumTargetType, BiFunction<EntityPixelmon, Object, Integer>> behaviours = new HashMap<EnumTargetType, BiFunction<EntityPixelmon, Object, Integer>>();

    @Deprecated
    public static boolean isMoveSkill(String moveSkillID) {
        return MoveSkill.getMoveSkillByID(moveSkillID) != null;
    }

    @Deprecated
    public static MoveSkill getMoveSkillByID(String moveSkillID) {
        return CollectionHelper.find(moveSkills, moveSkill -> moveSkill.id.equalsIgnoreCase(moveSkillID));
    }

    @Nullable
    public static MoveSkill findMoveSkill(ResourceLocation skillId) {
        return CollectionHelper.find(moveSkills, moveSkill -> moveSkill.skillId.equals((Object)skillId));
    }

    public static List<MoveSkill> getMoveSkills(Pokemon pokemon) {
        ArrayList moveSkills = Lists.newArrayList(MoveSkill.moveSkills);
        moveSkills.removeIf(moveSkill -> !moveSkill.hasMoveSkill(pokemon));
        return moveSkills;
    }

    public MoveSkill(ResourceLocation id) {
        this.skillId = id;
        this.id = id.toString();
        this.name = id.func_110623_a();
    }

    @Deprecated
    public MoveSkill(String id) {
        this.skillId = new ResourceLocation("unknown", id);
        this.id = id;
        this.name = id;
    }

    public MoveSkill describe(String ... descriptions) {
        Collections.addAll(this.descriptions, descriptions);
        return this;
    }

    public void onUsed(EntityPixelmon pixelmon, Object data, EnumTargetType targetType) {
        int cooldownTicks;
        if (targetType == EnumTargetType.PLAYER && !(data instanceof EntityPlayerMP)) {
            return;
        }
        if (targetType == EnumTargetType.POKEMON && !(data instanceof EntityPixelmon)) {
            return;
        }
        if (targetType == EnumTargetType.MISC_ENTITY && !(data instanceof EntityLivingBase)) {
            return;
        }
        if (targetType == EnumTargetType.BLOCK && !(data instanceof Tuple)) {
            return;
        }
        BiFunction<EntityPixelmon, Object, Integer> cooldown = this.behaviours.getOrDefault((Object)targetType, (p, d) -> -1);
        UseMoveSkillEvent event = new UseMoveSkillEvent(pixelmon, this, data);
        if (this.usePP && !this.checkForPP(pixelmon.getPokemonData())) {
            ChatHandler.sendFormattedChat((ICommandSender)pixelmon.func_70902_q(), TextFormatting.RED, "pixelmon.moveskill.nopp", pixelmon.func_145748_c_());
            return;
        }
        if (!Pixelmon.EVENT_BUS.post((Event)event) && (cooldownTicks = cooldown.apply(pixelmon, data).intValue()) > 0) {
            if (this.usePP) {
                this.takePP(pixelmon.getPokemonData());
            }
            MoveSkillCooldownEvent cooldownEvent = new MoveSkillCooldownEvent(pixelmon, this, cooldownTicks);
            if (event.handler != null) {
                event.handler.accept(cooldownEvent);
            } else if (Pixelmon.EVENT_BUS.post((Event)cooldownEvent) || cooldownEvent.cooldownTicks <= 0) {
                return;
            }
            this.applyCooldown(pixelmon.getPokemonData(), cooldownEvent.cooldownTicks);
        }
    }

    public void applyCooldown(Pokemon pokemon, int cooldownTicks) {
        if (cooldownTicks < 1) {
            cooldownTicks = 1;
        }
        pokemon.setMoveSkillCooldown(this, cooldownTicks);
    }

    public boolean hasMoveSkill(Pokemon pokemon) {
        if (!this.intrinsicSpecs.isEmpty() && CollectionHelper.find(this.intrinsicSpecs, spec -> spec.matches(pokemon)) != null) {
            return true;
        }
        if (!this.ableSpecs.isEmpty() && CollectionHelper.find(this.ableSpecs, spec -> spec.matches(pokemon)) == null) {
            return false;
        }
        if (!this.combinationMoves.isEmpty() && CollectionHelper.find(this.combinationMoves, moveID -> {
            try {
                return !pokemon.getMoveset().hasAttack(new Attack((int)moveID));
            }
            catch (Exception e) {
                return true;
            }
        }) != null) {
            return false;
        }
        return this.anyMoves.isEmpty() || CollectionHelper.find(this.anyMoves, moveID -> {
            try {
                return pokemon.getMoveset().hasAttack(new Attack((int)moveID));
            }
            catch (Exception e) {
                return false;
            }
        }) != null;
    }

    public ResourceLocation getID() {
        return this.skillId;
    }

    public MoveSkill setName(String name) {
        this.name = name;
        return this;
    }

    public MoveSkill setDefaultCooldownTicks(int cooldownTicks) {
        this.cooldownTicks = cooldownTicks;
        return this;
    }

    public MoveSkill setRange(int range) {
        this.range = range;
        return this;
    }

    public MoveSkill setIcon(ResourceLocation resourceLocation) {
        this.sprite = resourceLocation;
        return this;
    }

    public MoveSkill setAnyMoves(String ... anyMoves) {
        this.anyMoves = new ArrayList();
        for (String anyMove : anyMoves) {
            AttackBase ab = AttackBase.getAttackBase(anyMove).orElse(null);
            if (ab == null) continue;
            this.anyMoves.add(ab.getAttackId());
        }
        return this;
    }

    public MoveSkill setAnyMoves(ArrayList<AttackBase> anyMoves) {
        return this.setAnyMoves(anyMoves.stream().map(ab -> ab.getAttackId()).collect(Collectors.toList()));
    }

    public MoveSkill setAnyMoves(List<Integer> anyMoves) {
        this.anyMoves = Lists.newArrayList(anyMoves);
        return this;
    }

    public MoveSkill setCombinationMoves(String ... combinationMoves) {
        this.combinationMoves = new ArrayList();
        for (String combinationMove : combinationMoves) {
            AttackBase ab = AttackBase.getAttackBase(combinationMove).orElse(null);
            if (ab == null) continue;
            this.combinationMoves.add(ab.getAttackId());
        }
        return this;
    }

    public MoveSkill setCombinationMoves(ArrayList<AttackBase> combinationMoves) {
        return this.setCombinationMoves(combinationMoves.stream().map(ab -> ab.getAttackId()).collect(Collectors.toList()));
    }

    public MoveSkill setCombinationMoves(List<Integer> combinationMoves) {
        this.combinationMoves = Lists.newArrayList(combinationMoves);
        return this;
    }

    public MoveSkill setAbleSpecs(ArrayList<PokemonSpec> specs) {
        this.ableSpecs = specs;
        return this;
    }

    public MoveSkill setIntrinsicSpecs(ArrayList<PokemonSpec> specs) {
        this.intrinsicSpecs = specs;
        return this;
    }

    public MoveSkill setBehaviourNoTarget(Function<EntityPixelmon, Integer> cooldown) {
        this.behaviours.put(EnumTargetType.NOTHING, (pixelmon, Void2) -> (Integer)cooldown.apply((EntityPixelmon)((Object)pixelmon)));
        return this;
    }

    public MoveSkill setBehaviourPokemonTarget(BiFunction<EntityPixelmon, EntityPixelmon, Integer> cooldown) {
        this.behaviours.put(EnumTargetType.POKEMON, (user, target) -> (Integer)cooldown.apply((EntityPixelmon)((Object)user), (EntityPixelmon)((Object)((Object)target))));
        return this;
    }

    public MoveSkill setBehaviourBlockTarget(BiFunction<EntityPixelmon, Tuple<BlockPos, EnumFacing>, Integer> cooldown) {
        this.behaviours.put(EnumTargetType.BLOCK, (pixelmon, tup) -> (Integer)cooldown.apply((EntityPixelmon)((Object)pixelmon), (Tuple<BlockPos, EnumFacing>)((Tuple)tup)));
        return this;
    }

    public MoveSkill setBehaviourPlayerTarget(BiFunction<EntityPixelmon, EntityPlayerMP, Integer> cooldown) {
        this.behaviours.put(EnumTargetType.PLAYER, (pixelmon, playerTarget) -> (Integer)cooldown.apply((EntityPixelmon)((Object)pixelmon), (EntityPlayerMP)playerTarget));
        return this;
    }

    public MoveSkill setBehaviourMultiTarget(BiFunction<EntityPixelmon, Object, Integer> cooldown, EnumTargetType ... targetTypes) {
        for (EnumTargetType targetType : targetTypes) {
            this.behaviours.put(targetType, cooldown);
        }
        return this;
    }

    public MoveSkill setUsePP(boolean usePP) {
        this.usePP = usePP;
        return this;
    }

    public boolean hasTargetType(EnumTargetType targetType) {
        return this.behaviours.keySet().contains((Object)targetType);
    }

    public boolean checkForPP(Pokemon pokemon) {
        if (!this.intrinsicSpecs.isEmpty() && CollectionHelper.find(this.intrinsicSpecs, spec -> spec.matches(pokemon)) != null) {
            return true;
        }
        if (this.anyMoves.isEmpty() && this.combinationMoves.isEmpty()) {
            return true;
        }
        Moveset moveset = pokemon.getMoveset();
        for (Integer moveID : this.combinationMoves) {
            boolean had = false;
            for (Attack attack : moveset) {
                if (attack.getActualMove().getAttackId() != moveID.intValue()) continue;
                if (attack.pp <= 0) {
                    return false;
                }
                had = true;
            }
            if (had) continue;
            return false;
        }
        if (!this.combinationMoves.isEmpty()) {
            return true;
        }
        for (Integer moveID : this.anyMoves) {
            for (Attack attack : moveset) {
                if (attack.getActualMove().getAttackId() != moveID.intValue() || attack.pp <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public void takePP(Pokemon pokemon) {
        if (!this.intrinsicSpecs.isEmpty() && CollectionHelper.find(this.intrinsicSpecs, spec -> spec.matches(pokemon)) != null) {
            return;
        }
        if (this.anyMoves.isEmpty() && this.combinationMoves.isEmpty()) {
            return;
        }
        Moveset moveset = pokemon.getMoveset();
        block0: for (Integer moveID : this.combinationMoves) {
            for (Attack attack : moveset) {
                if (attack.getActualMove().getAttackId() != moveID.intValue() || attack.pp <= 0) continue;
                --attack.pp;
                continue block0;
            }
        }
        if (!this.combinationMoves.isEmpty()) {
            pokemon.markDirty(EnumUpdateType.Moveset);
            return;
        }
        for (Integer moveID : this.anyMoves) {
            for (Attack attack : moveset) {
                if (attack.getActualMove().getAttackId() != moveID.intValue() || attack.pp <= 0) continue;
                --attack.pp;
                pokemon.markDirty(EnumUpdateType.Moveset);
                return;
            }
        }
    }

    public void register(EntityPlayerMP player) {
        RegisterMoveSkillPacket packet = new RegisterMoveSkillPacket(this, false);
        Pixelmon.network.sendTo((IMessage)packet, player);
    }

    public void unregister(EntityPlayerMP player) {
        RegisterMoveSkillPacket packet = new RegisterMoveSkillPacket(this, true);
        Pixelmon.network.sendTo((IMessage)packet, player);
    }

    public static enum EnumTargetType {
        NOTHING,
        BLOCK,
        POKEMON,
        PLAYER,
        MISC_ENTITY;

    }
}

