/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events;

import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pokeballs.EntityPokeBall;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class CaptureEvent
extends Event {
    public final EntityPlayerMP player;
    protected EntityPixelmon pokemon;
    public final EntityPokeBall pokeball;

    private CaptureEvent(EntityPlayerMP player, EntityPixelmon pokemon, EntityPokeBall pokeball) {
        this.player = player;
        this.pokemon = pokemon;
        this.pokeball = pokeball;
    }

    public EntityPixelmon getPokemon() {
        return this.pokemon;
    }

    public void setPokemon(EntityPixelmon pokemon) {
        if (pokemon == null) {
            return;
        }
        this.pokemon = pokemon;
    }

    public static class FailedCapture
    extends CaptureEvent {
        public FailedCapture(EntityPlayerMP player, EntityPixelmon pokemon, EntityPokeBall pokeball) {
            super(player, pokemon, pokeball);
        }
    }

    @Cancelable
    public static class SuccessfulCapture
    extends CaptureEvent {
        public SuccessfulCapture(EntityPlayerMP player, EntityPixelmon pokemon, EntityPokeBall pokeball) {
            super(player, pokemon, pokeball);
        }
    }

    @Cancelable
    public static class StartCapture
    extends CaptureEvent {
        private int catchRate;
        private double ballBonus;

        public StartCapture(EntityPlayerMP player, EntityPixelmon pokemon, EntityPokeBall pokeball, int catchRate, double ballBonus) {
            super(player, pokemon, pokeball);
            this.catchRate = catchRate;
            this.ballBonus = ballBonus;
        }

        public void setCatchRate(int catchRate) {
            this.catchRate = Math.max(1, Math.min(255, catchRate));
        }

        public int getCatchRate() {
            return this.catchRate;
        }

        public void setBallBonus(double ballBonus) {
            this.ballBonus = Math.max(0.0, ballBonus);
        }

        public double getBallBonus() {
            return this.ballBonus;
        }
    }
}

