/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.dialogue;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.dialogue.Choice;
import com.pixelmonmod.pixelmon.api.events.dialogue.DialogueChoiceEvent;
import com.pixelmonmod.pixelmon.comm.packetHandlers.dialogue.SetDialogueData;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Dialogue {
    public final String name;
    private final String text;
    private final String localizedText;
    public final ArrayList<Choice> choices;

    public Dialogue(ByteBuf buffer) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        if (buffer.readBoolean()) {
            this.text = null;
            this.localizedText = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        } else {
            this.text = ByteBufUtils.readUTF8String((ByteBuf)buffer);
            this.localizedText = null;
        }
        ArrayList<Choice> choices = new ArrayList<Choice>();
        for (byte choiceCount = buffer.readByte(); choiceCount > 0; choiceCount = (byte)(choiceCount - 1)) {
            choices.add(new Choice(buffer));
        }
        this.choices = choices;
    }

    public Dialogue(String name, String text, String localizedText, ArrayList<Choice> choices) {
        this.name = name;
        this.text = text;
        this.localizedText = localizedText;
        this.choices = choices == null ? new ArrayList() : choices;
    }

    public void writeToBytes(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.name);
        buffer.writeBoolean(this.text == null);
        if (this.text == null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.localizedText);
        } else {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.text);
        }
        buffer.writeByte(this.choices.size());
        for (Choice choice : this.choices) {
            choice.toBytes(buffer);
        }
    }

    public String getText() {
        return this.text == null ? I18n.func_135052_a((String)this.localizedText, (Object[])new Object[0]) : this.text;
    }

    public void open(EntityPlayerMP ... players) {
        for (EntityPlayerMP player : players) {
            Dialogue.setPlayerDialogueData(player, Lists.newArrayList((Object[])new Dialogue[]{this}), true);
        }
    }

    public static void setPlayerDialogueData(EntityPlayerMP player, List<Dialogue> dialogues, boolean openGui) {
        HashMap<Integer, Consumer<DialogueChoiceEvent>> choiceMap = new HashMap<Integer, Consumer<DialogueChoiceEvent>>();
        for (Dialogue dialogue : dialogues) {
            for (Choice choice : dialogue.choices) {
                choiceMap.put(choice.choiceID, choice.handle);
            }
        }
        Choice.handleMap.put(player.func_110124_au(), choiceMap);
        Pixelmon.network.sendTo((IMessage)new SetDialogueData(dialogues, openGui), player);
    }

    public static DialogueBuilder builder() {
        return new DialogueBuilder();
    }

    public static class DialogueBuilder {
        private String name = "";
        private String text = null;
        private String localizedText = null;
        private ArrayList<Choice> choices = new ArrayList();

        public Dialogue build() {
            return new Dialogue(this.name, this.text, this.localizedText, this.choices);
        }

        public DialogueBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public DialogueBuilder setText(String text) {
            if (this.localizedText != null) {
                throw new IllegalStateException("You must use setText() OR setLocalizedText(), you can't use both.");
            }
            this.text = text;
            return this;
        }

        public DialogueBuilder setLocalizedText(String localizedText) {
            if (this.text != null) {
                throw new IllegalStateException("You must use setText() OR setLocalizedText(), you can't use both.");
            }
            this.localizedText = localizedText;
            return this;
        }

        public DialogueBuilder addChoice(Choice choice) {
            this.choices.add(choice);
            return this;
        }

        public DialogueBuilder setChoices(ArrayList<Choice> choices) {
            this.choices = choices;
            return this;
        }

        public void open(EntityPlayerMP ... players) {
            this.build().open(players);
        }
    }
}

