/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.tinylog.provider.ContextProvider;

public class TinylogContextProvider
implements ContextProvider {
    private final ThreadLocal<Map<String, String>> data = new InheritableEmptyMapThreadLocal<String, String>();

    @Override
    public Map<String, String> getMapping() {
        return this.data.get();
    }

    @Override
    public String get(String key) {
        return this.data.get().get(key);
    }

    @Override
    public void put(String key, Object value) {
        HashMap<String, String> map = new HashMap<String, String>(this.data.get());
        if (value == null) {
            map.remove(key);
        } else {
            map.put(key, value.toString());
        }
        this.data.set(Collections.unmodifiableMap(map));
    }

    @Override
    public void remove(String key) {
        HashMap<String, String> map = new HashMap<String, String>(this.data.get());
        map.remove(key);
        this.data.set(map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(map));
    }

    @Override
    public void clear() {
        this.data.set(Collections.emptyMap());
    }

    private static final class InheritableEmptyMapThreadLocal<K, V>
    extends InheritableThreadLocal<Map<K, V>> {
        private InheritableEmptyMapThreadLocal() {
        }

        @Override
        protected Map<K, V> initialValue() {
            return Collections.emptyMap();
        }
    }
}

