/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.installer.library;

import org.spongepowered.libs.Logger;
import org.tinylog.Level;
import org.tinylog.configuration.Configuration;
import org.tinylog.format.AdvancedMessageFormatter;
import org.tinylog.format.MessageFormatter;
import org.tinylog.provider.LoggingProvider;
import org.tinylog.provider.ProviderRegistry;

public final class TinyLogger
implements Logger {
    private static final MessageFormatter formatter = new AdvancedMessageFormatter(Configuration.getLocale(), Configuration.isEscapingEnabled());
    private static final LoggingProvider provider = ProviderRegistry.getLoggingProvider();
    public static final TinyLogger INSTANCE = new TinyLogger();

    private TinyLogger() {
    }

    @Override
    public void log(Logger.Level level, String message, Object ... args) {
        provider.log(2, null, this.convertLevel(level), null, formatter, (Object)message, args);
    }

    @Override
    public void log(Logger.Level level, String message, Throwable throwable) {
        provider.log(2, null, this.convertLevel(level), throwable, formatter, (Object)message, (Object[])null);
    }

    private Level convertLevel(Logger.Level level) {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case Logger.Level.DEBUG -> Level.DEBUG;
            case Logger.Level.INFO -> Level.INFO;
            case Logger.Level.WARN -> Level.WARN;
            case Logger.Level.ERROR -> Level.ERROR;
        };
    }
}

