/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.installer;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;

public final class LauncherCommandLine {
    private static final OptionParser PARSER = new OptionParser();
    private static final ArgumentAcceptingOptionSpec<Path> INSTALLER_DIRECTORY_ARG = PARSER.accepts("installerDir", "Alternative installer directory").withRequiredArg().withValuesConvertedBy(new PathConverter(PathProperties.DIRECTORY_EXISTING)).defaultsTo(Paths.get(".", new String[0]), (Path[])new Path[0]);
    private static final ArgumentAcceptingOptionSpec<String> LAUNCH_TARGET_ARG = PARSER.accepts("launchTarget", "Launch target").withRequiredArg();
    private static final NonOptionArgumentSpec<String> REMAINDER = PARSER.nonOptions().ofType(String.class);
    public static Path installerDirectory;
    public static String launchTarget;
    public static List<String> remainingArgs;

    private LauncherCommandLine() {
    }

    public static void configure(String[] args) {
        OptionSet options = PARSER.parse(args);
        installerDirectory = options.valueOf(INSTALLER_DIRECTORY_ARG);
        launchTarget = options.valueOf(LAUNCH_TARGET_ARG);
        remainingArgs = List.copyOf(options.valuesOf(REMAINDER));
    }

    static {
        PARSER.allowsUnrecognizedOptions();
    }
}

