/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.bootstrap.forge;

import cpw.mods.jarhandling.SecureJar;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.securemodules.SecureModuleClassLoader;
import net.minecraftforge.securemodules.SecureModuleFinder;
import org.spongepowered.bootstrap.Bootstrap;

public abstract class ForgeLikeBootstrap
extends Bootstrap<SecureJar> {
    private final String[] args;

    public ForgeLikeBootstrap(String[] args) {
        this.args = args;
    }

    @Override
    protected SecureJar createJar(Path[] paths) {
        return SecureJar.from(paths);
    }

    @Override
    protected String getModuleName(SecureJar jar) {
        return jar.name();
    }

    @Override
    protected ModuleFinder createModuleFinder(Collection<SecureJar> jars) {
        return SecureModuleFinder.of(jars);
    }

    @Override
    protected ClassLoader createApplicationClassLoader(Configuration config, List<ModuleLayer> parentLayers, ClassLoader parentLoader) {
        return new SecureModuleClassLoader("APP-BOOTSTRAP", null, config, parentLayers, List.of(parentLoader));
    }

    @Override
    protected void runApplication(ModuleLayer layer) throws Exception {
        Class<?> appClass = layer.findModule("cpw.mods.modlauncher").get().getClassLoader().loadClass("cpw.mods.modlauncher.Launcher");
        appClass.getDeclaredMethod("main", String[].class).invoke(null, new Object[]{this.args});
    }
}

