/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.transformers.modlauncher.jacoco;

import cpw.mods.modlauncher.TransformingClassLoader;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.transformers.modlauncher.jacoco.Instrumenter;

public class JacocoPluginService
implements ILaunchPluginService {
    private static final Logger logger = LogManager.getLogger();
    private static final String MIXIN_DESC = "Lorg/spongepowered/asm/mixin/Mixin;";
    private static final EnumSet<ILaunchPluginService.Phase> YAY = EnumSet.of(ILaunchPluginService.Phase.BEFORE);
    private static final EnumSet<ILaunchPluginService.Phase> NAY = EnumSet.noneOf(ILaunchPluginService.Phase.class);
    private boolean disabled;
    private String[] packages;
    private ClassLoader loader;

    public JacocoPluginService() {
        try {
            this.getClass().getClassLoader().loadClass("org.jacoco.core.JaCoCo");
        }
        catch (ClassNotFoundException e) {
            this.disabled = true;
            return;
        }
        this.packages = System.getProperty("sponge.jacoco.packages", "").split(",");
        for (int i = 0; i < this.packages.length; ++i) {
            String pkg = this.packages[i].replace('.', '/');
            if (pkg.endsWith("/")) continue;
            this.packages[i] = pkg + "/";
        }
    }

    public String name() {
        return "jacoco";
    }

    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty) {
        return this.disabled || isEmpty ? NAY : YAY;
    }

    private boolean testClassName(String name) {
        for (String pkg : this.packages) {
            if (!name.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int processClassWithFlags(ILaunchPluginService.Phase phase, ClassNode classNode, Type classType, String reason) {
        byte[] originalBytes;
        if ("computing_frames".equals(reason)) {
            return 0;
        }
        if (this.loader == null) {
            ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
            if (!(contextLoader instanceof TransformingClassLoader)) {
                throw new IllegalStateException("Context class loader of the first transformed class is not a transforming class loader");
            }
            this.loader = contextLoader;
        }
        if (!this.testClassName(classNode.name)) {
            return 0;
        }
        try (InputStream in = this.loader.getResourceAsStream(classNode.name + ".class");){
            if (in == null) {
                logger.warn("Failed to find original class bytes for class {}", (Object)classNode.name);
                int n = 0;
                return n;
            }
            ByteArrayOutputStream buffer222 = new ByteArrayOutputStream();
            in.transferTo(buffer222);
            originalBytes = buffer222.toByteArray();
        }
        catch (IOException e) {
            logger.warn("Failed to read original class bytes for class {}", (Object)classNode.name, (Object)e);
            return 0;
        }
        boolean mixin = false;
        if (classNode.invisibleAnnotations != null) {
            for (AnnotationNode annotation : classNode.invisibleAnnotations) {
                if (!MIXIN_DESC.equals(annotation.desc)) continue;
                mixin = true;
                break;
            }
        }
        byte[] instrumentedBytes = Instrumenter.instrument(originalBytes, mixin);
        ClassReader classReader = new ClassReader(instrumentedBytes);
        ClassNode instrumentedClassNode = new ClassNode();
        classReader.accept((ClassVisitor)instrumentedClassNode, 0);
        classNode.fields = instrumentedClassNode.fields;
        if (!mixin) {
            classNode.methods = instrumentedClassNode.methods;
            return 256;
        }
        ArrayList<MethodNode> methods = new ArrayList<MethodNode>();
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals("<init>")) continue;
            methods.add(method);
        }
        Iterator iterator = instrumentedClassNode.methods.iterator();
        while (true) {
            MethodNode method;
            if (!iterator.hasNext()) {
                classNode.methods = methods;
                return 256;
            }
            method = (MethodNode)iterator.next();
            if (method.name.equals("<init>")) continue;
            methods.add(method);
        }
    }
}

