/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.transformers.modlauncher;

import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TargetType;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class SuperclassChanger
implements ITransformationService {
    public static final String NAME = "superclass_change";
    public static final String SUPER_CLASS_EXTENSION = "superclasschange";
    public static final String MIXIN_PLUGIN_REASON = "mixin";
    public static final Supplier<TypesafeMap.Key<SuperclassChanger>> INSTANCE = IEnvironment.buildKey((String)"sponge:scc", SuperclassChanger.class);
    static final Logger LOGGER = LogManager.getLogger();
    private @MonotonicNonNull OptionSpec<String> configSpec;
    private final Map<String, String> superclassTargets = new ConcurrentHashMap<String, String>();

    public @NonNull String name() {
        return NAME;
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) {
        env.computePropertyIfAbsent(INSTANCE.get(), k -> this);
    }

    public void arguments(BiFunction<String, String, OptionSpecBuilder> argumentBuilder) {
        this.configSpec = argumentBuilder.apply("config", "An SCC file to apply at runtime").withRequiredArg().ofType(String.class);
    }

    public void argumentValues(ITransformationService.OptionResult option) {
        option.values(this.configSpec).forEach(file -> {
            LOGGER.debug("Loading SCC file: " + file);
            @Nullable URL resource = SuperclassChanger.class.getClassLoader().getResource((String)file);
            if (resource == null) {
                LOGGER.warn("Could not find SCC file: " + file);
                return;
            }
            this.offerResource(resource, "command-line");
        });
    }

    public void initialize(IEnvironment environment) {
    }

    public @NonNull List<ITransformer<?>> transformers() {
        return Collections.singletonList(new SuperclassTransformer(new ConcurrentHashMap<String, String>(this.superclassTargets)));
    }

    public void offerResource(URL resource, String name) {
        if (resource.getFile().endsWith(SUPER_CLASS_EXTENSION)) {
            try {
                LOGGER.debug("Reading superclass change {} from {}", (Object)name, (Object)resource);
                this.superclassTargets.putAll(SuperclassChanger.readMap(resource));
            }
            catch (Exception ex) {
                LOGGER.error("Failed to load superclass change {} from {}", (Object)name, (Object)resource, (Object)ex);
            }
        } else {
            LOGGER.warn("Offered superclass change {} from {} that does not end with expected extension '{}'", (Object)name, (Object)resource, (Object)SUPER_CLASS_EXTENSION);
        }
    }

    private static Map<String, String> readMap(URL resource) throws IOException {
        HashMap<String, String> targets = new HashMap<String, String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                String[] parts = line.split(":", 2);
                if (parts.length != 2) {
                    throw new IllegalArgumentException("Invalid map entry: " + line);
                }
                targets.put(parts[0], parts[1]);
            }
        }
        return targets;
    }

    static class SuperclassTransformer
    implements ITransformer<ClassNode> {
        private final ConcurrentHashMap<String, String> superclassTargets;

        public SuperclassTransformer(ConcurrentHashMap<String, String> superclassTargets) {
            this.superclassTargets = superclassTargets;
        }

        public @NonNull ClassNode transform(ClassNode input, ITransformerVotingContext context) {
            String inputKey = input.name.replace("/", ".");
            String newSuperclass = this.superclassTargets.get(inputKey);
            if (newSuperclass == null) {
                LOGGER.warn("No superclass change for {}", (Object)inputKey);
                return input;
            }
            String sanitizedSuperClass = newSuperclass.replace('.', '/');
            input.methods.forEach(m -> SuperclassTransformer.transformMethod(m, input.superName, sanitizedSuperClass));
            input.superName = sanitizedSuperClass;
            return input;
        }

        private static void transformMethod(MethodNode node, String originalSuperclass, String superClass) {
            for (MethodInsnNode insn : SuperclassTransformer.findSuper(node, originalSuperclass)) {
                insn.owner = superClass;
            }
        }

        private static List<MethodInsnNode> findSuper(MethodNode method, String originalSuperClass) {
            ArrayList<MethodInsnNode> nodes = new ArrayList<MethodInsnNode>();
            for (AbstractInsnNode node : method.instructions.toArray()) {
                if (node.getOpcode() != 183 || !originalSuperClass.equals(((MethodInsnNode)node).owner)) continue;
                nodes.add((MethodInsnNode)node);
            }
            return nodes;
        }

        public @NonNull TransformerVoteResult castVote(ITransformerVotingContext context) {
            return switch (context.getReason()) {
                case "classloading", SuperclassChanger.MIXIN_PLUGIN_REASON -> TransformerVoteResult.YES;
                default -> TransformerVoteResult.NO;
            };
        }

        public @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
        ITransformer.Target<ClassNode>> targets() {
            return this.superclassTargets.keySet().stream().map(s -> s.replace('.', '/')).map(ITransformer.Target::targetClass).collect(Collectors.toSet());
        }

        public @NonNull TargetType<ClassNode> getTargetType() {
            return TargetType.CLASS;
        }
    }
}

