/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.transformers.modlauncher;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ListenerTransformerHelper {
    public static final String LISTENER_DESC = "Lorg/spongepowered/api/event/Listener;";

    public static boolean shouldTransform(ClassNode classNode) {
        for (MethodNode method : classNode.methods) {
            if (method.visibleAnnotations == null) continue;
            for (AnnotationNode annotation : method.visibleAnnotations) {
                if (!annotation.desc.equals(LISTENER_DESC)) continue;
                return true;
            }
        }
        return false;
    }

    public static void transform(ClassNode classNode) {
        MethodNode clinit = null;
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals("<clinit>") || !method.desc.equals("()V")) continue;
            clinit = method;
            break;
        }
        if (clinit == null) {
            clinit = new MethodNode(8, "<clinit>", "()V", null, null);
            clinit.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(clinit);
        }
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new LdcInsnNode((Object)Type.getObjectType((String)classNode.name)));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/invoke/MethodHandles", "lookup", "()Ljava/lang/invoke/MethodHandles$Lookup;", false));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "org/spongepowered/common/event/ListenerLookups", "set", "(Ljava/lang/Class;Ljava/lang/invoke/MethodHandles$Lookup;)V"));
        clinit.instructions.insert(list);
    }
}

