/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.metadata.builtin;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.plugin.metadata.Inheritable;
import org.spongepowered.plugin.metadata.builtin.NullVersion;
import org.spongepowered.plugin.metadata.builtin.model.Adapters;
import org.spongepowered.plugin.metadata.builtin.model.StandardPluginBranding;
import org.spongepowered.plugin.metadata.builtin.model.StandardPluginContributor;
import org.spongepowered.plugin.metadata.builtin.model.StandardPluginDependency;
import org.spongepowered.plugin.metadata.builtin.model.StandardPluginLinks;
import org.spongepowered.plugin.metadata.model.PluginContributor;
import org.spongepowered.plugin.metadata.model.PluginDependency;
import org.spongepowered.plugin.metadata.util.GsonUtils;

public class StandardInheritable
implements Inheritable {
    protected final ArtifactVersion version;
    protected final String rawVersion;
    protected final StandardPluginBranding branding;
    protected final StandardPluginLinks links;
    protected final List<StandardPluginContributor> contributors = new LinkedList<StandardPluginContributor>();
    protected final Set<StandardPluginDependency> dependencies = new LinkedHashSet<StandardPluginDependency>();
    protected final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private final Map<String, StandardPluginDependency> dependenciesById = new LinkedHashMap<String, StandardPluginDependency>();

    protected StandardInheritable(AbstractBuilder builder) {
        this.version = builder.version;
        this.rawVersion = builder.rawVersion;
        this.branding = builder.branding;
        this.links = builder.links;
        this.contributors.addAll(builder.contributors);
        this.dependencies.addAll(builder.dependencies);
        for (StandardPluginDependency dependency : this.dependencies) {
            this.dependenciesById.put(dependency.id(), dependency);
        }
        this.properties.putAll(builder.properties);
    }

    @Override
    public ArtifactVersion version() {
        return this.version;
    }

    @Override
    public StandardPluginBranding branding() {
        return this.branding;
    }

    @Override
    public StandardPluginLinks links() {
        return this.links;
    }

    @Override
    public List<PluginContributor> contributors() {
        return Collections.unmodifiableList(this.contributors);
    }

    @Override
    public Optional<PluginDependency> dependency(String id) {
        return Optional.ofNullable((PluginDependency)this.dependenciesById.get(Objects.requireNonNull(id, "id")));
    }

    @Override
    public Set<PluginDependency> dependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    @Override
    public <T> Optional<T> property(String key) {
        return Optional.ofNullable(this.properties.get(Objects.requireNonNull(key, "key")));
    }

    @Override
    public Map<String, Object> properties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String toString() {
        return this.stringJoiner().toString();
    }

    protected StringJoiner stringJoiner() {
        return new StringJoiner(", ", StandardInheritable.class.getSimpleName() + "[", "]").add("version=" + this.rawVersion).add("branding=" + this.branding).add("links=" + this.links).add("contributors=" + this.contributors).add("dependencies=" + this.dependencies).add("properties=" + this.properties);
    }

    public static abstract class AbstractBuilder<T extends Inheritable, B extends AbstractBuilder<T, B>> {
        final List<StandardPluginContributor> contributors = new LinkedList<StandardPluginContributor>();
        final Set<StandardPluginDependency> dependencies = new LinkedHashSet<StandardPluginDependency>();
        final Map<String, Object> properties = new LinkedHashMap<String, Object>();
        ArtifactVersion version = NullVersion.instance();
        String rawVersion = "null";
        StandardPluginBranding branding = StandardPluginBranding.none();
        StandardPluginLinks links = StandardPluginLinks.none();

        protected AbstractBuilder() {
        }

        public B version(@Nullable String version) {
            if (version == null) {
                this.version = NullVersion.instance();
                this.rawVersion = "null";
            } else {
                this.version = new DefaultArtifactVersion(Objects.requireNonNull(version, "version"));
                this.rawVersion = version;
            }
            return (B)this;
        }

        public B branding(StandardPluginBranding branding) {
            this.branding = Objects.requireNonNull(branding, "branding");
            return (B)this;
        }

        public B links(StandardPluginLinks links) {
            this.links = Objects.requireNonNull(links, "links");
            return (B)this;
        }

        public B contributors(Collection<StandardPluginContributor> contributors) {
            this.contributors.addAll(Objects.requireNonNull(contributors, "contributors"));
            return (B)this;
        }

        public B addContributor(StandardPluginContributor contributor) {
            this.contributors.add(Objects.requireNonNull(contributor, "contributor"));
            return (B)this;
        }

        public B dependencies(Collection<StandardPluginDependency> dependencies) {
            this.dependencies.addAll(Objects.requireNonNull(dependencies, "dependencies"));
            return (B)this;
        }

        public B addDependency(StandardPluginDependency dependency) {
            this.dependencies.add(Objects.requireNonNull(dependency, "dependency"));
            return (B)this;
        }

        public B properties(Map<String, Object> properties) {
            this.properties.putAll(Objects.requireNonNull(properties, "properties"));
            return (B)this;
        }

        public B property(String key, Object value) {
            this.properties.put(Objects.requireNonNull(key, "key"), Objects.requireNonNull(value, "value"));
            return (B)this;
        }

        public B from(StandardInheritable value) {
            if (this.version == NullVersion.instance()) {
                this.version = value.version();
                this.rawVersion = value.rawVersion;
            }
            if (this.branding == StandardPluginBranding.none()) {
                this.branding = value.branding();
            }
            if (this.links == StandardPluginLinks.none()) {
                this.links = value.links;
            }
            this.contributors.addAll(value.contributors);
            this.dependencies.addAll(value.dependencies);
            for (Map.Entry<String, Object> entry : value.properties().entrySet()) {
                this.properties.putIfAbsent(entry.getKey(), entry.getValue());
            }
            return (B)this;
        }

        public final T build() {
            Objects.requireNonNull(this.version, "version");
            return this.build0();
        }

        protected abstract T build0();
    }

    public static final class Serializer
    implements JsonSerializer<StandardInheritable>,
    JsonDeserializer<StandardInheritable> {
        public StandardInheritable deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = element.getAsJsonObject();
            Builder builder = new Builder();
            builder.version(GsonUtils.get(obj, "version", JsonElement::getAsString).orElse(null));
            GsonUtils.consumeIfPresent(obj, "branding", e -> builder.branding(((StandardPluginBranding.Builder)Adapters.Deserializers.PLUGIN_BRANDING.fromJsonTree(e)).build()));
            GsonUtils.consumeIfPresent(obj, "links", e -> builder.links(((StandardPluginLinks.Builder)Adapters.Deserializers.PLUGIN_LINKS.fromJsonTree(e)).build()));
            GsonUtils.consumeIfPresent(obj, "contributors", e -> builder.contributors(GsonUtils.read((JsonArray)e, Adapters.Deserializers.PLUGIN_CONTRIBUTOR, LinkedList::new).stream().map(StandardPluginContributor.Builder::build).collect(Collectors.toList())));
            GsonUtils.consumeIfPresent(obj, "dependencies", e -> builder.dependencies(GsonUtils.read((JsonArray)e, Adapters.Deserializers.PLUGIN_DEPENDENCY, LinkedHashSet::new).stream().map(StandardPluginDependency.Builder::build).collect(Collectors.toList())));
            GsonUtils.consumeIfPresent(obj, "properties", e -> builder.properties(GsonUtils.read((JsonObject)e, JsonElement::getAsString, LinkedHashMap::new)));
            return (StandardInheritable)builder.build();
        }

        public JsonElement serialize(StandardInheritable value, Type type, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            GsonUtils.applyIfValid(obj, value, p -> p.version != NullVersion.instance(), (o, v) -> o.addProperty("version", v.rawVersion));
            GsonUtils.applyIfValid(obj, value, p -> p.branding != StandardPluginBranding.none(), (o, v) -> o.add("branding", Adapters.Serializers.PLUGIN_BRANDING.toJsonTree((Object)v.branding)));
            GsonUtils.applyIfValid(obj, value, p -> p.links != StandardPluginLinks.none(), (o, v) -> o.add("links", Adapters.Serializers.PLUGIN_LINKS.toJsonTree((Object)v.links)));
            GsonUtils.applyIfValid(obj, value, p -> !p.contributors.isEmpty(), (o, v) -> o.add("contributors", (JsonElement)GsonUtils.write(Adapters.Serializers.PLUGIN_CONTRIBUTOR, v.contributors)));
            GsonUtils.applyIfValid(obj, value, p -> !p.dependencies.isEmpty(), (o, v) -> o.add("dependencies", (JsonElement)GsonUtils.write(Adapters.Serializers.PLUGIN_DEPENDENCY, v.dependencies)));
            GsonUtils.applyIfValid(obj, value, p -> !p.properties.isEmpty(), (o, v) -> o.add("properties", (JsonElement)GsonUtils.write(e -> new JsonPrimitive(e.toString()), v.properties)));
            return obj;
        }
    }

    public static final class Builder
    extends AbstractBuilder<StandardInheritable, Builder> {
        @Override
        protected StandardInheritable build0() {
            return new StandardInheritable(this);
        }
    }
}

