/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.builtin.jvm.locator;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.spongepowered.plugin.Environment;
import org.spongepowered.plugin.builtin.jvm.JVMKeys;
import org.spongepowered.plugin.builtin.jvm.JVMPluginResource;
import org.spongepowered.plugin.builtin.jvm.locator.JVMPluginResourceLocatorService;

public final class EnvironmentPluginResourceLocatorService
implements JVMPluginResourceLocatorService {
    @Override
    public String name() {
        return "java_environment";
    }

    @Override
    public Set<JVMPluginResource> locatePluginResources(Environment environment) {
        Optional<String> envName = environment.blackboard().find(JVMKeys.ENVIRONMENT_LOCATOR_VARIABLE_NAME);
        if (envName.isEmpty()) {
            environment.logger().debug("Locator '{}' is disabled.", (Object)this.name());
            return Collections.emptySet();
        }
        environment.logger().info("Locating '{}' resources...", (Object)this.name());
        HashSet<JVMPluginResource> resources = new HashSet<JVMPluginResource>();
        String env = System.getenv(envName.get());
        if (env != null) {
            for (String entry : env.split(";")) {
                if (entry.isBlank()) continue;
                Path[] paths = (Path[])Stream.of(entry.split("&")).map(x$0 -> Path.of(x$0, new String[0])).toArray(Path[]::new);
                resources.add(JVMPluginResource.create(environment, this.name(), paths));
            }
        }
        environment.logger().info("Located [{}] resource(s) for '{}'...", (Object)resources.size(), (Object)this.name());
        return resources;
    }
}

