/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.builtin.jvm;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.Manifest;
import org.spongepowered.plugin.Environment;
import org.spongepowered.plugin.PluginResource;
import org.spongepowered.plugin.builtin.jvm.JVMKeys;

public interface JVMPluginResource
extends PluginResource {
    public Manifest manifest();

    public Path resourcesRoot();

    @Override
    default public Optional<String> property(String key) {
        return Optional.ofNullable(this.manifest().getMainAttributes().getValue(Objects.requireNonNull(key, "key")));
    }

    @Override
    default public Optional<URI> locateResource(String path) {
        Path p = this.resourcesRoot().resolve(path);
        return Files.exists(p, new LinkOption[0]) ? Optional.of(p.toUri()) : Optional.empty();
    }

    public static JVMPluginResource create(Environment environment, String locator, Path ... paths) {
        return environment.blackboard().get(JVMKeys.JVM_PLUGIN_RESOURCE_FACTORY).create(locator, paths);
    }

    public static interface Factory {
        public JVMPluginResource create(String var1, Path[] var2);
    }
}

