/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.builtin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.plugin.Environment;
import org.spongepowered.plugin.PluginCandidate;
import org.spongepowered.plugin.PluginLanguageService;
import org.spongepowered.plugin.PluginResource;
import org.spongepowered.plugin.blackboard.Keys;
import org.spongepowered.plugin.builtin.StandardPluginCandidate;
import org.spongepowered.plugin.metadata.Container;
import org.spongepowered.plugin.metadata.PluginMetadata;
import org.spongepowered.plugin.metadata.builtin.MetadataParser;

public abstract class StandardPluginLanguageService
implements PluginLanguageService {
    protected final Logger logger = LogManager.getLogger((String)this.name());

    @Override
    public void initialize(Environment environment) {
    }

    @Override
    public List<PluginCandidate> createPluginCandidates(Environment environment, PluginResource resource) throws Exception {
        Objects.requireNonNull(environment, "environment");
        Objects.requireNonNull(resource, "resource");
        String metadataPath = environment.blackboard().get(Keys.METADATA_FILE_PATH);
        LinkedList<PluginCandidate> candidates = new LinkedList<PluginCandidate>();
        Optional<InputStream> optStream = resource.openResource(metadataPath);
        if (optStream.isEmpty()) {
            this.logger.debug("Container in path '{}' doesn't have a metadata file, skipping...", (Object)resource.path());
            return candidates;
        }
        try (InputStream stream = optStream.get();){
            Container container = this.loadMetadataContainer(environment, stream);
            if (!container.loader().name().equals(this.name())) {
                throw new IOException(String.format("Attempt made to load Container in path '%s' with loader '%s' yet it requires '%s'!", resource.path(), this.name(), container.loader().name()));
            }
            if (!this.isValidContainer(environment, container)) {
                this.logger.debug("Container in path '{}' with loader '{}' is not valid, skipping...", (Object)resource.path(), (Object)container.loader().name());
            } else {
                boolean containerHasMetadata = false;
                for (PluginMetadata metadata : container.metadata()) {
                    if (!this.isValidMetadata(environment, metadata)) {
                        this.logger.debug("PluginMetadata '{}' within Container in path '{}' with loader '{}' is not valid, skipping...", (Object)metadata.id(), (Object)resource.path(), (Object)container.loader().name());
                        continue;
                    }
                    containerHasMetadata = true;
                    candidates.add(new StandardPluginCandidate(metadata, resource));
                }
                if (!containerHasMetadata) {
                    this.logger.debug("Container in path '{}' with loader '{}' has no plugin metadata, skipping...", (Object)resource.path(), (Object)container.loader().name());
                }
            }
        }
        return candidates;
    }

    protected Container loadMetadataContainer(Environment environment, InputStream stream) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        return MetadataParser.read(reader);
    }

    protected boolean isValidContainer(Environment environment, Container container) {
        return true;
    }

    protected boolean isValidMetadata(Environment environment, PluginMetadata metadata) {
        return true;
    }
}

