/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.builtin;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.plugin.PluginCandidate;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.metadata.PluginMetadata;

public class StandardPluginContainer
implements PluginContainer {
    private final PluginCandidate candidate;
    private final Logger logger;
    private Object instance;

    public StandardPluginContainer(PluginCandidate candidate) {
        this(Objects.requireNonNull(candidate, "candidate"), LogManager.getLogger((String)candidate.metadata().id()));
    }

    public StandardPluginContainer(PluginCandidate candidate, Logger logger) {
        this.candidate = Objects.requireNonNull(candidate, "candidate");
        this.logger = Objects.requireNonNull(logger, "logger");
    }

    @Override
    public final PluginMetadata metadata() {
        return this.candidate.metadata();
    }

    @Override
    public final Logger logger() {
        return this.logger;
    }

    @Override
    public final Object instance() {
        return this.instance;
    }

    protected void initializeInstance(Object instance) {
        if (this.instance != null) {
            throw new RuntimeException(String.format("Attempt made to set the plugin within container '%s' twice!", this.candidate.metadata().id()));
        }
        this.instance = Objects.requireNonNull(instance, "instance");
    }

    @Override
    public Optional<URI> locateResource(String path) {
        return this.candidate.resource().locateResource(path);
    }

    public int hashCode() {
        return Objects.hashCode(this.candidate.metadata().id());
    }

    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        if (!(that instanceof PluginContainer)) {
            return false;
        }
        return this.candidate.metadata().id().equals(((PluginContainer)that).metadata().id());
    }

    protected StringJoiner toStringJoiner() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("metadata=" + String.valueOf(this.candidate.metadata()));
    }

    public final String toString() {
        return this.toStringJoiner().toString();
    }
}

