/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.libs;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.spongepowered.libs.Logger;

public final class LibraryUtils {
    private static final char[] hexChars = "0123456789abcdef".toCharArray();

    private LibraryUtils() {
    }

    public static <T> CompletableFuture<T> asyncFailableFuture(Callable<T> action, Executor executor) {
        CompletableFuture future = new CompletableFuture();
        executor.execute(() -> {
            try {
                future.complete(action.call());
            }
            catch (Exception ex) {
                future.completeExceptionally(ex);
            }
        });
        return future;
    }

    public static String toHexString(byte[] bytes) {
        char[] chars = new char[bytes.length << 1];
        int i = 0;
        for (byte b : bytes) {
            chars[i++] = hexChars[b >> 4 & 0xF];
            chars[i++] = hexChars[b & 0xF];
        }
        return new String(chars);
    }

    public static boolean validateDigest(String algorithm, String expectedHash, Path path) throws IOException, NoSuchAlgorithmException {
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            boolean bl = LibraryUtils.validateDigest(algorithm, expectedHash, in);
            return bl;
        }
    }

    public static boolean validateDigest(String algorithm, String expectedHash, InputStream stream) throws IOException, NoSuchAlgorithmException {
        int read;
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        byte[] buf = new byte[4096];
        while ((read = stream.read(buf)) != -1) {
            digest.update(buf, 0, read);
        }
        return expectedHash.equals(LibraryUtils.toHexString(digest.digest()));
    }

    public static void download(Logger logger, URL url, Path file, boolean requiresRequest) throws IOException {
        block25: {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            String name = file.getFileName().toString();
            logger.info("Downloading {}. This may take a while...", name);
            logger.debug("URL -> <{}>", url);
            if (!requiresRequest) {
                try (ReadableByteChannel in = Channels.newChannel(url.openStream());
                     FileChannel out = FileChannel.open(file, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                    out.transferFrom(in, 0L, Long.MAX_VALUE);
                    break block25;
                }
            }
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("User-Agent", "Sponge-Downloader");
            connection.connect();
            try (ReadableByteChannel in = Channels.newChannel(connection.getInputStream());
                 FileChannel out = FileChannel.open(file, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                out.transferFrom(in, 0L, Long.MAX_VALUE);
            }
        }
    }

    public static void downloadAndVerifyDigest(Logger logger, URL url, Path file, String algorithm, String expected) throws IOException, NoSuchAlgorithmException {
        String name = file.getFileName().toString();
        logger.info("Downloading {}. This may take a while...", name);
        logger.debug("URL -> <{}>", url);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", "Sponge-Downloader");
        connection.connect();
        try (InputStream in = connection.getInputStream();){
            LibraryUtils.transferAndVerifyDigest(logger, in, file, algorithm, expected);
        }
    }

    public static void transferAndVerifyDigest(Logger logger, InputStream source, Path file, String algorithm, String expected) throws IOException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        String name = file.getFileName().toString();
        try (DigestInputStream stream = new DigestInputStream(source, digest);
             ReadableByteChannel in = Channels.newChannel(stream);
             FileChannel out = FileChannel.open(file, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
            out.transferFrom(in, 0L, Long.MAX_VALUE);
        }
        String fileDigest = LibraryUtils.toHexString(digest.digest());
        if (!expected.equals(fileDigest)) {
            Files.delete(file);
            throw new IOException(String.format("Checksum verification for %s failed: Expected '%s', got '%s'.", name, expected, fileDigest));
        }
        logger.info("Successfully processed {} and verified checksum!", name);
    }
}

