/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.applaunch.transformation;

import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.forge.applaunch.transformation.ListenerTransformer;
import org.spongepowered.transformers.modlauncher.AccessWidenerTransformationService;
import org.spongepowered.transformers.modlauncher.SuperclassChanger;

public class SpongeForgeTransformationService
implements ITransformationService {
    private static final Logger LOGGER = LogManager.getLogger();

    public @NonNull String name() {
        return "spongeforge";
    }

    public void initialize(IEnvironment environment) {
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) {
    }

    public List<ITransformationService.Resource> completeScan(IModuleLayerManager layerManager) {
        Environment env = Launcher.INSTANCE.environment();
        AccessWidenerTransformationService accessWidener = env.getProperty(AccessWidenerTransformationService.INSTANCE.get()).orElse(null);
        SuperclassChanger superclassChanger = env.getProperty(SuperclassChanger.INSTANCE.get()).orElse(null);
        if (accessWidener != null || superclassChanger != null) {
            for (ModFileInfo fileInfo : LoadingModList.get().getModFiles()) {
                String scPaths;
                String jarFileName;
                String awPaths;
                SecureJar jar = fileInfo.getFile().getSecureJar();
                Attributes attributes = jar.moduleDataProvider().getManifest().getMainAttributes();
                if (accessWidener != null && (awPaths = attributes.getValue("Access-Widener")) != null) {
                    jarFileName = fileInfo.getFile().getFileName();
                    LOGGER.debug("Registering access wideners from {} ...", (Object)jarFileName);
                    for (String awPath : awPaths.split(",")) {
                        try {
                            accessWidener.offerResource(jar.getPath(awPath, new String[0]).toUri().toURL(), awPath);
                        }
                        catch (MalformedURLException e) {
                            LOGGER.warn("Failed to register access widener {} from {}", (Object)awPath, (Object)jarFileName, (Object)e);
                        }
                    }
                }
                if (superclassChanger == null || (scPaths = attributes.getValue("Superclass-Transformer")) == null) continue;
                jarFileName = fileInfo.getFile().getFileName();
                LOGGER.debug("Registering superclass changers from {} ...", (Object)jarFileName);
                for (String scPath : scPaths.split(",")) {
                    try {
                        superclassChanger.offerResource(jar.getPath(scPath, new String[0]).toUri().toURL(), scPath);
                    }
                    catch (MalformedURLException e) {
                        LOGGER.warn("Failed to register superclass changer {} from {}", (Object)scPath, (Object)jarFileName, (Object)e);
                    }
                }
            }
        }
        return List.of();
    }

    public @NonNull List<ITransformer> transformers() {
        return List.of(new ListenerTransformer());
    }
}

