/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.applaunch.loading.moddiscovery.locator;

import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.ModDirTransformerDiscoverer;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.common.applaunch.AppLaunch;
import org.spongepowered.forge.applaunch.loading.moddiscovery.AbstractModProvider;
import org.spongepowered.forge.applaunch.loading.moddiscovery.PluginFileParser;

public final class PluginsDirectoryLocator
extends AbstractModProvider
implements IModLocator {
    private static final Logger LOGGER = LogManager.getLogger();

    public List<IModLocator.ModFileOrException> scanMods() {
        List<Path> pluginDirectories = AppLaunch.pluginPlatform().pluginDirectories();
        ArrayList<IModLocator.ModFileOrException> modFiles = new ArrayList<IModLocator.ModFileOrException>();
        for (Path pluginDirectory : pluginDirectories) {
            LOGGER.debug("Scanning plugins directory '{}' for plugins", (Object)pluginDirectory);
            this.scanForPluginsIn(pluginDirectory).map(f -> new IModLocator.ModFileOrException((IModFile)f, null)).forEach(modFiles::add);
        }
        return modFiles;
    }

    private Stream<ModFile> scanForPluginsIn(Path pluginsDirectory) {
        List excluded = ModDirTransformerDiscoverer.allExcluded();
        return ((Stream)LamdbaExceptionUtils.uncheck(() -> Files.list(pluginsDirectory))).filter(p -> !excluded.contains(p) && StringUtils.toLowerCase((String)p.getFileName().toString()).endsWith(".jar")).sorted(Comparator.comparing(path -> StringUtils.toLowerCase((String)path.getFileName().toString()))).map(p -> PluginFileParser.newModFile(this, false, p)).filter(ModFile::identifyMods);
    }

    public String name() {
        return "plugins directory";
    }
}

