/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.applaunch.loading.moddiscovery;

import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import java.io.BufferedReader;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import net.minecraftforge.fml.loading.moddiscovery.AbstractModProvider;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.ModFileParser;
import net.minecraftforge.fml.loading.moddiscovery.ModJarMetadata;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModProvider;
import org.spongepowered.common.applaunch.AppLaunch;
import org.spongepowered.common.applaunch.metadata.PluginMetadataFixer;
import org.spongepowered.forge.applaunch.loading.metadata.PluginFileConfigurable;
import org.spongepowered.plugin.metadata.builtin.MetadataContainer;
import org.spongepowered.plugin.metadata.builtin.MetadataParser;

public final class PluginFileParser {
    private static final String MODS_TOML = "META-INF/mods.toml";
    private static final String MODULE_INFO = "module-info.class";
    private static Constructor<ModJarMetadata> modJarMetadataConstructor;

    private static IModFileInfo parsePluginFileInfo(IModFile iModFile) {
        ModFile modFile = (ModFile)iModFile;
        AppLaunch.logger().debug("Considering plugin file candidate {}", (Object)modFile.getFilePath());
        Path metadataFile = modFile.findResource(new String[]{"META-INF/sponge_plugins.json"});
        if (Files.notExists(metadataFile, new LinkOption[0])) {
            AppLaunch.logger().debug("Plugin file '{}' is missing a 'sponge_plugins.json' metadata file in META-INF", (Object)modFile);
            return null;
        }
        try {
            MetadataContainer container;
            try (BufferedReader reader = Files.newBufferedReader(metadataFile, StandardCharsets.UTF_8);){
                container = MetadataParser.read(reader);
            }
            PluginFileConfigurable config = new PluginFileConfigurable(PluginMetadataFixer.fixPluginIds(container));
            return new ModFileInfo(modFile, (IConfigurable)config, info -> {}, List.of());
        }
        catch (Exception e) {
            AppLaunch.logger().warn("Could not read metadata for plugin file '{}'", (Object)modFile, (Object)e);
            return null;
        }
    }

    private static IModFileInfo parseModFileInfo(IModFile iModFile) {
        return ModFileParser.modsTomlParser((IModFile)iModFile);
    }

    private static IModFileInfo parseLibraryFileInfo(IModFile iModFile) {
        return DummyModProvider.INSTANCE.manifestParser(iModFile);
    }

    private static ModJarMetadata newModJarMetadata() {
        try {
            return modJarMetadataConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean useModJarMetadata(SecureJar jar) {
        SecureJar.ModuleDataProvider data = jar.moduleDataProvider();
        if (data.findFile(MODULE_INFO).isPresent()) {
            return false;
        }
        return data.findFile(MODS_TOML).isPresent() || data.findFile("META-INF/sponge_plugins.json").isPresent();
    }

    public static ModFile newModFile(IModProvider provider, boolean allowUnknown, Path ... paths) {
        ModJarMetadata mjm = PluginFileParser.newModJarMetadata();
        SecureJar jar = SecureJar.from(j -> PluginFileParser.useModJarMetadata(j) ? mjm : JarMetadata.from((SecureJar)j, (Path[])paths), (Path[])paths);
        SecureJar.ModuleDataProvider data = jar.moduleDataProvider();
        String type = data.getManifest().getMainAttributes().getValue("FMLModType");
        if (data.findFile(MODS_TOML).isPresent()) {
            ModFile modFile = new ModFile(jar, provider, PluginFileParser::parseModFileInfo, type == null ? "MOD" : type);
            mjm.setModFile((IModFile)modFile);
            return modFile;
        }
        if (data.findFile("META-INF/sponge_plugins.json").isPresent()) {
            ModFile modFile = new ModFile(jar, provider, PluginFileParser::parsePluginFileInfo, type == null ? "MOD" : type);
            mjm.setModFile((IModFile)modFile);
            return modFile;
        }
        if (!allowUnknown && type == null) {
            throw new IllegalArgumentException("Unknown mod file type");
        }
        return new ModFile(jar, provider, PluginFileParser::parseLibraryFileInfo, type == null ? "GAMELIBRARY" : type);
    }

    public static ModFile newLibraryFile(IModProvider provider, Path ... paths) {
        SecureJar jar = SecureJar.from((Path[])paths);
        return new ModFile(jar, provider, PluginFileParser::parseLibraryFileInfo, "GAMELIBRARY");
    }

    static {
        try {
            modJarMetadataConstructor = ModJarMetadata.class.getDeclaredConstructor(new Class[0]);
            modJarMetadataConstructor.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class DummyModProvider
    extends AbstractModProvider {
        private static final DummyModProvider INSTANCE = new DummyModProvider();

        private DummyModProvider() {
        }

        public String name() {
            return "dummy";
        }

        public IModFileInfo manifestParser(IModFile mod) {
            return super.manifestParser(mod);
        }
    }
}

