/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.applaunch.loading.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModInfo;
import org.spongepowered.plugin.metadata.PluginMetadata;
import org.spongepowered.plugin.metadata.model.PluginDependency;

public final class PluginDependencyConfigurable
implements IConfigurable {
    private final PluginMetadata metadata;
    private final PluginDependency dependency;

    public PluginDependencyConfigurable(PluginMetadata metadata, PluginDependency dependency) {
        this.metadata = metadata;
        this.dependency = dependency;
    }

    public <T> Optional<T> getConfigElement(String ... key) {
        if (key.length != 1) {
            return Optional.empty();
        }
        return switch (key[0]) {
            case "modId" -> Optional.of(this.dependency.id());
            case "mandatory" -> Optional.of(!this.dependency.optional());
            case "versionRange" -> Optional.of(this.dependency.version().toString());
            case "ordering" -> Optional.of(this.loadToOrdering(this.dependency.loadOrder()).toString());
            case "side" -> Optional.of(IModInfo.DependencySide.BOTH.toString());
            default -> Optional.empty();
        };
    }

    public List<? extends IConfigurable> getConfigList(String ... key) {
        return Collections.emptyList();
    }

    private IModInfo.Ordering loadToOrdering(PluginDependency.LoadOrder order) {
        return switch (order) {
            default -> throw new MatchException(null, null);
            case PluginDependency.LoadOrder.UNDEFINED -> IModInfo.Ordering.NONE;
            case PluginDependency.LoadOrder.BEFORE -> IModInfo.Ordering.BEFORE;
            case PluginDependency.LoadOrder.AFTER -> IModInfo.Ordering.AFTER;
        };
    }
}

