/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util.helpers;

import com.pixelmonmod.pixelmon.RandomHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class CollectionHelper {
    public static <K, V> List<K> reverseMapGet(Map<K, V> map, V value) {
        ArrayList<K> keys = new ArrayList<K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }

    public static <T> T getRandomElement(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(RandomHelper.getRandomNumberBetween(0, list.size() - 1));
    }

    public static <T> boolean anyMatch(List<T> list1, List<T> list2) {
        if (list1 == null || list2 == null || list1.isEmpty() || list2.isEmpty()) {
            return false;
        }
        for (T t : list1) {
            if (!list2.contains(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsAll(List<T> baseList, List<T> mustHave) {
        for (T t : mustHave) {
            if (baseList.contains(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean containsA(Iterable<T> container, Class<? extends T> elementClass) {
        if (container != null) {
            for (T t : container) {
                if (!elementClass.isInstance(t)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static <T, E extends T> E getFirst(Iterable<T> container, Class<E> elementClass) {
        if (container != null) {
            for (T t : container) {
                if (!elementClass.isInstance(t)) continue;
                return elementClass.cast(t);
            }
        }
        return null;
    }

    public static <T, E extends T> void removeAny(List<T> list, Class<E> clazz) {
        if (list != null) {
            list.removeIf(t -> clazz.isInstance(t));
        }
    }

    @Nullable
    public static <T> T find(Iterable<T> container, Predicate<T> condition) {
        for (T t : container) {
            if (!condition.test(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> boolean some(Iterable<T> container, Predicate<T> condition) {
        return CollectionHelper.find(container, condition) != null;
    }
}

