/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util.helpers;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.pokemon.EnumInitializeCategory;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.IVStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.enums.EnumEggGroup;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.EnumAlolan;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.items.heldItems.NoItem;
import com.pixelmonmod.pixelmon.util.RegexPatterns;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.util.math.MathHelper;

public class BreedLogic {
    public static boolean canBreed(Pokemon parent1, Pokemon parent2) {
        boolean is1Ditto = parent1.isPokemon(EnumSpecies.Ditto);
        boolean is2Ditto = parent2.isPokemon(EnumSpecies.Ditto);
        if (is1Ditto || is2Ditto) {
            EnumEggGroup[] groupsNonDitto;
            if (is1Ditto && is2Ditto) {
                return PixelmonConfig.allowDittoDittoBreeding;
            }
            for (EnumEggGroup groupNonDitto : groupsNonDitto = is1Ditto ? EnumEggGroup.getEggGroups(parent2) : EnumEggGroup.getEggGroups(parent1)) {
                if (groupNonDitto != EnumEggGroup.Undiscovered) continue;
                return false;
            }
            return true;
        }
        if (parent1.getGender() == parent2.getGender()) {
            return false;
        }
        if (parent1.getGender() == Gender.None || parent2.getGender() == Gender.None) {
            return false;
        }
        return BreedLogic.getEggGroupForPair(parent1, parent2) != EnumEggGroup.Undiscovered;
    }

    public static Pokemon makeRandomEgg(Pokemon parent1, Pokemon parent2) {
        EnumSpecies species = EnumSpecies.randomPoke(PixelmonConfig.allowRandomBreedingEggsToBeLegendary);
        Pokemon pokemon = PokemonSpec.from(species.name, "lvl:1").create().makeEgg();
        pokemon.initialize(EnumInitializeCategory.SPECIES, EnumInitializeCategory.INTRINSIC);
        int slot = pokemon.getBaseStats().abilities[1] != null ? RandomHelper.getRandomNumberBetween(0, 1) : 0;
        pokemon.setAbility(pokemon.getBaseStats().abilities[slot]);
        pokemon.getIVs().CopyIVs(BreedLogic.getIVsForEgg(parent1, parent2));
        pokemon.setNature(BreedLogic.getNatureForEgg(parent1, parent2));
        pokemon.setGrowth(BreedLogic.getEggGrowth(parent1, parent2));
        pokemon.setShiny(BreedLogic.getEggIsShiny(parent1, parent2));
        return pokemon;
    }

    @Nullable
    public static Pokemon makeEgg(Pokemon parent1, Pokemon parent2) {
        if (BreedLogic.canBreed(parent1, parent2)) {
            if (parent1.isPokemon(EnumSpecies.Ditto) && parent2.isPokemon(EnumSpecies.Ditto) && PixelmonConfig.allowDittoDittoBreeding) {
                return BreedLogic.makeRandomEgg(parent1, parent2);
            }
            EnumSpecies species = BreedLogic.getPokemonInEggName(parent1, parent2);
            IEnumForm form = BreedLogic.getPokemonInEggForm(species, parent1, parent2);
            Pokemon pokemon = PokemonSpec.from(species.name, "f:" + form.getForm()).create().makeEgg();
            pokemon.getIVs().CopyIVs(BreedLogic.getIVsForEgg(parent1, parent2));
            pokemon.setNature(BreedLogic.getNatureForEgg(parent1, parent2));
            pokemon.setCaughtBall(BreedLogic.getMotherPokeball(parent1, parent2));
            pokemon.setGrowth(BreedLogic.getEggGrowth(parent1, parent2));
            pokemon.setAbility(pokemon.getBaseStats().abilities[BreedLogic.getEggAbilitySlot(pokemon, parent1, parent2)]);
            pokemon.setShiny(BreedLogic.getEggIsShiny(parent1, parent2));
            Moveset moveset = BreedLogic.getEggMoveset(pokemon, species, parent1, parent2);
            Moveset thisMoveset = pokemon.getMoveset();
            thisMoveset.set(0, moveset.get(0));
            thisMoveset.set(1, moveset.get(1));
            thisMoveset.set(2, moveset.get(2));
            thisMoveset.set(3, moveset.get(3));
            return pokemon;
        }
        Pixelmon.LOGGER.info("Error occurred in breeding; incompatible pair passed to Egg initialization.");
        return null;
    }

    public static IEnumForm getPokemonInEggForm(EnumSpecies childSpecies, Pokemon parent1, Pokemon parent2) {
        boolean isDittoBreeding = parent1.isPokemon(EnumSpecies.Ditto) || parent2.isPokemon(EnumSpecies.Ditto);
        Pokemon mother = BreedLogic.findMother(parent1, parent2);
        Pokemon father = BreedLogic.findFather(parent1, parent2);
        if (childSpecies.getPossibleForms(false).contains(EnumAlolan.ALOLAN)) {
            float chanceAlolan = 0.0f;
            if (!isDittoBreeding) {
                boolean motherAlolan = false;
                boolean fatherAlolan = false;
                if (mother != null) {
                    boolean bl = motherAlolan = mother.getFormEnum() == EnumAlolan.ALOLAN;
                }
                if (father != null) {
                    boolean bl = fatherAlolan = father.getFormEnum() == EnumAlolan.ALOLAN;
                }
                if (motherAlolan && fatherAlolan) {
                    chanceAlolan = 100.0f;
                } else if (motherAlolan) {
                    chanceAlolan = 50.0f;
                }
            } else if (parent1.getFormEnum() == EnumAlolan.ALOLAN || parent2.getFormEnum() == EnumAlolan.ALOLAN) {
                chanceAlolan = 25.0f;
            }
            if (RandomHelper.getRandomChance(chanceAlolan / 100.0f)) {
                return EnumAlolan.ALOLAN;
            }
            return EnumAlolan.NORMAL;
        }
        ArrayList inheritors = Lists.newArrayList((Object[])new EnumSpecies[]{EnumSpecies.Shellos, EnumSpecies.Burmy, EnumSpecies.Basculin, EnumSpecies.Deerling, EnumSpecies.Flabebe});
        if (inheritors.contains(childSpecies)) {
            if (mother != null && mother.getSpecies() == childSpecies) {
                return mother.getFormEnum();
            }
            if (father != null && father.getSpecies() == childSpecies) {
                return father.getFormEnum();
            }
        }
        return CollectionHelper.getRandomElement(childSpecies.getDefaultForms());
    }

    private static EnumSpecies getPokemonInEggName(Pokemon parent1, Pokemon parent2) {
        Item itemFromOtherParent;
        boolean inherit1 = !parent1.isPokemon(EnumSpecies.Ditto) && (parent2.isPokemon(EnumSpecies.Ditto) || parent2.getGender() == Gender.Male);
        Pokemon parentForEggLine = inherit1 ? parent1 : parent2;
        Item itemFromParent = parentForEggLine.getHeldItem().func_77973_b();
        Item item = itemFromOtherParent = inherit1 ? parent2.getHeldItem().func_77973_b() : parent1.getHeldItem().func_77973_b();
        if (parentForEggLine.isPokemon(EnumSpecies.Nidoranfemale, EnumSpecies.Nidoranmale, EnumSpecies.Nidorino, EnumSpecies.Nidoking)) {
            EnumSpecies[] eggForms = new EnumSpecies[]{EnumSpecies.Nidoranfemale, EnumSpecies.Nidoranmale};
            return RandomHelper.getRandomElementFromArray(eggForms);
        }
        if (parentForEggLine.isPokemon(EnumSpecies.Illumise, EnumSpecies.Volbeat)) {
            EnumSpecies[] eggForms = new EnumSpecies[]{EnumSpecies.Illumise, EnumSpecies.Volbeat};
            return RandomHelper.getRandomElementFromArray(eggForms);
        }
        if (BreedLogic.checkIncense(itemFromParent, itemFromOtherParent, parentForEggLine, PixelmonItemsHeld.seaIncense, EnumSpecies.Azurill, EnumSpecies.Marill, EnumSpecies.Azumarill)) {
            return EnumSpecies.Marill;
        }
        if (BreedLogic.checkIncense(itemFromParent, itemFromOtherParent, parentForEggLine, PixelmonItemsHeld.laxIncense, EnumSpecies.Wynaut, EnumSpecies.Wobbuffet)) {
            return EnumSpecies.Wobbuffet;
        }
        if (BreedLogic.checkIncense(itemFromParent, itemFromOtherParent, parentForEggLine, PixelmonItemsHeld.roseIncense, EnumSpecies.Budew, EnumSpecies.Roselia, EnumSpecies.Roserade)) {
            return EnumSpecies.Roselia;
        }
        if (BreedLogic.checkIncense(itemFromParent, itemFromOtherParent, parentForEggLine, PixelmonItemsHeld.pureIncense, EnumSpecies.Chingling, EnumSpecies.Chimecho)) {
            return EnumSpecies.Chimecho;
        }
        if (BreedLogic.checkIncense(itemFromParent, itemFromOtherParent, parentForEggLine, PixelmonItemsHeld.rockIncense, EnumSpecies.Bonsly, EnumSpecies.Sudowoodo)) {
            return EnumSpecies.Sudowoodo;
        }
        if (BreedLogic.checkIncense(itemFromParent, itemFromOtherParent, parentForEggLine, PixelmonItemsHeld.oddIncense, EnumSpecies.MimeJr, EnumSpecies.MrMime)) {
            return EnumSpecies.MrMime;
        }
        if (BreedLogic.checkIncense(itemFromParent, itemFromOtherParent, parentForEggLine, PixelmonItemsHeld.luckIncense, EnumSpecies.Happiny, EnumSpecies.Chansey, EnumSpecies.Blissey)) {
            return EnumSpecies.Chansey;
        }
        if (BreedLogic.checkIncense(itemFromParent, itemFromOtherParent, parentForEggLine, PixelmonItemsHeld.waveIncense, EnumSpecies.Mantyke, EnumSpecies.Mantine)) {
            return EnumSpecies.Mantine;
        }
        if (BreedLogic.checkIncense(itemFromParent, itemFromOtherParent, parentForEggLine, PixelmonItemsHeld.fullIncense, EnumSpecies.Munchlax, EnumSpecies.Snorlax)) {
            return EnumSpecies.Snorlax;
        }
        return parentForEggLine.getSpecies().getBaseSpecies();
    }

    public static EnumEggGroup getEggGroupForPair(PokemonBase parent1, PokemonBase parent2) {
        EnumEggGroup[] groups1 = EnumEggGroup.getEggGroups(parent1);
        EnumEggGroup[] groups2 = EnumEggGroup.getEggGroups(parent2);
        ArrayList<EnumEggGroup> groupsEgg = new ArrayList<EnumEggGroup>();
        for (EnumEggGroup group1 : groups1) {
            for (EnumEggGroup group2 : groups2) {
                if (group1 != group2 || group2 == EnumEggGroup.Undiscovered) continue;
                groupsEgg.add(group2);
            }
        }
        if (groupsEgg.isEmpty()) {
            return EnumEggGroup.Undiscovered;
        }
        return (EnumEggGroup)((Object)groupsEgg.get(0));
    }

    public static IVStore getIVsForEgg(Pokemon parent1, Pokemon parent2) {
        ArrayList<String> masterStatsList = new ArrayList<String>(Arrays.asList("HP1", "ATK1", "DEF1", "SPATK1", "SPDEF1", "SPD1", "HP2", "ATK2", "DEF2", "SPATK2", "SPDEF2", "SPD2"));
        ArrayList<String> strStatsToInherit = new ArrayList<String>();
        IVStore newIVs = IVStore.CreateNewIVs();
        int intNumberToInherit = 3;
        ItemHeld heldItem1 = parent1.getHeldItemAsItemHeld();
        ItemHeld heldItem2 = parent2.getHeldItemAsItemHeld();
        if (heldItem1 == PixelmonItemsHeld.destinyKnot || heldItem2 == PixelmonItemsHeld.destinyKnot) {
            intNumberToInherit = 5;
        }
        boolean skipSecondHeldItem = false;
        if (heldItem1 != NoItem.noItem) {
            if (heldItem1 == PixelmonItemsHeld.powerWeight) {
                strStatsToInherit.add("HP1");
                --intNumberToInherit;
            } else if (heldItem1 == PixelmonItemsHeld.powerBracer) {
                strStatsToInherit.add("ATK1");
                --intNumberToInherit;
            } else if (heldItem1 == PixelmonItemsHeld.powerBelt) {
                strStatsToInherit.add("DEF1");
                --intNumberToInherit;
            } else if (heldItem1 == PixelmonItemsHeld.powerLens) {
                strStatsToInherit.add("SPATK1");
                --intNumberToInherit;
            } else if (heldItem1 == PixelmonItemsHeld.powerBand) {
                strStatsToInherit.add("SPDEF1");
                --intNumberToInherit;
            } else if (heldItem1 == PixelmonItemsHeld.powerAnklet) {
                strStatsToInherit.add("SPD1");
                --intNumberToInherit;
            }
            if (heldItem2 != NoItem.noItem && heldItem1 == heldItem2) {
                if (RandomHelper.getRandomChance()) {
                    skipSecondHeldItem = true;
                } else {
                    strStatsToInherit = new ArrayList();
                }
            }
        }
        if (!strStatsToInherit.isEmpty()) {
            for (String statToInherit : strStatsToInherit) {
                masterStatsList.remove(statToInherit);
                if (statToInherit.contains("1")) {
                    masterStatsList.remove(RegexPatterns.NUMBER_ONE.matcher(statToInherit).replaceAll("2"));
                    continue;
                }
                masterStatsList.remove(RegexPatterns.NUMBER_TWO.matcher(statToInherit).replaceAll("1"));
            }
        }
        if (!skipSecondHeldItem && heldItem2 != NoItem.noItem) {
            if (heldItem2 == PixelmonItemsHeld.powerWeight) {
                strStatsToInherit.add("HP2");
                --intNumberToInherit;
            } else if (heldItem2 == PixelmonItemsHeld.powerBracer) {
                strStatsToInherit.add("ATK2");
                --intNumberToInherit;
            } else if (heldItem2 == PixelmonItemsHeld.powerBelt) {
                strStatsToInherit.add("DEF2");
                --intNumberToInherit;
            } else if (heldItem2 == PixelmonItemsHeld.powerLens) {
                strStatsToInherit.add("SPATK2");
                --intNumberToInherit;
            } else if (heldItem2 == PixelmonItemsHeld.powerBand) {
                strStatsToInherit.add("SPDEF2");
                --intNumberToInherit;
            } else if (heldItem2 == PixelmonItemsHeld.powerAnklet) {
                strStatsToInherit.add("SPD2");
                --intNumberToInherit;
            }
        }
        if (!strStatsToInherit.isEmpty()) {
            for (String statToInherit : strStatsToInherit) {
                masterStatsList.remove(statToInherit);
                if (statToInherit.contains("1")) {
                    masterStatsList.remove(RegexPatterns.NUMBER_ONE.matcher(statToInherit).replaceAll("2"));
                    continue;
                }
                masterStatsList.remove(RegexPatterns.NUMBER_TWO.matcher(statToInherit).replaceAll("1"));
            }
        }
        for (int i = 0; i < intNumberToInherit; ++i) {
            String statToInherit;
            statToInherit = RandomHelper.getRandomElementFromList(masterStatsList);
            strStatsToInherit.add(statToInherit);
            masterStatsList.remove(statToInherit);
            if (statToInherit.contains("1")) {
                masterStatsList.remove(RegexPatterns.NUMBER_ONE.matcher(statToInherit).replaceAll("2"));
                continue;
            }
            masterStatsList.remove(RegexPatterns.NUMBER_TWO.matcher(statToInherit).replaceAll("1"));
        }
        for (String strStat : strStatsToInherit) {
            if (strStat.equalsIgnoreCase("HP1")) {
                newIVs.hp = parent1.getIVs().hp;
                continue;
            }
            if (strStat.equalsIgnoreCase("ATK1")) {
                newIVs.attack = parent1.getIVs().attack;
                continue;
            }
            if (strStat.equalsIgnoreCase("DEF1")) {
                newIVs.defence = parent1.getIVs().defence;
                continue;
            }
            if (strStat.equalsIgnoreCase("SPATK1")) {
                newIVs.specialAttack = parent1.getIVs().specialAttack;
                continue;
            }
            if (strStat.equalsIgnoreCase("SPDEF1")) {
                newIVs.specialDefence = parent1.getIVs().specialDefence;
                continue;
            }
            if (strStat.equalsIgnoreCase("SPD1")) {
                newIVs.speed = parent1.getIVs().speed;
                continue;
            }
            if (strStat.equalsIgnoreCase("HP2")) {
                newIVs.hp = parent2.getIVs().hp;
                continue;
            }
            if (strStat.equalsIgnoreCase("ATK2")) {
                newIVs.attack = parent2.getIVs().attack;
                continue;
            }
            if (strStat.equalsIgnoreCase("DEF2")) {
                newIVs.defence = parent2.getIVs().defence;
                continue;
            }
            if (strStat.equalsIgnoreCase("SPATK2")) {
                newIVs.specialAttack = parent2.getIVs().specialAttack;
                continue;
            }
            if (strStat.equalsIgnoreCase("SPDEF2")) {
                newIVs.specialDefence = parent2.getIVs().specialDefence;
                continue;
            }
            if (!strStat.equalsIgnoreCase("SPD2")) continue;
            newIVs.speed = parent2.getIVs().speed;
        }
        return newIVs;
    }

    public static EnumNature getNatureForEgg(Pokemon parent1, Pokemon parent2) {
        boolean isEverstone2;
        boolean isEverstone1 = parent1.getHeldItemAsItemHeld() == PixelmonItemsHeld.everStone;
        boolean bl = isEverstone2 = parent2.getHeldItemAsItemHeld() == PixelmonItemsHeld.everStone;
        if (isEverstone1 && isEverstone2) {
            return RandomHelper.getRandomChance() ? parent1.getNature() : parent2.getNature();
        }
        if (isEverstone1) {
            return parent1.getNature();
        }
        if (isEverstone2) {
            return parent2.getNature();
        }
        return EnumNature.getRandomNature();
    }

    public static EnumPokeballs getMotherPokeball(Pokemon parent1, Pokemon parent2) {
        Pokemon other;
        Pokemon mother = BreedLogic.findMother(parent1, parent2);
        Pokemon inheriting = parent1.getSpecies() == parent2.getSpecies() ? (Pokemon)CollectionHelper.getRandomElement(Lists.newArrayList((Object[])new Pokemon[]{parent1, parent2})) : mother;
        Pokemon pokemon = other = inheriting == parent1 ? parent2 : parent1;
        if (inheriting != null && !inheriting.getCaughtBall().isPokeball(EnumPokeballs.MasterBall, EnumPokeballs.CherishBall)) {
            return inheriting.getCaughtBall();
        }
        if (!other.getCaughtBall().isPokeball(EnumPokeballs.MasterBall, EnumPokeballs.CherishBall)) {
            return other.getCaughtBall();
        }
        return EnumPokeballs.PokeBall;
    }

    public static EnumGrowth getEggGrowth(Pokemon parent1, Pokemon parent2) {
        double averageOrdinal = (float)(parent1.getGrowth().scaleOrdinal + parent2.getGrowth().scaleOrdinal) / 2.0f;
        int ordinal = (double)((int)averageOrdinal) != averageOrdinal ? (int)(RandomHelper.getRandomChance() ? Math.floor(averageOrdinal) : Math.ceil(averageOrdinal)) : (int)averageOrdinal;
        ordinal = MathHelper.func_76125_a((int)ordinal, (int)1, (int)7);
        int rand = RandomHelper.getRandomNumberBetween(ordinal - 1, ordinal + 1);
        return EnumGrowth.getGrowthFromScaleOrdinal(rand);
    }

    public static Integer getEggAbilitySlot(Pokemon child, Pokemon parent1, Pokemon parent2) {
        Pokemon inheritParent;
        String[] abilities = child.getBaseStats().abilities;
        boolean is1Ditto = parent1.isPokemon(EnumSpecies.Ditto);
        boolean is2Ditto = parent2.isPokemon(EnumSpecies.Ditto);
        int intPercent = 80;
        if (is1Ditto || is2Ditto) {
            if (is1Ditto && is2Ditto) {
                return abilities[1] != null ? RandomHelper.getRandomNumberBetween(0, 1) : 0;
            }
            Pokemon pokemon = inheritParent = is1Ditto ? parent2 : parent1;
            if (inheritParent.getGender() == Gender.Male || inheritParent.getAbilitySlot() == 2) {
                intPercent = 60;
            }
        } else {
            inheritParent = parent1.getGender() == Gender.Female ? parent1 : parent2;
        }
        if (inheritParent.getFormEnum() == EnumAlolan.ALOLAN && child.getFormEnum() != EnumAlolan.ALOLAN) {
            intPercent = 0;
        }
        if (inheritParent.getFormEnum() == EnumAlolan.NORMAL && child.getFormEnum() == EnumAlolan.ALOLAN) {
            intPercent = 0;
        }
        if (RandomHelper.getRandomChance(intPercent)) {
            int currentSlot = inheritParent.getAbilitySlot();
            if (currentSlot == -1) {
                return abilities[1] != null ? RandomHelper.getRandomNumberBetween(0, 1) : 0;
            }
            return abilities[currentSlot] != null ? currentSlot : 0;
        }
        return abilities[1] != null ? RandomHelper.getRandomNumberBetween(0, 1) : 0;
    }

    public static boolean getEggIsShiny(Pokemon parent1, Pokemon parent2) {
        float intDifferentTrainerFactor = 1.0f;
        if (!Objects.equals(parent1.getOriginalTrainerUUID(), parent2.getOriginalTrainerUUID())) {
            intDifferentTrainerFactor = 6.0f;
        }
        if (Pixelmon.storageManager.getParty(parent1.getOwnerPlayerUUID()).getShinyCharmState().isActive()) {
            intDifferentTrainerFactor *= 3.0f;
        }
        return PixelmonConfig.getShinyRate(0) != 0.0f && RandomHelper.rand.nextFloat() < intDifferentTrainerFactor / PixelmonConfig.getShinyRate(0);
    }

    public static Moveset getEggMoveset(Pokemon egg, EnumSpecies pokemonSpecies, Pokemon parent1, Pokemon parent2) {
        ArrayList<Attack> possibleEggMoves = egg.getBaseStats().getEggMoves();
        ArrayList<Attack> lvl0Moves = egg.getBaseStats().getMovesAtLevel(0);
        ArrayList<Attack> levelupMoves = BreedLogic.getLevelupMoves(egg, parent1, parent2);
        Pokemon father = BreedLogic.findFather(parent1, parent2);
        ArrayList<Attack> fathersTMHMTutorMoves = BreedLogic.getFathersTMHMTutorMoves(egg, father);
        ArrayList<Attack> fathersEggMoves = BreedLogic.getEggMoves(egg, father, possibleEggMoves);
        ArrayList<Attack> mothersEggMoves = BreedLogic.getEggMoves(egg, BreedLogic.findMother(parent1, parent2), possibleEggMoves);
        ArrayList<Attack> masterAttackList = new ArrayList<Attack>();
        if (BreedLogic.canLearnVoltTackle(pokemonSpecies, parent1, parent2)) {
            Attack voltTackle = new Attack("Volt Tackle");
            masterAttackList.add(voltTackle);
            possibleEggMoves.add(voltTackle);
        }
        Predicate<Attack> doesNotContain = attack -> !masterAttackList.contains(attack);
        mothersEggMoves.stream().filter(doesNotContain).forEach(masterAttackList::add);
        fathersEggMoves.stream().filter(doesNotContain).forEach(masterAttackList::add);
        fathersTMHMTutorMoves.stream().filter(doesNotContain).forEach(masterAttackList::add);
        levelupMoves.stream().filter(doesNotContain).forEach(masterAttackList::add);
        lvl0Moves.stream().filter(doesNotContain).forEach(masterAttackList::add);
        Moveset moveset = BreedLogic.getFirstFourMoves(egg, masterAttackList);
        for (Attack move : moveset) {
            if (move == null || !possibleEggMoves.contains(move) || egg.getRelearnableMoves().contains(move.getActualMove().getAttackId())) continue;
            egg.getRelearnableMoves().add(move.getActualMove().getAttackId());
        }
        return moveset;
    }

    public static ArrayList<Attack> getLevelupMoves(Pokemon egg, Pokemon parent1, Pokemon parent2) {
        ArrayList<Attack> allBabyAttacks = egg.getBaseStats().getMovesUpToLevel(100);
        ArrayList<Attack> pixelmon1Attacks = new ArrayList<Attack>(Arrays.asList(parent1.getMoveset().attacks));
        ArrayList<Attack> pixelmon2Attacks = new ArrayList<Attack>(Arrays.asList(parent2.getMoveset().attacks));
        ArrayList levelupMoves = (ArrayList)allBabyAttacks.stream().filter(attack -> pixelmon1Attacks.contains(attack) && pixelmon2Attacks.contains(attack)).collect(Collectors.toList());
        return levelupMoves;
    }

    public static Moveset getFirstFourMoves(Pokemon pokemon, ArrayList<Attack> masterAttackList) {
        Moveset moveset = new Moveset().withPokemon(pokemon);
        moveset.set(0, new Attack("Tackle"));
        moveset.set(1, null);
        moveset.set(2, null);
        moveset.set(3, null);
        if (!masterAttackList.isEmpty()) {
            for (int i = 0; i < Math.min(4, masterAttackList.size()); ++i) {
                if (masterAttackList.get(i) == null) continue;
                moveset.set(i, masterAttackList.get(i));
            }
        }
        return moveset;
    }

    public static ArrayList<Attack> getEggMoves(Pokemon egg, Pokemon parent, ArrayList<Attack> allEggMoves) {
        ArrayList<Attack> eggMoves = new ArrayList<Attack>();
        if (parent != null) {
            ArrayList<Attack> allParentsMoves = new ArrayList<Attack>(Arrays.asList(parent.getMoveset().attacks));
            eggMoves.addAll(allParentsMoves.stream().filter(allEggMoves::contains).collect(Collectors.toList()));
        }
        return eggMoves;
    }

    public static boolean canLearnVoltTackle(EnumSpecies species, Pokemon parent1, Pokemon parent2) {
        if (species == EnumSpecies.Pichu) {
            return parent1.getHeldItemAsItemHeld() == PixelmonItemsHeld.lightBall || parent2.getHeldItemAsItemHeld() == PixelmonItemsHeld.lightBall;
        }
        return false;
    }

    public static ArrayList<Attack> getFathersTMHMTutorMoves(Pokemon egg, Pokemon father) {
        ArrayList<Attack> tmhmTutorMoves = new ArrayList<Attack>();
        if (father != null) {
            ArrayList<Attack> allBabyTMHMTutorMoves = egg.getBaseStats().getTMHMMoves();
            allBabyTMHMTutorMoves.addAll(egg.getBaseStats().getTutorMoves());
            ArrayList<Attack> allFathersMoves = new ArrayList<Attack>(Arrays.asList(father.getMoveset().attacks));
            tmhmTutorMoves.addAll(allFathersMoves.stream().filter(allBabyTMHMTutorMoves::contains).collect(Collectors.toList()));
        }
        return tmhmTutorMoves;
    }

    public static Pokemon findFather(Pokemon parent1, Pokemon parent2) {
        boolean is1Ditto = parent1.isPokemon(EnumSpecies.Ditto);
        boolean is2Ditto = parent2.isPokemon(EnumSpecies.Ditto);
        if (is1Ditto || is2Ditto) {
            if (is1Ditto && parent2.getGender() != Gender.Female) {
                return parent2;
            }
            if (is2Ditto && parent1.getGender() != Gender.Female) {
                return parent1;
            }
            return null;
        }
        return parent1.getGender() == Gender.Male ? parent1 : parent2;
    }

    public static Pokemon findMother(Pokemon parent1, Pokemon parent2) {
        boolean is1Ditto = parent1.isPokemon(EnumSpecies.Ditto);
        boolean is2Ditto = parent1.isPokemon(EnumSpecies.Ditto);
        if (is1Ditto || is2Ditto) {
            if (is1Ditto && parent2.getGender() != Gender.Male) {
                return parent2;
            }
            if (is2Ditto && parent1.getGender() != Gender.Male) {
                return parent1;
            }
            return null;
        }
        return parent1.getGender() == Gender.Female ? parent1 : parent2;
    }

    private static boolean checkIncense(Item itemTypeParent, Item itemTypeOther, Pokemon parentForEggLine, Item neededItem, EnumSpecies baby, EnumSpecies ... parents) {
        if (!parentForEggLine.isPokemon(parents)) {
            return false;
        }
        if (itemTypeParent != neededItem && itemTypeOther != neededItem) {
            return true;
        }
        return PixelmonConfig.isGenerationEnabled(parentForEggLine.getSpecies().getGeneration()) && !PixelmonConfig.isGenerationEnabled(baby.getGeneration());
    }
}

