/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;

public class Scheduling {
    private static ArrayList<ScheduledTask> tasks = new ArrayList();
    private static boolean iterating = false;
    private static ArrayList<ScheduledTask> queue = new ArrayList();

    public static void tick() {
        iterating = true;
        Iterator<ScheduledTask> it = tasks.iterator();
        while (it.hasNext()) {
            ScheduledTask t = it.next();
            if (--t.ticks > 0) continue;
            t.task.accept(t);
            if (t.repeats) {
                t.ticks = t.originalTicks;
                continue;
            }
            it.remove();
        }
        iterating = false;
        if (!queue.isEmpty()) {
            tasks.addAll(queue);
            queue.clear();
        }
    }

    public static void schedule(int ticks, Runnable task, boolean repeats) {
        Scheduling.schedule(ticks, (ScheduledTask t) -> task.run(), repeats);
    }

    public static void schedule(int ticks, Consumer<ScheduledTask> task, boolean repeats) {
        ScheduledTask t = new ScheduledTask();
        t.ticks = ticks;
        t.task = task;
        t.repeats = repeats;
        t.originalTicks = ticks;
        if (iterating) {
            queue.add(t);
        } else {
            tasks.add(t);
        }
    }

    public static class ScheduledTask {
        public int originalTicks;
        public int ticks;
        public Consumer<ScheduledTask> task;
        public boolean repeats = false;
    }
}

