/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.common.util.BlockSnapshot;

public class NBTTools {
    public static final Gson gson = new GsonBuilder().create();

    public static String serializeBlockSnapshot(BlockSnapshot snapshot) {
        NBTTagCompound nbt = new NBTTagCompound();
        snapshot.writeToNBT(nbt);
        return gson.toJson(NBTTools.nbtToMap(nbt));
    }

    public static BlockSnapshot deserializeBlockSnapshot(String json) {
        Map map = (Map)gson.fromJson(json, Map.class);
        return BlockSnapshot.readFromNBT((NBTTagCompound)NBTTools.nbtFromMap(map));
    }

    public static Map<String, Object> nbtToMap(NBTTagCompound nbt) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : nbt.func_150296_c()) {
            try {
                NBTBase base = nbt.func_74781_a(key);
                if (base instanceof NBTTagString) {
                    map.put(key, ((NBTTagString)base).func_150285_a_());
                    continue;
                }
                if (base instanceof NBTPrimitive) {
                    map.put(key, ((NBTPrimitive)base).func_150286_g());
                    continue;
                }
                if (!(base instanceof NBTTagCompound)) continue;
                map.put(key, NBTTools.nbtToMap((NBTTagCompound)base));
            }
            catch (Exception exception) {}
        }
        return map;
    }

    public static NBTTagCompound nbtFromMap(Map<String, Object> map) {
        NBTTagCompound nbt = new NBTTagCompound();
        for (String key : map.keySet()) {
            try {
                if (map.get(key) instanceof List) {
                    List list = (List)map.get(key);
                    NBTTagList tagList = new NBTTagList();
                    for (int i = 0; i < list.size(); ++i) {
                        tagList.func_74742_a((NBTBase)new NBTTagString((String)list.get(i)));
                    }
                    nbt.func_74782_a(key, (NBTBase)tagList);
                }
                if (map.get(key) instanceof String) {
                    nbt.func_74778_a(key, (String)map.get(key));
                    continue;
                }
                if (map.get(key) instanceof Map) {
                    nbt.func_74782_a(key, (NBTBase)NBTTools.nbtFromMap((Map)map.get(key)));
                    continue;
                }
                Double d = (Double)map.get(key);
                if ((double)Math.round(d) == d) {
                    nbt.func_74768_a(key, (int)Math.round(d));
                    continue;
                }
                nbt.func_74780_a(key, d.doubleValue());
            }
            catch (Exception exception) {}
        }
        return nbt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NBTTagCompound loadNBT(File file) throws IOException {
        FileInputStream in = null;
        NBTTagCompound result = null;
        try {
            in = new FileInputStream(file);
            result = CompressedStreamTools.func_74796_a((InputStream)in);
        }
        catch (IOException e) {
            try {
                result = CompressedStreamTools.func_74797_a((File)file);
            }
            finally {
                in.close();
            }
        }
        return result;
    }

    public static void saveNBT(NBTTagCompound nbt, File file, boolean compressed) throws IOException {
        file.getParentFile().mkdirs();
        file.createNewFile();
        NBTTools.saveNBT(nbt, new FileOutputStream(file), compressed);
    }

    public static void saveNBT(NBTTagCompound nbt, OutputStream out, boolean compressed) throws IOException {
        if (compressed) {
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)out);
        } else {
            CompressedStreamTools.func_74800_a((NBTTagCompound)nbt, (DataOutput)new DataOutputStream(out));
        }
    }
}

