/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.ISpawnerCondition;
import com.pixelmonmod.pixelmon.api.spawning.ISpawningTweak;
import com.pixelmonmod.pixelmon.api.spawning.SpawnSet;
import com.pixelmonmod.pixelmon.api.spawning.SpawnerCoordinator;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.checkspawns.FishingCheckSpawns;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.checkspawns.GenericTriggerCheckSpawns;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.checkspawns.LegendaryCheckSpawns;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.checkspawns.PlayerTrackingCheckSpawns;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.checkspawns.RayTraceCheckSpawns;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.selection.FlatDistinctAlgorithm;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.spawners.TriggerSpawner;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.spawning.util.SetLoader;
import com.pixelmonmod.pixelmon.blocks.BlockFossil;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.config.BetterSpawnerConfig;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.spawning.LegendarySpawner;
import com.pixelmonmod.pixelmon.spawning.LevelByDistanceEvolutionCondition;
import com.pixelmonmod.pixelmon.spawning.PlayerBasedLevels;
import com.pixelmonmod.pixelmon.spawning.PlayerTrackingSpawner;
import com.pixelmonmod.pixelmon.spawning.SpawnDistanceLevelTweak;
import com.pixelmonmod.pixelmon.spawning.TrackingSpawnerCoordinator;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;

public class PixelmonSpawning {
    public static SpawnerCoordinator coordinator = null;
    public static ArrayList<SpawnSet> standard = new ArrayList();
    public static ArrayList<SpawnSet> legendaries = new ArrayList();
    public static ArrayList<SpawnSet> fishing = new ArrayList();
    public static ArrayList<SpawnSet> megas = new ArrayList();
    public static ArrayList<SpawnSet> npcs = new ArrayList();
    public static ArrayList<SpawnSet> rocksmash = new ArrayList();
    public static ArrayList<SpawnSet> headbutt = new ArrayList();
    public static ArrayList<SpawnSet> sweetscent = new ArrayList();
    public static ArrayList<SpawnSet> grass = new ArrayList();
    public static ArrayList<SpawnSet> tallgrass = new ArrayList();
    public static ArrayList<SpawnSet> seaweed = new ArrayList();
    public static ArrayList<SpawnSet> caveRock = new ArrayList();
    public static LegendarySpawner legendarySpawner = null;
    public static LegendarySpawner megaBossSpawner = null;
    public static TriggerSpawner fishingSpawner = null;
    public static TriggerSpawner rocksmashSpawner = null;
    public static TriggerSpawner headbuttSpawner = null;
    public static TriggerSpawner sweetscentSpawner = null;
    public static TriggerSpawner grassSpawner = null;
    public static TriggerSpawner tallGrassSpawner = null;
    public static TriggerSpawner seaweedSpawner = null;
    public static TriggerSpawner caveRockSpawner = null;
    public static PlayerTrackingSpawner.PlayerTrackingSpawnerBuilder<PlayerTrackingSpawner> trackingSpawnerPreset = (PlayerTrackingSpawner.PlayerTrackingSpawnerBuilder)new PlayerTrackingSpawner.PlayerTrackingSpawnerBuilder().setCheckSpawns(new PlayerTrackingCheckSpawns());
    public static LegendarySpawner.LegendarySpawnerBuilder<LegendarySpawner> legendarySpawnerPreset = (LegendarySpawner.LegendarySpawnerBuilder)((AbstractSpawner.SpawnerBuilder)new LegendarySpawner.LegendarySpawnerBuilder().setSelectionAlgorithm(new FlatDistinctAlgorithm())).setCheckSpawns(new LegendaryCheckSpawns("pixelmon.checkspawns.legendary"));
    public static LegendarySpawner.LegendarySpawnerBuilder<LegendarySpawner> megaBossSpawnerPreset = (LegendarySpawner.LegendarySpawnerBuilder)((AbstractSpawner.SpawnerBuilder)((AbstractSpawner.SpawnerBuilder)new LegendarySpawner.LegendarySpawnerBuilder().setFiresChooseEvent(false)).setSelectionAlgorithm(new FlatDistinctAlgorithm())).setCheckSpawns(new LegendaryCheckSpawns("pixelmon.checkspawns.megaboss"));
    public static AbstractSpawner.SpawnerBuilder<TriggerSpawner> rockSmashPreset = new AbstractSpawner.SpawnerBuilder().setCheckSpawns(new RayTraceCheckSpawns(LocationType.ROCK_SMASH, state -> {
        if (state.func_185904_a() != Material.field_151576_e || state.func_177230_c() == Blocks.field_150357_h) {
            return false;
        }
        return !(state.func_177230_c() instanceof MultiBlock) && !(state.func_177230_c() instanceof BlockFossil);
    }, "pixelmon.checkspawns.rocksmash"));
    public static AbstractSpawner.SpawnerBuilder<TriggerSpawner> headbuttPreset = new AbstractSpawner.SpawnerBuilder().setCheckSpawns(new RayTraceCheckSpawns(LocationType.HEADBUTT, state -> state.func_177230_c() instanceof BlockLog, "pixelmon.checkspawns.headbutt"));
    public static AbstractSpawner.SpawnerBuilder<TriggerSpawner> sweetScentPreset = new AbstractSpawner.SpawnerBuilder().setCheckSpawns(new GenericTriggerCheckSpawns(LocationType.SWEET_SCENT, "pixelmon.checkspawns.sweetscent"));
    public static AbstractSpawner.SpawnerBuilder<TriggerSpawner> pixelmonGrassPreset = new AbstractSpawner.SpawnerBuilder().setCheckSpawns(new GenericTriggerCheckSpawns(LocationType.GRASS, "pixelmon.checkspawns.grass"));
    public static AbstractSpawner.SpawnerBuilder<TriggerSpawner> pixelmonDoubleGrassPreset = new AbstractSpawner.SpawnerBuilder().setCheckSpawns(new GenericTriggerCheckSpawns(LocationType.DOUBLE_GRASS, "pixelmon.checkspawns.tallgrass"));
    public static AbstractSpawner.SpawnerBuilder<TriggerSpawner> seaweedPreset = new AbstractSpawner.SpawnerBuilder().setCheckSpawns(new GenericTriggerCheckSpawns(LocationType.SEAWEED, "pixelmon.checkspawns.seaweed"));
    public static AbstractSpawner.SpawnerBuilder<TriggerSpawner> caverockPreset = new AbstractSpawner.SpawnerBuilder().setCheckSpawns(new GenericTriggerCheckSpawns(LocationType.CAVE_ROCK, "pixelmon.checkspawns.caverock"));
    public static AbstractSpawner.SpawnerBuilder<TriggerSpawner> fishingPreset = new AbstractSpawner.SpawnerBuilder().setCheckSpawns(new FishingCheckSpawns());

    public static void startTrackingSpawner() {
        if (coordinator != null && coordinator.getActive()) {
            coordinator.deactivate();
        }
        if (coordinator == null || !coordinator.getActive()) {
            coordinator = new TrackingSpawnerCoordinator().activate();
        }
    }

    public static void loadAndInitialize() {
        Pixelmon.LOGGER.info("Registering spawn sets.");
        SetLoader.clearAll();
        standard.clear();
        legendaries.clear();
        megas.clear();
        npcs.clear();
        fishing.clear();
        rocksmash.clear();
        sweetscent.clear();
        grass.clear();
        tallgrass.clear();
        seaweed.clear();
        caveRock.clear();
        if (PixelmonConfig.useExternalJSONFilesSpawning) {
            if ("default".equals(PixelmonConfig.spawnSetFolder)) {
                File spawnSetDir = new File("pixelmon/spawning/default");
                if (!spawnSetDir.isDirectory()) {
                    Pixelmon.LOGGER.info("Creating spawning directory");
                    spawnSetDir.mkdirs();
                }
                SetLoader.checkForMissingSpawnSets();
            }
            standard.addAll(SetLoader.importSetsFrom("pixelmon/spawning/" + PixelmonConfig.spawnSetFolder + "/standard"));
            legendaries.addAll(SetLoader.importSetsFrom("pixelmon/spawning/" + PixelmonConfig.spawnSetFolder + "/legendaries"));
            megas.addAll(SetLoader.importSetsFrom("pixelmon/spawning/" + PixelmonConfig.spawnSetFolder + "/megas"));
            npcs.addAll(SetLoader.importSetsFrom("pixelmon/spawning/" + PixelmonConfig.spawnSetFolder + "/npcs"));
            fishing.addAll(SetLoader.importSetsFrom("pixelmon/spawning/" + PixelmonConfig.spawnSetFolder + "/fishing"));
            rocksmash.addAll(SetLoader.importSetsFrom("pixelmon/spawning/" + PixelmonConfig.spawnSetFolder + "/rocksmash"));
            headbutt.addAll(SetLoader.importSetsFrom("pixelmon/spawning/" + PixelmonConfig.spawnSetFolder + "/headbutt"));
            sweetscent.addAll(SetLoader.importSetsFrom("pixelmon/spawning/" + PixelmonConfig.spawnSetFolder + "/sweetscent"));
            grass.addAll(SetLoader.importSetsFrom("pixelmon/spawning/" + PixelmonConfig.spawnSetFolder + "/grass"));
            caveRock.addAll(SetLoader.importSetsFrom("pixelmon/spawning/" + PixelmonConfig.spawnSetFolder + "/caverock"));
        } else {
            standard.addAll(SetLoader.retrieveSpawnSetsFromAssets("standard"));
            legendaries.addAll(SetLoader.retrieveSpawnSetsFromAssets("legendaries"));
            megas.addAll(SetLoader.retrieveSpawnSetsFromAssets("megas"));
            npcs.addAll(SetLoader.retrieveSpawnSetsFromAssets("npcs"));
            fishing.addAll(SetLoader.retrieveSpawnSetsFromAssets("fishing"));
            rocksmash.addAll(SetLoader.retrieveSpawnSetsFromAssets("rocksmash"));
            headbutt.addAll(SetLoader.retrieveSpawnSetsFromAssets("headbutt"));
            sweetscent.addAll(SetLoader.retrieveSpawnSetsFromAssets("sweetscent"));
            grass.addAll(SetLoader.retrieveSpawnSetsFromAssets("grass"));
            caveRock.addAll(SetLoader.retrieveSpawnSetsFromAssets("caverock"));
        }
        BiConsumer<AbstractSpawner.SpawnerBuilder, ISpawningTweak> applyTweak = (builder, tweak) -> {
            if (!CollectionHelper.containsA(builder.tweaks, tweak.getClass())) {
                builder.addTweak((ISpawningTweak)tweak);
            }
        };
        BiConsumer<AbstractSpawner.SpawnerBuilder, ISpawnerCondition> applyCondition = (builder, condition) -> {
            if (!CollectionHelper.containsA(builder.conditions, condition.getClass())) {
                builder.addCondition((ISpawnerCondition)condition);
            }
        };
        List<AbstractSpawner.SpawnerBuilder> presets = Arrays.asList(trackingSpawnerPreset, legendarySpawnerPreset, megaBossSpawnerPreset, rockSmashPreset, headbuttPreset, fishingPreset, sweetScentPreset, seaweedPreset, pixelmonGrassPreset, pixelmonDoubleGrassPreset, caverockPreset);
        if (PixelmonConfig.spawnLevelsCloserToPlayerLevels) {
            PlayerBasedLevels playerBasedLevels = new PlayerBasedLevels();
            presets.forEach(preset -> {
                applyTweak.accept((AbstractSpawner.SpawnerBuilder)preset, playerBasedLevels);
                applyCondition.accept((AbstractSpawner.SpawnerBuilder)preset, playerBasedLevels);
            });
        } else {
            presets.forEach(preset -> CollectionHelper.removeAny(preset.tweaks, PlayerBasedLevels.class));
        }
        if (PixelmonConfig.spawnLevelsByDistance) {
            SpawnDistanceLevelTweak tweak2 = new SpawnDistanceLevelTweak();
            LevelByDistanceEvolutionCondition condition2 = new LevelByDistanceEvolutionCondition();
            presets.forEach(preset -> {
                applyTweak.accept((AbstractSpawner.SpawnerBuilder)preset, tweak2);
                applyCondition.accept((AbstractSpawner.SpawnerBuilder)preset, condition2);
            });
        } else {
            presets.forEach(preset -> {
                CollectionHelper.removeAny(preset.tweaks, SpawnDistanceLevelTweak.class);
                CollectionHelper.removeAny(preset.conditions, LevelByDistanceEvolutionCondition.class);
            });
        }
        ((AbstractSpawner.SpawnerBuilder)((AbstractSpawner.SpawnerBuilder)trackingSpawnerPreset.setSpawnSets(standard)).addSpawnSets(npcs)).setupCache();
        if (PixelmonConfig.allowLegendariesSpawn) {
            legendarySpawner = ((AbstractSpawner.SpawnerBuilder)((AbstractSpawner.SpawnerBuilder)((AbstractSpawner.SpawnerBuilder)legendarySpawnerPreset.setSpawnFrequency(1200.0f / (float)PixelmonConfig.legendarySpawnTicks)).setSpawnSets(legendaries)).setupCache()).apply((LegendarySpawner)new LegendarySpawner("legendary"));
        }
        megaBossSpawner = ((AbstractSpawner.SpawnerBuilder)((AbstractSpawner.SpawnerBuilder)((AbstractSpawner.SpawnerBuilder)megaBossSpawnerPreset.setSpawnFrequency(1200.0f / (float)PixelmonConfig.bossSpawnTicks)).setSpawnSets(megas)).setupCache()).apply((LegendarySpawner)new LegendarySpawner("megaboss"));
        fishingSpawner = ((AbstractSpawner.SpawnerBuilder)fishingPreset.setSpawnSets(fishing)).apply((TriggerSpawner)new TriggerSpawner("fishing"));
        rocksmashSpawner = ((AbstractSpawner.SpawnerBuilder)rockSmashPreset.setSpawnSets(rocksmash)).apply((TriggerSpawner)new TriggerSpawner("rocksmash"));
        headbuttSpawner = ((AbstractSpawner.SpawnerBuilder)headbuttPreset.setSpawnSets(headbutt)).apply((TriggerSpawner)new TriggerSpawner("headbutt"));
        sweetscentSpawner = ((AbstractSpawner.SpawnerBuilder)sweetScentPreset.setSpawnSets(sweetscent)).apply((TriggerSpawner)new TriggerSpawner("sweetscent"));
        grassSpawner = ((AbstractSpawner.SpawnerBuilder)pixelmonGrassPreset.setSpawnSets(grass)).apply((TriggerSpawner)new TriggerSpawner("grass"));
        tallGrassSpawner = ((AbstractSpawner.SpawnerBuilder)pixelmonDoubleGrassPreset.setSpawnSets(tallgrass)).apply((TriggerSpawner)new TriggerSpawner("tallgrass"));
        seaweedSpawner = ((AbstractSpawner.SpawnerBuilder)seaweedPreset.setSpawnSets(seaweed)).apply((TriggerSpawner)new TriggerSpawner("seaweed"));
        caveRockSpawner = ((AbstractSpawner.SpawnerBuilder)caverockPreset.setSpawnSets(caveRock)).apply((TriggerSpawner)new TriggerSpawner("caverock"));
    }

    public static void addRegularSpawners(SpawnerCoordinator coordinator) {
        if (PixelmonConfig.allowLegendariesSpawn) {
            coordinator.spawners.add(legendarySpawner);
        }
        coordinator.spawners.add(megaBossSpawner);
        coordinator.spawners.add(fishingSpawner);
        coordinator.spawners.add(caveRockSpawner);
        coordinator.spawners.add(grassSpawner);
        coordinator.spawners.add(headbuttSpawner);
        coordinator.spawners.add(rocksmashSpawner);
        coordinator.spawners.add(seaweedSpawner);
        coordinator.spawners.add(tallGrassSpawner);
        coordinator.spawners.add(sweetscentSpawner);
    }

    public static void totalReload() {
        coordinator.deactivate();
        BetterSpawnerConfig.load();
        PixelmonSpawning.loadAndInitialize();
        coordinator.activate();
    }
}

