/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums.forms;

import com.google.common.collect.HashBiMap;
import com.pixelmonmod.pixelmon.config.PixelmonBlocks;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public enum EnumRotom implements IEnumForm
{
    NORMAL("Thunder Shock"),
    HEAT("Overheat"),
    WASH("Hydro Pump"),
    FROST("Blizzard"),
    FAN("Air Slash"),
    MOW("Leaf Storm");

    public String attack;
    private static HashBiMap<Block, EnumRotom> blockMap;

    private EnumRotom(String attackName) {
        this.attack = attackName;
    }

    @Override
    public String getFormSuffix() {
        return "-" + this.name().toLowerCase();
    }

    public static HashBiMap<Block, EnumRotom> getBlockImpactMap() {
        if (blockMap.isEmpty()) {
            blockMap.put((Object)Blocks.field_150460_al, (Object)HEAT);
            blockMap.put((Object)PixelmonBlocks.fridgeBlock, (Object)FROST);
            blockMap.put((Object)PixelmonBlocks.mower, (Object)MOW);
            blockMap.put((Object)PixelmonBlocks.washingMachine, (Object)WASH);
            blockMap.put((Object)PixelmonBlocks.fan, (Object)FAN);
        }
        return blockMap;
    }

    @Override
    public byte getForm() {
        return (byte)this.ordinal();
    }

    @Override
    public boolean isDefaultForm() {
        return this == NORMAL;
    }

    @Override
    public String getUnlocalizedName() {
        return "pixelmon.rotom.form." + this.name().toLowerCase();
    }

    static {
        blockMap = HashBiMap.create();
    }
}

