/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Aggression;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.AttackTypeAdapter;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.FlyingParameters;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.RidingOffsets;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.SwimmingParameters;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvoConditionTypeAdapter;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvolutionTypeAdapter;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.EvoCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.LevelCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.types.LevelingEvolution;
import com.pixelmonmod.pixelmon.enums.EnumEggGroup;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.ExperienceGroup;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import net.minecraft.util.SoundEvent;

public class BaseStats {
    public static final transient Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Evolution.class, (Object)new EvolutionTypeAdapter()).registerTypeAdapter(EvoCondition.class, (Object)new EvoConditionTypeAdapter()).registerTypeAdapter(Attack.class, (Object)new AttackTypeAdapter()).registerTypeAdapter(PokemonSpec.class, (Object)PokemonSpec.SPEC_ADAPTER).create();
    public static final transient EnumMap<EnumSpecies, BaseStats> allBaseStats = Maps.newEnumMap(EnumSpecies.class);
    public String pixelmonName;
    public EnumSpecies pokemon;
    public transient int nationalPokedexNumber;
    public LinkedHashMap<StatsType, Integer> stats = null;
    public Integer catchRate = null;
    public Integer malePercent = null;
    public Integer spawnLevel = null;
    public Integer spawnLevelRange = null;
    public Integer baseExp = null;
    public Integer baseFriendship = null;
    public ArrayList<EnumType> types = null;
    public Float height = null;
    public Float width = null;
    public Float length = null;
    public Boolean isRideable = null;
    public Boolean canFly = null;
    public Boolean canSurf = null;
    public Boolean canShoulder = null;
    public EnumSpecies[] preEvolutions;
    public ExperienceGroup experienceGroup = null;
    public Aggression aggression = null;
    public SwimmingParameters swimmingParameters = null;
    public FlyingParameters flyingParameters = null;
    public SpawnLocationType[] spawnLocations = null;
    public LinkedHashMap<StatsType, Integer> evYields = null;
    public RidingOffsets ridingOffsets = null;
    public Float hoverHeight = null;
    public Float weight = null;
    public ArrayList<Evolution> evolutions = null;
    public String[] abilities = null;
    public EnumEggGroup[] eggGroups = null;
    public Integer eggCycles = null;
    public LinkedHashMap<Integer, ArrayList<Attack>> levelUpMoves = null;
    public ArrayList<Attack> tmMoves = null;
    public ArrayList<Attack> tutorMoves = null;
    public ArrayList<Attack> eggMoves = null;
    public transient int id;
    public transient int baseFormID;
    public LinkedHashMap<Integer, BaseStats> forms = null;
    public int form = 0;
    public transient BaseStats parent = null;
    private final transient HashMap<SoundType, ArrayList<SoundEvent>> sounds = new HashMap();
    private transient boolean[] soundRegistered = new boolean[]{false, false, false};
    public transient int minLevel = 1;
    public transient int maxLevel = PixelmonServerConfig.maxLevel;

    public static void loadAllBaseStats() {
        if (!PixelmonConfig.useExternalJSONFilesStats) {
            for (EnumSpecies enumSpecies : EnumSpecies.values()) {
                BaseStats bs = BaseStats.getBaseStatsFromAssets(enumSpecies);
                if (bs != null) {
                    allBaseStats.put(enumSpecies, bs);
                    continue;
                }
                Pixelmon.LOGGER.error("CRITICAL: " + enumSpecies.name + " is missing base stats in the jar!");
            }
        } else {
            new File("./pixelmon/stats/").mkdirs();
            for (EnumSpecies enumSpecies : EnumSpecies.values()) {
                BaseStats bs;
                File file = new File("./pixelmon/stats/" + enumSpecies.name() + ".json");
                if (file.exists()) {
                    try {
                        bs = (BaseStats)GSON.fromJson((Reader)new FileReader(file), BaseStats.class);
                        bs.nationalPokedexNumber = enumSpecies.getNationalPokedexInteger();
                        if (bs.forms != null && !bs.forms.isEmpty()) {
                            for (BaseStats formBS : bs.forms.values()) {
                                formBS.expand(bs);
                            }
                        }
                        allBaseStats.put(enumSpecies, bs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                bs = BaseStats.getBaseStatsFromAssets(enumSpecies);
                if (bs != null) {
                    allBaseStats.put(enumSpecies, bs);
                    if (bs.forms != null && !bs.forms.isEmpty()) {
                        for (BaseStats formBS : bs.forms.values()) {
                            formBS.simplify(bs);
                        }
                    }
                    try {
                        file.createNewFile();
                        PrintWriter pw = new PrintWriter(file);
                        String json = GSON.toJson((Object)bs);
                        pw.write(json);
                        pw.flush();
                        pw.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (bs.forms == null || bs.forms.isEmpty()) continue;
                    for (BaseStats formBS : bs.forms.values()) {
                        formBS.expand(bs);
                    }
                    continue;
                }
                Pixelmon.LOGGER.error("CRITICAL: " + enumSpecies.name + " is missing base stats in the jar!");
            }
        }
        for (BaseStats bs : allBaseStats.values()) {
            if (bs.forms != null) {
                for (BaseStats baseStats : bs.forms.values()) {
                    for (Attack a : baseStats.getTutorMoves()) {
                        AttackBase ab = a.getActualMove();
                        if (NPCTutor.allTutorMoves.contains(ab)) continue;
                        NPCTutor.allTutorMoves.add(ab);
                    }
                }
            }
            for (Attack attack : bs.getTutorMoves()) {
                AttackBase ab = attack.getActualMove();
                if (NPCTutor.allTutorMoves.contains(ab)) continue;
                NPCTutor.allTutorMoves.add(ab);
            }
        }
        for (BaseStats stats : allBaseStats.values()) {
            stats.calculateMinMaxLevels();
            if (stats.forms == null) continue;
            for (BaseStats baseStats : stats.forms.values()) {
                baseStats.calculateMinMaxLevels();
            }
        }
    }

    private static BaseStats getBaseStatsFromAssets(EnumSpecies species) {
        String path = "/assets/pixelmon/stats/" + species.getNationalPokedexNumber() + ".json";
        InputStream iStream = EntityPixelmon.class.getResourceAsStream(path);
        String json = "";
        try {
            Scanner s = new Scanner(iStream);
            s.useDelimiter("\\A");
            json = s.hasNext() ? s.next() : "";
            s.close();
            BaseStats bs = (BaseStats)GSON.fromJson(json, BaseStats.class);
            bs.nationalPokedexNumber = species.getNationalPokedexInteger();
            if (bs.forms != null && !bs.forms.isEmpty()) {
                for (BaseStats formBS : bs.forms.values()) {
                    formBS.expand(bs);
                }
            }
            return bs;
        }
        catch (Exception e) {
            Pixelmon.LOGGER.error("Couldn't load stat JSON: " + path);
            throw e;
        }
    }

    public BaseStats() {
    }

    public BaseStats(String name, int form) {
        this.pixelmonName = name;
        this.form = form;
        this.pokemon = EnumSpecies.getFromNameAnyCase(name);
        if (this.pokemon != null) {
            this.nationalPokedexNumber = this.pokemon.getNationalPokedexInteger();
        }
    }

    public BaseStats getParent() {
        return this.parent == null ? this : this.parent;
    }

    public int get(StatsType stat) {
        return this.stats.containsKey(stat) ? this.stats.get(stat) : -1;
    }

    public void simplify(BaseStats comparison) {
        String[] ability1 = this.abilities;
        String[] ability2 = comparison.abilities;
        boolean allSame = true;
        for (int i = 0; i < 3; ++i) {
            if (ability1[i] == ability2[i] || ability1[i] != null && ability1[i].equals(ability2[i])) continue;
            allSame = false;
        }
        if (allSame) {
            this.abilities = null;
        }
        for (Field f : this.getClass().getDeclaredFields()) {
            try {
                Object o2;
                Object o1;
                if (Modifier.isTransient(f.getModifiers()) || f.getName().equals("forms") || (o1 = f.get(this)) != (o2 = f.get(comparison)) && (o1 == null || !o1.equals(o2))) continue;
                f.set(this, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.parent = comparison;
    }

    public void expand(BaseStats comparison) {
        this.nationalPokedexNumber = comparison.nationalPokedexNumber;
        for (Field f : this.getClass().getDeclaredFields()) {
            try {
                if (f.getName().equals("forms")) continue;
                Object o1 = f.get(this);
                Object o2 = f.get(comparison);
                if (o1 != null || o2 == null) continue;
                f.set(this, o2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addSound(SoundType type, SoundEvent sound) {
        if (!this.soundRegistered[type.ordinal()]) {
            for (BaseStats form : Lists.asList((Object)this, (Object[])this.forms.values().toArray(new BaseStats[0]))) {
                ArrayList<Object> list = form.sounds.get((Object)type);
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(sound);
                form.sounds.put(type, list);
                form.soundRegistered[type.ordinal()] = true;
            }
        }
    }

    public SoundEvent getSound(SoundType type) {
        ArrayList<SoundEvent> list = this.sounds.get((Object)type);
        if (list == null) {
            return null;
        }
        return RandomHelper.getRandomElementFromList(list);
    }

    private boolean hasSound(SoundType type) {
        return this.sounds.containsKey((Object)type);
    }

    public boolean hasSoundForGender(Gender gender) {
        return this.sounds.containsKey((Object)(gender == Gender.Male ? SoundType.Male : SoundType.Female)) || this.sounds.containsKey((Object)SoundType.Neutral);
    }

    public SoundEvent getSoundForGender(Gender gender) {
        if (gender == Gender.Male) {
            if (this.hasSound(SoundType.Male)) {
                return this.getSound(SoundType.Male);
            }
        } else if (gender == Gender.Female && this.hasSound(SoundType.Female)) {
            return this.getSound(SoundType.Female);
        }
        if (this.hasSound(SoundType.Neutral)) {
            return this.getSound(SoundType.Neutral);
        }
        return null;
    }

    public void calculateMinMaxLevels() {
        this.maxLevel = this.getHighestFeasibleLevel();
        if (this.maxLevel == -1) {
            this.maxLevel = PixelmonServerConfig.maxLevel;
        }
        this.minLevel = 1;
        if (this.preEvolutions != null) {
            for (EnumSpecies preEvo : this.preEvolutions) {
                try {
                    BaseStats preEvoBS = preEvo.getBaseStats(preEvo.getFormEnum(this.form));
                    if (preEvoBS == null) break;
                    int level = preEvoBS.getHighestFeasibleLevel();
                    if (level <= this.minLevel) continue;
                    this.minLevel = level;
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.maxLevel < this.minLevel) {
            this.minLevel = this.maxLevel;
        }
    }

    public int getHighestFeasibleLevel() {
        int maxLevel = -1;
        if (this.evolutions != null) {
            for (Evolution evolution : this.evolutions) {
                int level;
                if (evolution == null) continue;
                if (evolution instanceof LevelingEvolution && (level = ((LevelingEvolution)evolution).getLevel()) > maxLevel) {
                    maxLevel = level;
                }
                for (LevelCondition condition : evolution.getConditionsOfType(LevelCondition.class)) {
                    if (condition.level <= maxLevel) continue;
                    maxLevel = condition.level;
                }
            }
        }
        return maxLevel;
    }

    public boolean hovers() {
        return this.hoverHeight != null && this.hoverHeight.floatValue() > 0.0f;
    }

    public boolean hasEggGroup(EnumEggGroup eggGroupTarget) {
        for (EnumEggGroup eggGroup : this.eggGroups) {
            if (eggGroup != eggGroupTarget) continue;
            return true;
        }
        return false;
    }

    public List<EnumType> getTypeList() {
        return this.types;
    }

    public EnumType getType1() {
        return this.types.get(0);
    }

    public EnumType getType2() {
        return this.types.size() > 1 ? this.types.get(1) : null;
    }

    public static ArrayList<Attack> severReferences(ArrayList<Attack> attacks) {
        ArrayList<Attack> newAttacks = new ArrayList<Attack>(attacks.size());
        for (Attack oldAttack : attacks) {
            if (oldAttack == null) continue;
            newAttacks.add(new Attack(oldAttack.getActualMove()));
        }
        return newAttacks;
    }

    public ArrayList<Attack> getMovesUpToLevel(int level) {
        ArrayList<Attack> attacks = new ArrayList<Attack>();
        for (int i = 0; i <= level; ++i) {
            if (this.levelUpMoves == null || !this.levelUpMoves.containsKey(i)) continue;
            for (Attack attack : this.levelUpMoves.get(i)) {
                if (attacks.contains(attack)) continue;
                attacks.add(attack);
            }
        }
        return BaseStats.severReferences(attacks);
    }

    public ArrayList<Attack> getMovesAtLevel(int level) {
        if (this.levelUpMoves != null && this.levelUpMoves.containsKey(level)) {
            return new ArrayList<Attack>(BaseStats.severReferences(this.levelUpMoves.get(level)));
        }
        return new ArrayList<Attack>();
    }

    public Moveset loadMoveset(int level) {
        ArrayList<Attack> attackList = this.getMovesUpToLevel(level);
        while (attackList.size() > 4) {
            if (PixelmonConfig.useRecentLevelMoves) {
                attackList.remove(0);
                continue;
            }
            RandomHelper.removeRandomElementFromList(attackList);
        }
        if (attackList.isEmpty()) {
            attackList.add(new Attack("Tackle"));
        }
        Moveset moveset = new Moveset();
        moveset.addAll(BaseStats.severReferences(attackList));
        return moveset;
    }

    public ArrayList<Attack> getTMHMMoves() {
        if (this.tmMoves != null) {
            return BaseStats.severReferences(this.tmMoves);
        }
        return new ArrayList<Attack>();
    }

    public ArrayList<Attack> getTutorMoves() {
        if (this.tutorMoves != null) {
            return BaseStats.severReferences(this.tutorMoves);
        }
        return new ArrayList<Attack>();
    }

    public ArrayList<Attack> getEggMoves() {
        if (this.eggMoves != null) {
            return BaseStats.severReferences(this.eggMoves);
        }
        return new ArrayList<Attack>();
    }

    public ArrayList<Attack> getAllMoves() {
        ArrayList<Attack> moves = new ArrayList<Attack>();
        if (this.levelUpMoves != null && !this.levelUpMoves.isEmpty()) {
            for (Map.Entry<Integer, ArrayList<Attack>> entry : this.levelUpMoves.entrySet()) {
                moves.addAll(BaseStats.severReferences(entry.getValue()));
            }
        }
        moves.addAll(this.getTMHMMoves());
        moves.addAll(this.getTutorMoves());
        moves.addAll(this.getEggMoves());
        ArrayList<Attack> distinctMoves = new ArrayList<Attack>();
        for (Attack attack : moves) {
            if (distinctMoves.contains(attack)) continue;
            distinctMoves.add(attack);
        }
        return distinctMoves;
    }

    public boolean canLearn(String attackName) {
        ArrayList<Attack> allMoves = this.getAllMoves();
        for (Attack attack : allMoves) {
            if (!attack.isAttack(attackName)) continue;
            return true;
        }
        return false;
    }

    public static enum SoundType {
        Neutral,
        Male,
        Female;

    }
}

