/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.moveSkills;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.tools.LineCalc;
import com.pixelmonmod.pixelmon.util.Scheduling;
import java.util.ArrayList;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Cut {
    public static int maximumLogs = 100;
    public static int ticksBetweenChops = 2;
    public static ArrayList<EnumFacing[]> checkDirections = Lists.newArrayList((Object[])new EnumFacing[][]{{EnumFacing.NORTH}, {EnumFacing.SOUTH}, {EnumFacing.EAST}, {EnumFacing.WEST}, {EnumFacing.UP}, {EnumFacing.UP, EnumFacing.NORTH}, {EnumFacing.UP, EnumFacing.SOUTH}, {EnumFacing.UP, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.WEST}});

    public static MoveSkill createMoveSkill() {
        MoveSkill moveSkill = new MoveSkill(new ResourceLocation("pixelmon", "cut")).setName("pixelmon.moveskill.cut.name").describe("pixelmon.moveskill.cut.description1", "pixelmon.moveskill.cut.description2").setIcon(new ResourceLocation("pixelmon", "textures/gui/overlay/externalMoves/cut.png")).setAnyMoves("Cut").setUsePP(true).setRange(8);
        moveSkill.id = "externalmoves.cut.name";
        moveSkill.setBehaviourBlockTarget((pixelmon, tup) -> {
            if (!PixelmonConfig.allowDestructiveExternalMoves) {
                return -1;
            }
            World world = pixelmon.field_70170_p;
            BlockPos pos = (BlockPos)tup.func_76341_a();
            if (!world.func_180495_p(pos).func_177230_c().isWood((IBlockAccess)world, pos)) {
                return -1;
            }
            if (world.func_180495_p(pos).func_177229_b((IProperty)BlockLog.field_176299_a) != BlockLog.EnumAxis.Y) {
                return -1;
            }
            ArrayList<BlockPos> logs = Cut.findTreeLogs(world, pos);
            int logCount = logs.size();
            if (logs.size() > maximumLogs) {
                ChatHandler.sendChat((Entity)pixelmon.func_70902_q(), "pixelmon.moveskill.cut.toomany", new Object[0]);
                return -1;
            }
            float maxLogs = LineCalc.lerp(pixelmon.getPokemonData().getStat(StatsType.Attack), 1.0f, 300.0f, 1.0f, maximumLogs);
            if (maxLogs <= (float)logs.size()) {
                ChatHandler.sendChat((Entity)pixelmon.func_70902_q(), "pixelmon.moveskill.cut.fail", pixelmon.getPokemonData().getDisplayName());
                return -1;
            }
            Scheduling.schedule(ticksBetweenChops, task -> {
                if (!logs.isEmpty()) {
                    BlockPos log = (BlockPos)logs.remove(0);
                    IBlockState state = world.func_180495_p(log);
                    if (((EntityPlayerMP)pixelmon.func_70902_q()).field_71134_c.func_180237_b(log)) {
                        state.func_177230_c().func_176226_b(world, log, state, 2);
                    }
                }
                if (logs.isEmpty()) {
                    task.repeats = false;
                }
            }, true);
            float speed = pixelmon.getPokemonData().getStat(StatsType.Speed);
            return (int)(200.0f + (float)(logCount * 20) * (1.5f - LineCalc.ratio(speed, 1.0f, 200.0f)));
        });
        return moveSkill;
    }

    private static ArrayList<BlockPos> findTreeLogs(World world, BlockPos pos) {
        ArrayList<BlockPos> logs = new ArrayList<BlockPos>();
        ArrayList<BlockPos> newLogs = new ArrayList<BlockPos>();
        newLogs.add(pos);
        while (!newLogs.isEmpty()) {
            Cut.addAdjacentLogs(world, (BlockPos)newLogs.get(0), newLogs, logs);
            logs.add(newLogs.get(0));
            newLogs.remove(0);
        }
        return logs;
    }

    private static void addAdjacentLogs(World world, BlockPos pos, ArrayList<BlockPos> newLogs, ArrayList<BlockPos> logs) {
        for (EnumFacing[] facings : checkDirections) {
            BlockPos loc = pos;
            for (EnumFacing f : facings) {
                loc = loc.func_177972_a(f);
            }
            if (!world.func_180495_p(loc).func_177230_c().isWood((IBlockAccess)world, loc) || Cut.hasLog(logs, loc) || Cut.hasLog(newLogs, loc)) continue;
            newLogs.add(loc);
        }
    }

    private static boolean hasLog(ArrayList<BlockPos> logs, BlockPos loc) {
        for (BlockPos log : logs) {
            if (!log.equals((Object)loc)) continue;
            return true;
        }
        return false;
    }
}

