/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.abilities;

import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.AuraStatus;
import com.pixelmonmod.pixelmon.battles.status.GlobalStatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.enums.EnumType;

public abstract class Aura
extends AbilityBase {
    private EnumType boostType;
    private StatusType auraStatus;

    public Aura(EnumType boostType, StatusType auraStatus) {
        this.boostType = boostType;
        this.auraStatus = auraStatus;
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        GlobalStatusBase current = newPokemon.bc.globalStatusController.getGlobalStatus(this.auraStatus);
        if (current == null) {
            newPokemon.bc.globalStatusController.addGlobalStatus(new AuraStatus(this.boostType, this.auraStatus));
            newPokemon.bc.sendToAll("pixelmon.abilities." + this.auraStatus.toString().toLowerCase(), newPokemon.getNickname());
        }
    }

    @Override
    public void applySwitchOutEffect(PixelmonWrapper oldPokemon) {
        this.removeAuraStatus(oldPokemon);
    }

    @Override
    public void onAbilityLost(PixelmonWrapper pokemon) {
        this.removeAuraStatus(pokemon);
    }

    private void removeAuraStatus(PixelmonWrapper pokemon) {
        for (PixelmonWrapper pw : pokemon.bc.getActivePokemon()) {
            if (pw == pokemon || !pw.getBattleAbility().getClass().isAssignableFrom(this.getClass())) continue;
            return;
        }
        pokemon.bc.globalStatusController.removeGlobalStatus(this.auraStatus);
    }
}

