/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelRegistry;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelSmd;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.models.smd.SmdAnimation;
import com.pixelmonmod.pixelmon.client.models.smd.SmdAnimationSequence;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreen;
import com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor.StatuePacketClient;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity2Client;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumSpecialTexture;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.AnimationVariables;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.IncrementingVariable;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumBoundingBoxMode;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumStatueTextureType;
import com.pixelmonmod.pixelmon.enums.forms.EnumNoForm;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityStatue
extends EntityLiving {
    private static final DataParameter<Integer> dwSpecies = EntityDataManager.func_187226_a(EntityStatue.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> dwForm = EntityDataManager.func_187226_a(EntityStatue.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> dwGender = EntityDataManager.func_187226_a(EntityStatue.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> dwGrowth = EntityDataManager.func_187226_a(EntityStatue.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> dwBoundMode = EntityDataManager.func_187226_a(EntityStatue.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Float> dwRotation = EntityDataManager.func_187226_a(EntityStatue.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> dwScale = EntityDataManager.func_187226_a(EntityStatue.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<String> dwLabel = EntityDataManager.func_187226_a(EntityStatue.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> dwTextures = EntityDataManager.func_187226_a(EntityStatue.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> dwCustomTexture = EntityDataManager.func_187226_a(EntityStatue.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> dwAnimation = EntityDataManager.func_187226_a(EntityStatue.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> dwAnimationFrame = EntityDataManager.func_187226_a(EntityStatue.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> dwAnimationMode = EntityDataManager.func_187226_a(EntityStatue.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> dwIsFlying = EntityDataManager.func_187226_a(EntityStatue.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final Map<String, DataParameter<?>> dwMap = new HashMap();
    private PokemonBase pokemon;
    private EnumGrowth growth = EnumGrowth.Ordinary;
    private EnumBoundingBoxMode boundingMode = EnumBoundingBoxMode.Solid;
    private float rotation = 0.0f;
    private float scale = 1.0f;
    private String label = "";
    private EnumStatueTextureType textureMode = EnumStatueTextureType.OriginalTexture;
    private String customTexture = "";
    private String animation = "";
    private int animationFrame = 0;
    private boolean animate = false;
    private boolean isFlying = false;
    private String lastAnimation = null;
    private int lastFrame = -1;
    private float hover;
    private ResourceLocation lastTexture;
    private boolean exists = true;
    private AnimationVariables animationVariables;

    public EntityStatue(World world) {
        super(world);
        this.field_70180_af.func_187214_a(dwSpecies, (Object)-1);
        this.field_70180_af.func_187214_a(dwForm, (Object)EnumNoForm.NoForm.getForm());
        this.field_70180_af.func_187214_a(dwGender, (Object)Gender.None.getForm());
        this.field_70180_af.func_187214_a(dwGrowth, (Object)((byte)this.growth.index));
        this.field_70180_af.func_187214_a(dwBoundMode, (Object)((byte)this.boundingMode.ordinal()));
        this.field_70180_af.func_187214_a(dwRotation, (Object)Float.valueOf(this.rotation));
        this.field_70180_af.func_187214_a(dwScale, (Object)Float.valueOf(this.scale));
        this.field_70180_af.func_187214_a(dwLabel, (Object)this.label);
        this.field_70180_af.func_187214_a(dwTextures, (Object)this.textureMode.ordinal());
        this.field_70180_af.func_187214_a(dwCustomTexture, (Object)this.customTexture);
        this.field_70180_af.func_187214_a(dwAnimation, (Object)this.animation);
        this.field_70180_af.func_187214_a(dwAnimationFrame, (Object)this.animationFrame);
        this.field_70180_af.func_187214_a(dwAnimationMode, (Object)this.animate);
        this.field_70180_af.func_187214_a(dwIsFlying, (Object)this.isFlying);
        this.func_189654_d(true);
    }

    public void setPokemon(PokemonBase pokemon) {
        this.pokemon = pokemon.copyBase();
        this.pokemon.registerDataParameters(dwMap);
        this.field_70180_af.func_187227_b(dwSpecies, (Object)pokemon.getSpecies().getNationalPokedexInteger());
        this.field_70180_af.func_187227_b(dwForm, (Object)((byte)pokemon.getForm()));
        this.field_70180_af.func_187227_b(dwGender, (Object)pokemon.getGender().getForm());
        this.initAnimation();
    }

    public PokemonBase getPokemon() {
        return this.pokemon;
    }

    public void setSpecies(EnumSpecies pokemon) {
        this.setPokemon(new PokemonBase(pokemon));
    }

    public EnumSpecies getSpecies() {
        return this.pokemon.getSpecies();
    }

    public void setForm(int form) {
        if (this.getSpecies().getNumForms(true) > 0) {
            if (this.getSpecies().getFormEnum(form) == EnumNoForm.NoForm) {
                form = -1;
            }
        } else if (Gender.mfModels.contains(this.getSpecies())) {
            this.field_70180_af.func_187227_b(dwGender, (Object)Gender.getGender((short)form).getForm());
            form = -1;
        } else {
            form = -1;
        }
        this.field_70180_af.func_187227_b(dwForm, (Object)((byte)form));
    }

    public int getForm() {
        return this.pokemon.getFormEnum().getForm();
    }

    public void setGender(Gender gender) {
        if (Gender.mfModels.contains(this.getSpecies())) {
            this.field_70180_af.func_187227_b(dwForm, (Object)-1);
        }
        this.field_70180_af.func_187227_b(dwGender, (Object)((byte)gender.ordinal()));
    }

    public Gender getGender() {
        return this.pokemon.getGender();
    }

    public IEnumForm getFormEnum() {
        if (Gender.mfModels.contains(this.getSpecies()) || EnumSpecies.mfTextured.contains(this.getSpecies())) {
            return this.getGender();
        }
        return this.getSpecies().getFormEnum(this.getForm());
    }

    public void setGrowth(EnumGrowth growth) {
        this.field_70180_af.func_187227_b(dwGrowth, (Object)((byte)growth.index));
    }

    public EnumGrowth getGrowth() {
        return this.growth;
    }

    public void setRotation(float rotation) {
        this.field_70180_af.func_187227_b(dwRotation, (Object)Float.valueOf(rotation));
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setPixelmonScale(float scale) {
        this.field_70180_af.func_187227_b(dwScale, (Object)Float.valueOf(scale));
    }

    public float getPixelmonScale() {
        return this.scale;
    }

    public void setLabel(String label) {
        this.field_70180_af.func_187227_b(dwLabel, (Object)label);
    }

    public String getLabel() {
        return this.label;
    }

    public void setTextureType(EnumStatueTextureType type) {
        this.field_70180_af.func_187227_b(dwTextures, (Object)type.ordinal());
    }

    public EnumStatueTextureType getTextureType() {
        return this.textureMode;
    }

    public void setAnimation(String animationName) {
        this.field_70180_af.func_187227_b(dwAnimation, (Object)animationName);
    }

    public String getAnimation() {
        String animationType = (String)this.field_70180_af.func_187225_a(dwAnimation);
        if (animationType == null || animationType.equals("")) {
            animationType = "walk";
            this.setAnimation(animationType);
        }
        return animationType;
    }

    public void setAnimationFrame(int animationFrame) {
        if (animationFrame < 0) {
            animationFrame = 0;
        }
        this.field_70180_af.func_187227_b(dwAnimationFrame, (Object)animationFrame);
    }

    public int getAnimationFrame() {
        return this.animationFrame;
    }

    public void setAnimate(boolean value) {
        this.field_70180_af.func_187227_b(dwAnimationMode, (Object)value);
    }

    public boolean getShouldAnimate() {
        return this.animate;
    }

    public BaseStats getBaseStats() {
        return this.getSpecies().getBaseStats(this.getFormEnum());
    }

    public EnumBossMode getBossMode() {
        return this.textureMode.bossMode;
    }

    public void func_70071_h_() {
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        this.field_70177_z = this.field_70759_as = this.getRotation();
        super.func_70071_h_();
        if (this.field_70173_aa % 64 == 1) {
            this.updateSize();
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.animate && this.animationVariables != null) {
                this.animationVariables.tick();
                if (this.getModel() instanceof PixelmonModelSmd) {
                    PixelmonModelSmd smdModel = (PixelmonModelSmd)this.getModel();
                    IncrementingVariable inc = this.getAnimationVariables().getCounter(-1);
                    if (inc == null) {
                        this.getAnimationVariables().setCounter(-1, 2.1474836E9f, smdModel.animationIncrement);
                    } else {
                        inc.increment = smdModel.animationIncrement;
                    }
                }
            }
            if ((this.lastAnimation == null || this.lastFrame == -1 || this.lastFrame != this.getAnimationFrame() || !this.lastAnimation.equals(this.getAnimation())) && this.isSmd()) {
                SmdAnimation theAnim;
                this.lastAnimation = this.getAnimation();
                this.lastFrame = this.getAnimationFrame();
                ValveStudioModel model = ((PixelmonModelSmd)this.getModel()).theModel;
                model.setAnimation(this.getAnimation());
                SmdAnimation smdAnimation = theAnim = model.currentSequence == null ? null : model.currentSequence.current();
                if (theAnim == null || theAnim.totalFrames == 0) {
                    return;
                }
                if (this.getAnimationFrame() >= theAnim.totalFrames) {
                    this.setAnimationFrame(theAnim.totalFrames - 1);
                }
                theAnim.setCurrentFrame(this.getAnimationFrame());
                model.animate();
                this.updateSize();
            }
        }
    }

    public void func_70636_d() {
        if (this.field_70716_bi > 0 && !this.func_184186_bw()) {
            double d0 = this.field_70165_t + (this.field_184623_bh - this.field_70165_t) / (double)this.field_70716_bi;
            double d1 = this.field_70163_u + (this.field_184624_bi - this.field_70163_u) / (double)this.field_70716_bi;
            double d2 = this.field_70161_v + (this.field_184625_bj - this.field_70161_v) / (double)this.field_70716_bi;
            double d3 = MathHelper.func_76138_g((double)(this.field_184626_bk - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.field_70716_bi);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70709_bj - (double)this.field_70125_A) / (double)this.field_70716_bi);
            --this.field_70716_bi;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        } else if (!this.func_70613_aW()) {
            this.field_70159_w *= 0.98;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.98;
        }
        if (Math.abs(this.field_70159_w) < 0.003) {
            this.field_70159_w = 0.0;
        }
        if (Math.abs(this.field_70181_x) < 0.003) {
            this.field_70181_x = 0.0;
        }
        if (Math.abs(this.field_70179_y) < 0.003) {
            this.field_70179_y = 0.0;
        }
        this.field_70170_p.field_72984_F.func_76320_a("travel");
        this.field_70702_br *= 0.98f;
        this.field_191988_bg *= 0.98f;
        this.field_70704_bt *= 0.9f;
        this.func_191986_a(this.field_70702_br, this.field_70701_bs, this.field_191988_bg);
        this.field_70170_p.field_72984_F.func_76319_b();
        if (this.boundingMode == EnumBoundingBoxMode.Pushout) {
            this.field_70170_p.field_72984_F.func_76320_a("push");
            this.func_85033_bc();
            this.field_70170_p.field_72984_F.func_76319_b();
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player instanceof EntityPlayerMP && !stack.func_190926_b() && stack.func_77973_b() == PixelmonItems.chisel) {
            Pixelmon.network.sendTo((IMessage)new StatuePacketClient(this.func_110124_au()), (EntityPlayerMP)player);
            OpenScreen.open(player, EnumGuiScreen.StatueEditor, this.func_145782_y());
        }
        return false;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (key.func_187155_a() == dwSpecies.func_187155_a() && this.pokemon == null) {
            this.pokemon = new PokemonBase(EnumSpecies.getFromDex((Integer)this.field_70180_af.func_187225_a(dwSpecies)));
            this.pokemon.registerDataParameters(dwMap);
        }
        if (!dwMap.values().contains(key) || !this.pokemon.dataManagerChange(key, this.field_70180_af.func_187225_a(key))) {
            if (key.func_187155_a() == dwGrowth.func_187155_a()) {
                this.growth = EnumGrowth.getGrowthFromIndex(((Byte)this.field_70180_af.func_187225_a(dwGrowth)).byteValue());
            } else if (key.func_187155_a() == dwBoundMode.func_187155_a()) {
                this.boundingMode = EnumBoundingBoxMode.getMode((Byte)this.field_70180_af.func_187225_a(dwBoundMode));
            } else if (key.func_187155_a() == dwRotation.func_187155_a()) {
                this.rotation = ((Float)this.field_70180_af.func_187225_a(dwRotation)).floatValue();
            } else if (key.func_187155_a() == dwScale.func_187155_a()) {
                this.scale = ((Float)this.field_70180_af.func_187225_a(dwScale)).floatValue();
            } else if (key.func_187155_a() == dwLabel.func_187155_a()) {
                this.label = (String)this.field_70180_af.func_187225_a(dwLabel);
            } else if (key.func_187155_a() == dwTextures.func_187155_a()) {
                this.textureMode = EnumStatueTextureType.getFromOrdinal((Integer)this.field_70180_af.func_187225_a(dwTextures));
            } else if (key.func_187155_a() == dwCustomTexture.func_187155_a()) {
                this.customTexture = (String)this.field_70180_af.func_187225_a(dwCustomTexture);
            } else if (key.func_187155_a() == dwAnimation.func_187155_a()) {
                this.animation = (String)this.field_70180_af.func_187225_a(dwAnimation);
            } else if (key.func_187155_a() == dwAnimationFrame.func_187155_a()) {
                this.animationFrame = (Integer)this.field_70180_af.func_187225_a(dwAnimationFrame);
            } else if (key.func_187155_a() == dwAnimationMode.func_187155_a()) {
                this.animate = (Boolean)this.field_70180_af.func_187225_a(dwAnimationMode);
            } else if (key.func_187155_a() == dwIsFlying.func_187155_a()) {
                this.isFlying = (Boolean)this.field_70180_af.func_187225_a(dwIsFlying);
            }
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.pokemon.writeToNBT(nbt);
        nbt.func_74774_a("Variant", (byte)this.pokemon.getForm());
        nbt.func_74774_a("Growth", (byte)this.growth.index);
        nbt.func_74774_a("BoundingBoxMode", (byte)this.boundingMode.ordinal());
        nbt.func_74776_a("StartingYaw", this.field_70177_z);
        nbt.func_74778_a("statueLabel", this.getLabel());
        nbt.func_74777_a("statueTexture", (short)this.getTextureType().ordinal());
        if (!this.customTexture.isEmpty()) {
            nbt.func_74778_a("CustomTexture", this.customTexture);
        } else {
            nbt.func_82580_o("CustomTexture");
        }
        nbt.func_74778_a("statueAnimation", this.getAnimation());
        nbt.func_74768_a("statueFrame", this.getAnimationFrame());
        nbt.func_74757_a("Animate", this.animate);
        nbt.func_74757_a("statueModelType", !this.getIsFlying());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        PokemonBase base = new PokemonBase();
        base.readFromNBT(nbt);
        this.setPokemon(base);
        if (nbt.func_74764_b("Growth")) {
            this.setGrowth(EnumGrowth.getFromNBT(nbt));
        }
        if (nbt.func_74764_b("BoundingBoxMode")) {
            this.field_70180_af.func_187227_b(dwBoundMode, (Object)nbt.func_74771_c("BoundingBoxMode"));
        }
        if (nbt.func_74764_b("StartingYaw")) {
            this.setRotation(nbt.func_74760_g("StartingYaw"));
        }
        if (nbt.func_74764_b("statueLabel")) {
            this.setLabel(nbt.func_74779_i("statueLabel"));
        }
        if (nbt.func_74764_b("statueTexture")) {
            this.setTextureType(EnumStatueTextureType.getFromOrdinal(nbt.func_74765_d("statueTexture")));
        }
        if (nbt.func_74764_b("CustomTexture")) {
            this.field_70180_af.func_187227_b(dwCustomTexture, (Object)nbt.func_74779_i("CustomTexture"));
        }
        if (nbt.func_74764_b("statueAnimation")) {
            this.setAnimation(nbt.func_74779_i("statueAnimation"));
            this.setAnimationFrame(nbt.func_74762_e("statueFrame"));
            this.setIsFlying(!nbt.func_74767_n("statueModelType"));
            this.setAnimate(nbt.func_74767_n("Animate"));
        }
    }

    public String func_70005_c_() {
        return this.getSpecies().getLocalizedName();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean func_70648_aU() {
        return true;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.boundingMode == EnumBoundingBoxMode.Solid ? this.func_174813_aQ() : null;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(PixelmonItems.chisel);
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        this.updateSize();
    }

    public float func_70047_e() {
        return this.field_70131_O / 0.85f + this.hover;
    }

    private void updateSize() {
        if (this.pokemon == null) {
            return;
        }
        BaseStats baseStats = this.getBaseStats();
        float scale = this.getPixelmonScale() * this.getScaleFactor();
        this.field_70131_O = baseStats.height.floatValue() * scale;
        this.field_70130_N = baseStats.width.floatValue() * scale;
        this.hover = baseStats.hovers() ? baseStats.hoverHeight.floatValue() : 0.0f;
        float halfWidth = this.field_70130_N / 2.0f;
        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - (double)halfWidth, this.field_70163_u, this.field_70161_v - (double)halfWidth, this.field_70165_t + (double)halfWidth, this.field_70163_u + (double)this.field_70131_O + (baseStats.hovers() ? 1.0 : 0.6), this.field_70161_v + (double)halfWidth));
    }

    public float getScaleFactor() {
        return (float)Math.pow(this.getGrowth().scaleValue, PixelmonConfig.getGrowthModifier()) * this.getBossMode().scaleFactor;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTexture() {
        EnumStatueTextureType type = this.getTextureType();
        if (type == EnumStatueTextureType.Stone) {
            return new ResourceLocation("pixelmon:textures/pokemon/statue.png");
        }
        if (type == EnumStatueTextureType.Gold) {
            return new ResourceLocation("pixelmon:textures/pokemon/gold.png");
        }
        if (type == EnumStatueTextureType.Silver) {
            return new ResourceLocation("pixelmon:textures/pokemon/silver.png");
        }
        if (type == EnumStatueTextureType.Bronze) {
            return new ResourceLocation("pixelmon:textures/pokemon/bronze.png");
        }
        EnumSpecies pokemon = this.getSpecies();
        ResourceLocation location = Entity2Client.getTextureFor(pokemon, this.getFormEnum(), this.getGender(), (String)this.field_70180_af.func_187225_a(dwCustomTexture), type == EnumStatueTextureType.Special ? pokemon.getSpecialTexture() : EnumSpecialTexture.None, type == EnumStatueTextureType.Shiny);
        if (!Objects.equals(this.lastTexture, location)) {
            this.lastTexture = location;
            this.exists = Pixelmon.proxy.resourceLocationExists(location);
        }
        return this.exists ? location : Entity2Client.getOGTexture(pokemon, this.getFormEnum(), this.getGender(), type == EnumStatueTextureType.Shiny);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSmd() {
        return this.getModel() instanceof PixelmonModelSmd;
    }

    public AnimationType getCurrentAnimation() {
        return AnimationType.getTypeFor(this.getAnimation());
    }

    private void initAnimation() {
        ModelBase base;
        if (this.field_70170_p.field_72995_K && (base = this.getModel()) instanceof PixelmonModelSmd) {
            ValveStudioModel model = ((PixelmonModelSmd)base).theModel;
            model.animate();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getFrameCount() {
        if (this.isSmd()) {
            ValveStudioModel model = ((PixelmonModelSmd)this.getModel()).theModel;
            model.setAnimation(this.getAnimation());
            SmdAnimationSequence sequence = model.currentSequence;
            return sequence == null || sequence.current() == null ? 0 : sequence.current().totalFrames;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public String nextAnimation() {
        if (this.isSmd()) {
            String animation = this.getAnimation();
            Iterator<Map.Entry<String, SmdAnimationSequence>> it = ((PixelmonModelSmd)this.getModel()).theModel.anims.entrySet().iterator();
            String first = null;
            boolean takeNext = false;
            while (it.hasNext()) {
                Map.Entry<String, SmdAnimationSequence> entry = it.next();
                String key = entry.getKey();
                if (first == null) {
                    first = key;
                }
                if (takeNext) {
                    return key;
                }
                if (!key.equals(animation)) continue;
                takeNext = true;
            }
            return first;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getAllAnimations() {
        ArrayList<String> animations = new ArrayList<String>();
        if (this.isSmd()) {
            animations.addAll(((PixelmonModelSmd)this.getModel()).theModel.anims.keySet());
        }
        return animations;
    }

    public AnimationVariables getAnimationVariables() {
        if (this.animationVariables == null) {
            this.animationVariables = new AnimationVariables();
        }
        return this.animationVariables;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBase getModel() {
        ModelBase model;
        if (this.getIsFlying() && this.hasFlyingModel()) {
            return PixelmonModelRegistry.getFlyingModel(this.getSpecies(), this.getFormEnum());
        }
        if (this.getTextureType() == EnumStatueTextureType.Special && (model = PixelmonModelRegistry.getSpecialModel(this.getSpecies(), this.pokemon.getFormEnum(), this.getSpecies().getSpecialTexture())) != null) {
            return model;
        }
        return PixelmonModelRegistry.getModel(this.getSpecies(), this.getFormEnum());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasFlyingModel() {
        return PixelmonModelRegistry.hasFlyingModel(this.getSpecies(), this.getSpecies().getFormEnum(this.getForm()));
    }

    public void setIsFlying(boolean isFlying) {
        this.field_70180_af.func_187227_b(dwIsFlying, (Object)isFlying);
    }

    public boolean getIsFlying() {
        return this.isFlying;
    }

    static {
        dwMap.put("pokemon", dwSpecies);
        dwMap.put("form", dwForm);
        dwMap.put("gender", dwGender);
    }
}

