/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity2Client;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.FlyingParameters;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Level;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Pokerus;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.SwimmingParameters;
import com.pixelmonmod.pixelmon.entities.pixelmon.tickHandlers.CastformTickHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.tickHandlers.TickHandlerBase;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumMegaPokemon;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.forms.EnumNoForm;
import com.pixelmonmod.pixelmon.enums.forms.EnumPrimal;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasStorage;
import java.util.Optional;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public abstract class Entity3HasStats
extends Entity2Client {
    private TickHandlerBase tickHandler;
    int friendshipTicker = 0;

    public Entity3HasStats(World par1World) {
        super(par1World);
    }

    public Level getLvl() {
        return this.getPokemonData().getLevelContainer();
    }

    float getMoveSpeed() {
        return 0.3f + (1.0f - (200.0f - (float)this.pokemon.getStat(StatsType.Speed)) / 200.0f) * 0.3f;
    }

    @Override
    public void setBoss(EnumBossMode mode) {
        super.setBoss(mode);
        if (this.getBossMode().isBossPokemon()) {
            if (this.getSpecies().hasMega()) {
                int numMegas = EnumMegaPokemon.getMega((EnumSpecies)this.getSpecies()).numMegaForms;
                int form = 1;
                if (numMegas > 1) {
                    form = RandomHelper.getRandomNumberBetween(1, numMegas);
                }
                this.setForm(form);
            }
            if (this.getSpecies().getFormEnum(1) instanceof EnumPrimal) {
                this.setForm(1);
            }
            this.getPokemonData().setShiny(mode.extraLevels >= EnumBossMode.Legendary.extraLevels);
        }
    }

    @Override
    public void evolve(PokemonSpec evolveTo) {
        BaseStats oldBaseStats = this.getBaseStats();
        EnumSpecies previous = this.getSpecies();
        super.evolve(evolveTo);
        float oldHp = this.pokemon.getStat(StatsType.HP);
        float oldHealth = this.func_110143_aJ();
        if (evolveTo.form != null) {
            this.setForm(evolveTo.form.byteValue());
        } else if (this.getPokemonData().getForm() == -1) {
            if (!previous.getPossibleForms(false).contains(Gender.Male) && !Gender.mfModels.contains(previous) && (this.getSpecies().getPossibleForms(false).contains(Gender.Male) || Gender.mfModels.contains(this.getSpecies()))) {
                this.setForm(this.pokemon.getGender().getForm());
            } else {
                this.setForm(0);
            }
        }
        this.getPokemonData().evolve(evolveTo);
        if (oldBaseStats.abilities[1] == null && this.getBaseStats().abilities[1] != null) {
            this.getPokemonData().setAbilitySlot(RandomHelper.getRandomNumberBetween(0, 1));
        }
        this.updateStats();
        float newHealth = this.pokemon.getStat(StatsType.HP);
        if (oldHp != 0.0f) {
            newHealth = oldHealth / oldHp * (float)this.pokemon.getStat(StatsType.HP);
        }
        this.func_70606_j((int)Math.ceil(newHealth));
        if (this.func_70902_q() != null) {
            this.update(EnumUpdateType.Name, EnumUpdateType.Stats);
        }
    }

    public void func_70606_j(float par1) {
        super.func_70606_j(par1);
        this.updateHealth();
    }

    public void updateHealth() {
        if (this.func_110143_aJ() > this.func_110138_aP()) {
            super.func_70606_j(this.func_110138_aP());
        }
        if (this.func_110143_aJ() < 0.0f) {
            super.func_70606_j(0.0f);
        }
        if (this.pokemon != null && this.func_70902_q() != null && !this.field_70170_p.field_72995_K) {
            this.update(EnumUpdateType.HP);
        }
    }

    public void updateStats() {
        this.pokemon.getStats().setLevelStats(this.pokemon.getNature(), this.getBaseStats(), this.pokemon.getLevel());
        this.field_70180_af.func_187227_b(EntityPixelmon.dwMaxHP, (Object)this.pokemon.getStat(StatsType.HP));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.pokemon.getStat(StatsType.HP));
        this.updateHealth();
    }

    public Optional<Pokerus> getPokerus() {
        return Optional.ofNullable(this.pokemon.getPokerus());
    }

    public IEnumForm getFormEnum() {
        if (Gender.mfModels.contains(this.getSpecies())) {
            return this.getPokemonData().getGender();
        }
        return this.getSpecies().getFormEnum(this.getPokemonData().getForm());
    }

    public static IEnumForm getFormEnum(EnumSpecies species, int gender, int form) {
        if (Gender.mfModels.contains(species)) {
            return Gender.getGender((short)gender);
        }
        return species.getFormEnum(form);
    }

    public void setForm(int form) {
        this.getPokemonData().setForm(form);
    }

    public boolean hasForms() {
        return Entity3HasStats.hasForms(this.getSpecies());
    }

    public int getNumForms() {
        return this.hasForms() ? Entity3HasStats.getNumForms(this.getSpecies()) : 0;
    }

    public int getFormIncludeTransformed() {
        if (this.transformed != null) {
            return this.transformed.getForm();
        }
        return this.pokemon.getForm();
    }

    public int getPartyPosition() {
        PokemonStorage storage = this.getStorage();
        if (storage == null || !(storage instanceof PartyStorage)) {
            return -1;
        }
        return storage.getPosition((Pokemon)this.pokemon).order;
    }

    public SpawnLocationType getDefaultSpawnLocation() {
        if (this.getBaseStats() != null && this.getBaseStats().spawnLocations != null && this.getBaseStats().spawnLocations.length > 0) {
            return this.getBaseStats().spawnLocations[0];
        }
        return SpawnLocationType.Land;
    }

    public FlyingParameters getFlyingParameters() {
        return this.getBaseStats().flyingParameters;
    }

    public SwimmingParameters getSwimmingParameters() {
        return this.getBaseStats().swimmingParameters;
    }

    public boolean func_70648_aU() {
        return this.getBaseStats() == null || this.getSpawnLocation() == SpawnLocationType.Water || this.getBaseStats().getTypeList().contains((Object)EnumType.Water);
    }

    public void func_70107_b(double x, double y, double z) {
        float scaleFactor;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        float scale = 1.0f;
        float f = scaleFactor = PixelmonConfig.scaleModelsUp ? 1.3f : 1.0f;
        if (this.pokemon != null) {
            scale = this.getPixelmonScale() * scaleFactor * this.getScaleFactor();
        }
        if (this.getBaseStats() != null) {
            float halfWidth = this.getBaseStats().width.floatValue() * scale / 2.0f;
            this.func_174826_a(new AxisAlignedBB(x - (double)halfWidth, y, z - (double)halfWidth, x + (double)halfWidth, y + (double)this.getBaseStats().height.floatValue() * (double)scale + (double)(!this.getBaseStats().hovers() ? 1 : 0), z + (double)halfWidth));
        } else {
            float halfWidth = this.field_70130_N * scale / 2.0f;
            this.func_174826_a(new AxisAlignedBB(x - (double)halfWidth, y, z - (double)halfWidth, x + (double)halfWidth, y - this.func_70033_W() + (double)this.field_70131_O * (double)scale, z + (double)halfWidth));
        }
    }

    @Override
    public void func_70071_h_() {
        if (this.func_70902_q() != null && !this.field_70170_p.field_72995_K && ++this.friendshipTicker % 800 == 0) {
            int amount;
            this.friendshipTicker = 0;
            int n = amount = this.pokemon.getFriendship() < 200 ? 2 : 1;
            if (this.pokemon.getHeldItemAsItemHeld().getHeldItemType() == EnumHeldItems.sootheBell) {
                amount = (int)((double)amount * 1.5);
            }
            this.pokemon.increaseFriendship(amount);
            PixelExtrasStorage.getData(this.func_184753_b()).checkPokemon(this.pokemon);
        }
        if (this.hasOwner() && this.func_70902_q() == null && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
        if (this.getSpecies() == EnumSpecies.Castform && !(this.tickHandler instanceof CastformTickHandler)) {
            this.tickHandler = new CastformTickHandler((EntityPixelmon)this);
        }
        if (this.tickHandler != null) {
            this.tickHandler.tick(this.field_70170_p);
        }
        super.func_70071_h_();
    }

    public static boolean hasForms(EnumSpecies species) {
        return species.getNumForms(false) > 0;
    }

    public static boolean hasForms(String name) {
        Optional<EnumSpecies> species = EnumSpecies.getFromName(name);
        return species.isPresent() && Entity3HasStats.hasForms(species.get());
    }

    public static int getNumForms(String name) {
        Optional<EnumSpecies> species = EnumSpecies.getFromName(name);
        return species.isPresent() ? Entity3HasStats.getNumForms(species.get()) : 0;
    }

    public static int getNumForms(EnumSpecies species) {
        return Entity3HasStats.hasForms(species) ? species.getNumForms(false) : 0;
    }

    public static int getRandomForm(EnumSpecies species) {
        if (Entity3HasStats.hasForms(species)) {
            return species.getFormEnum(0) instanceof EnumNoForm ? EnumNoForm.NoForm.getForm() : RandomHelper.rand.nextInt(Entity3HasStats.getNumForms(species));
        }
        return -1;
    }
}

