/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.customStarters;

import com.google.common.reflect.TypeToken;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.config.StarterList;
import com.pixelmonmod.pixelmon.entities.npcs.registry.PokemonForm;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import info.pixelmon.repack.ninja.leaping.configurate.commented.CommentedConfigurationNode;
import info.pixelmon.repack.ninja.leaping.configurate.objectmapping.ObjectMappingException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.text.translation.I18n;

public class CustomStarters {
    private static List<String> starters = Arrays.asList("Bulbasaur", "Squirtle", "Charmander", "Chikorita", "Totodile", "Cyndaquil", "Treecko", "Mudkip", "Torchic", "Turtwig", "Piplup", "Chimchar", "Snivy", "Oshawott", "Tepig", "Chespin", "Froakie", "Fennekin", "Rowlet", "Popplio", "Litten");
    public static PokemonForm[] starterList = new PokemonForm[21];
    public static int starterLevel = 5;
    public static boolean shinyStarter = false;

    public static void loadConfig(CommentedConfigurationNode mainNode) throws ObjectMappingException {
        CommentedConfigurationNode customStarters = mainNode.getNode("Starters");
        starterLevel = Math.max(1, Math.min(customStarters.getNode("level").setComment(I18n.func_74838_a((String)"pixelmon.config.starterLevel.comment")).getInt(5), PixelmonServerConfig.maxLevel));
        shinyStarter = customStarters.getNode("shiny").setComment(I18n.func_74838_a((String)"pixelmon.config.starterShiny.comment")).getBoolean(false);
        boolean useCustom = customStarters.getNode("useCustomStarters").setComment(I18n.func_74838_a((String)"pixelmon.config.useCustomStarters.comment")).getBoolean(false);
        if (useCustom) {
            starters = customStarters.getNode("starterList").setComment(I18n.func_74838_a((String)"pixelmon.config.starterList.comment")).getList(TypeToken.of(String.class), starters);
        }
        int starterNum = 0;
        for (String pokemonName : starters) {
            Optional<EnumSpecies> pokemonOptional;
            int numberIndex;
            if (starterNum >= 21) break;
            if (!"Porygon2".equalsIgnoreCase(pokemonName)) {
                for (numberIndex = pokemonName.length() - 1; numberIndex >= 0 && pokemonName.charAt(numberIndex) >= '0' && pokemonName.charAt(numberIndex) <= '9'; --numberIndex) {
                }
            }
            if (!(pokemonOptional = EnumSpecies.getFromName(pokemonName.substring(0, numberIndex + 1))).isPresent()) continue;
            EnumSpecies pokemonEnum = pokemonOptional.get();
            PokemonForm pokemonForm = new PokemonForm(pokemonEnum);
            if (Entity3HasStats.hasForms(pokemonEnum)) {
                int formIndex = -1;
                try {
                    formIndex = Integer.parseInt(pokemonName.substring(numberIndex + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (formIndex == -1) {
                    formIndex = Entity3HasStats.getRandomForm(pokemonEnum);
                }
                pokemonForm.form = formIndex;
            }
            CustomStarters.starterList[starterNum] = pokemonForm;
            ++starterNum;
        }
        StarterList.setStarterList(starterList);
    }
}

