/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.blocks.decorative.BlockUnown;
import com.pixelmonmod.pixelmon.config.PixelmonBlocks;
import com.pixelmonmod.pixelmon.config.PixelmonBlocksApricornTrees;
import com.pixelmonmod.pixelmon.config.PixelmonBlocksBerryTrees;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.config.PixelmonItemsApricorns;
import com.pixelmonmod.pixelmon.config.PixelmonItemsBadgecases;
import com.pixelmonmod.pixelmon.config.PixelmonItemsBadges;
import com.pixelmonmod.pixelmon.config.PixelmonItemsFossils;
import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.config.PixelmonItemsLures;
import com.pixelmonmod.pixelmon.config.PixelmonItemsMail;
import com.pixelmonmod.pixelmon.config.PixelmonItemsPokeballs;
import com.pixelmonmod.pixelmon.config.PixelmonItemsTMs;
import com.pixelmonmod.pixelmon.config.PixelmonItemsTools;
import com.pixelmonmod.pixelmon.config.PixelmonItemsValuables;
import com.pixelmonmod.pixelmon.config.PixelmonOres;
import com.pixelmonmod.pixelmon.config.PixelmonPotions;
import com.pixelmonmod.pixelmon.config.RemapHandler;
import com.pixelmonmod.pixelmon.config.TileEntityRegistry;
import com.pixelmonmod.pixelmon.config.recipes.PotionRecipe;
import com.pixelmonmod.pixelmon.config.recipes.StatsRecipe;
import com.pixelmonmod.pixelmon.config.recipes.StatusHealRecipe;
import com.pixelmonmod.pixelmon.config.recipes.UnownBlockRecipe;
import com.pixelmonmod.pixelmon.sounds.PixelSounds;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegistryListener {
    @SubscribeEvent
    public static void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        PixelmonBlocks.load();
        PixelmonBlocksBerryTrees.load();
        PixelmonBlocksApricornTrees.load();
        PixelmonBlocks.registerBlocks(event);
        PixelmonBlocksBerryTrees.registerBlocks(event);
        RegistryListener.registerAllFields(PixelmonBlocksApricornTrees.class, Block.class, event.getRegistry());
        TileEntityRegistry.registerTileEntities();
    }

    @SubscribeEvent
    public static void onRemapBlocks(RegistryEvent.MissingMappings<Block> event) {
        RemapHandler.remapBlocks((List<RegistryEvent.MissingMappings.Mapping<Block>>)event.getMappings());
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        PixelmonItems.load();
        PixelmonItemsHeld.load();
        PixelmonItemsTools.load();
        PixelmonItemsBadges.load();
        PixelmonItemsValuables.load();
        PixelmonItemsFossils.load();
        PixelmonItemsPokeballs.load();
        PixelmonItemsApricorns.load();
        PixelmonItemsBadgecases.load();
        PixelmonItemsLures.load();
        RegistryListener.registerAllFields(PixelmonItems.class, Item.class, event.getRegistry());
        RegistryListener.registerAllFields(PixelmonItemsHeld.class, Item.class, event.getRegistry());
        RegistryListener.registerAllFields(PixelmonItemsTools.class, Item.class, event.getRegistry());
        RegistryListener.registerAllFields(PixelmonItemsBadges.class, Item.class, event.getRegistry());
        RegistryListener.registerAllFields(PixelmonItemsValuables.class, Item.class, event.getRegistry());
        RegistryListener.registerAllFields(PixelmonItemsFossils.class, Item.class, event.getRegistry());
        RegistryListener.registerAllFields(PixelmonItemsPokeballs.class, Item.class, event.getRegistry());
        RegistryListener.registerAllFields(PixelmonItemsApricorns.class, Item.class, event.getRegistry());
        RegistryListener.registerAllFields(PixelmonItemsBadgecases.class, Item.class, event.getRegistry());
        PixelmonItemsTMs.registerItems(event);
        PixelmonItemsMail.registerMailItems(event);
        PixelmonItemsLures.registerItems(event);
        Pixelmon.proxy.fixModelDefs();
        Pixelmon.proxy.registerBlockModels();
        PixelmonOres.populateOres();
        PixelmonOres.registerOres();
    }

    @SubscribeEvent
    public static void onRemapItems(RegistryEvent.MissingMappings<Item> event) {
        RemapHandler.remapItems((List<RegistryEvent.MissingMappings.Mapping<Item>>)event.getMappings());
    }

    @SubscribeEvent
    public static void onRegisterRecipes(RegistryEvent.Register<IRecipe> event) {
        for (int i = 0; i < BlockUnown.getNumUnownBlocks(); ++i) {
            event.getRegistry().register((IForgeRegistryEntry)new UnownBlockRecipe(i));
        }
        FurnaceRecipes furnaceRecipes = FurnaceRecipes.func_77602_a();
        PixelmonOres.registerFurnaceRecipes(furnaceRecipes);
        PixelmonItemsApricorns.registerFurnaceRecipes(furnaceRecipes);
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new PotionRecipe());
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new StatsRecipe());
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new StatusHealRecipe());
    }

    @SubscribeEvent
    public static void onRegisterEntities(RegistryEvent.Register<EntityEntry> event) {
        PixelmonEntityList.registerEntities();
    }

    @SubscribeEvent
    public static void onRemapEntities(RegistryEvent.MissingMappings<EntityEntry> event) {
        RemapHandler.remapEntities((List<RegistryEvent.MissingMappings.Mapping<EntityEntry>>)event.getMappings());
    }

    @SubscribeEvent
    public static void onRegisterSounds(RegistryEvent.Register<SoundEvent> event) {
        PixelSounds.registerSounds((IForgeRegistry<SoundEvent>)event.getRegistry());
    }

    @SubscribeEvent
    public static void onRemapSounds(RegistryEvent.MissingMappings<SoundEvent> event) {
        event.getMappings().forEach(RegistryEvent.MissingMappings.Mapping::ignore);
        event.getAllMappings().forEach(s -> {
            if (s.key.toString().equalsIgnoreCase("minecraft:entity.experience_orb.touch")) {
                s.ignore();
            }
        });
    }

    @SubscribeEvent
    public static void onRegisterModels(ModelRegistryEvent event) {
        PixelmonItems.registerRenderers();
        RegistryListener.registerItemRenderersByFields(PixelmonItemsHeld.class);
        RegistryListener.registerItemRenderersByFields(PixelmonItemsTools.class);
        RegistryListener.registerItemRenderersByFields(PixelmonItemsBadges.class);
        RegistryListener.registerItemRenderersByFields(PixelmonItemsValuables.class);
        RegistryListener.registerItemRenderersByFields(PixelmonItemsFossils.class);
        RegistryListener.registerItemRenderersByFields(PixelmonItemsPokeballs.class);
        RegistryListener.registerItemRenderersByFields(PixelmonItemsApricorns.class);
        RegistryListener.registerItemRenderersByFields(PixelmonItemsBadgecases.class);
        PixelmonItemsTMs.registerRenderers();
        PixelmonItemsMail.registerRenderers();
        PixelmonItemsLures.registerRenderers();
    }

    @SubscribeEvent
    public static void registerPotions(RegistryEvent.Register<Potion> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)PixelmonPotions.repel.func_188413_j());
    }

    @SubscribeEvent
    public static void onRemapPotions(RegistryEvent.MissingMappings<Potion> event) {
        RemapHandler.remapPotions((List<RegistryEvent.MissingMappings.Mapping<Potion>>)event.getMappings());
    }

    private static <T extends IForgeRegistryEntry<T>> void registerAllFields(Class clazzWithFields, Class<T> type, IForgeRegistry<T> registry) {
        try {
            for (Field field : clazzWithFields.getFields()) {
                if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !type.isInstance(field.get(null))) continue;
                registry.register((IForgeRegistryEntry)field.get(null));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemRenderersByFields(Class clazzWithFields) {
        try {
            for (Field field : clazzWithFields.getFields()) {
                if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !(field.get(null) instanceof Item)) continue;
                Item item = (Item)field.get(null);
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

