/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.config.ConfigMigrationHandler;
import com.pixelmonmod.pixelmon.config.EnumForceBattleResult;
import com.pixelmonmod.pixelmon.config.EnumPokelootModes;
import com.pixelmonmod.pixelmon.config.EnumPokelootRate;
import com.pixelmonmod.pixelmon.config.Node;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.customStarters.CustomStarters;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleAIMode;
import com.pixelmonmod.pixelmon.worldGeneration.dimension.ultraspace.UltraSpace;
import info.pixelmon.repack.ninja.leaping.configurate.ConfigurationOptions;
import info.pixelmon.repack.ninja.leaping.configurate.commented.CommentedConfigurationNode;
import info.pixelmon.repack.ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import info.pixelmon.repack.ninja.leaping.configurate.objectmapping.ObjectMappingException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.text.translation.I18n;

public class PixelmonConfig {
    @Node(category="General", nameOverride="awardPhotos")
    public static boolean awardTokens = false;
    @Node(category="General", nameOverride="allowPokemonNicknames")
    public static boolean allowNicknames = true;
    @Node(category="General", nameOverride="allowAnvilAutoreloading")
    public static boolean allowAnvilAutoloading = false;
    @Node(category="General", nameOverride="allowVanillaMobs")
    public static boolean allowNonPixelmonMobs = false;
    @Node(category="General", nameOverride="allowCaptureOutsideBattle")
    public static boolean allowCapturingOutsideBattle = true;
    @Node(category="General")
    public static boolean allowRandomPokemonToBeLegendary = true;
    @Node(category="General", nameOverride="growthScaleModifier", minValue=0.0, maxValue=2.0)
    public static double growthModifier = 1.0;
    @Node(category="General")
    public static boolean pokemonDropsEnabled = true;
    @Node(category="General")
    public static boolean printErrors = true;
    @Node(category="General")
    public static boolean allowPlanting = true;
    @Node(category="General", minValue=0.0)
    public static int maximumPlants = 32;
    @Node(category="General", nameOverride="allowPvPExperience")
    public static boolean allowPVPExperience = true;
    @Node(category="General")
    public static boolean allowTrainerExperience = true;
    @Node(category="General")
    public static boolean returnHeldItems = true;
    @Node(category="General")
    public static EnumForceBattleResult forceEndBattleResult = EnumForceBattleResult.WINNER;
    @Node(category="General")
    public static boolean cloningMachineEnabled = true;
    @Node(category="General")
    public static int lakeTrioMaxEnchants = 3;
    @Node(category="General", nameOverride="engagePlayerByPokeBall")
    public static boolean pokeBallPlayerEngage = true;
    @Node(category="General", minValue=0.0, maxValue=256.0)
    public static int computerBoxes = 30;
    @Node(category="General", nameOverride="enableWildAggression")
    public static boolean isAggressionAllowed = true;
    @Node(category="General")
    public static boolean allowTMReuse = false;
    @Node(category="General")
    public static boolean writeEntitiesToWorld = false;
    @Node(category="General")
    public static boolean reusableBirdShrines = false;
    @Node(category="General", nameOverride="spawnersOpOnly")
    public static boolean opToUseSpawners = true;
    @Node(category="General", nameOverride="npcEditorOpOnly")
    public static boolean opToUseNpcEditor = true;
    @Node(category="General", nameOverride="tradersReusable")
    public static boolean reuseTraders = false;
    @Node(category="General")
    public static int movesPerTutor = 20;
    @Node(category="General", nameOverride="starterOnJoin")
    public static boolean giveStarter = true;
    @Node(category="General", nameOverride="useSystemTimeForWorldTime")
    public static boolean useSystemWorldTime = false;
    @Node(category="General", nameOverride="systemTimeSyncInterval", minValue=2.0)
    public static int timeUpdateInterval = 30;
    @Node(category="General")
    public static EnumBattleAIMode battleAIWild = EnumBattleAIMode.Random;
    @Node(category="General")
    public static EnumBattleAIMode battleAIBoss = EnumBattleAIMode.Aggressive;
    @Node(category="General")
    public static EnumBattleAIMode battleAITrainer = EnumBattleAIMode.Tactical;
    @Node(category="General", minValue=0.0)
    public static float expModifier = 1.0f;
    @Node(category="General", nameOverride="multiplePhotosOfSamePokemon")
    public static boolean allowMultiplePhotosOfSamePokemon = true;
    @Node(category="General")
    public static boolean allowPayDayMoney = true;
    @Node(category="General")
    public static int pickupRate = 10;
    @Node(category="General")
    public static boolean bedsHealPokemon = true;
    @Node(category="General")
    public static boolean allowPokemonEditors = true;
    @Node(category="General")
    public static boolean allowChisels = true;
    @Node(category="General")
    public static boolean dataSaveOnWorldSave = true;
    @Node(category="General")
    public static boolean useDropGUI = true;
    @Node(category="General", minValue=0.10000000149011612, maxValue=1000.0)
    public static float berryTreeGrowthMultiplier = 1.0f;
    @Node(category="General")
    public static boolean useSystemTimeForBerries = false;
    @Node(category="General", minValue=1.0)
    public static int maxLevel = 100;
    @Node(category="General", minValue=1.0)
    public static int despawnRadius = 80;
    @Node(category="General")
    public static boolean canPokemonBeHit = false;
    @Node(category="General")
    public static boolean alwaysHaveMegaRing = false;
    @Node(category="General")
    public static boolean deleteUnwantedDrops = false;
    @Node(category="General")
    public static int chanceToGetSpecialBidoof = 30;
    @Node(category="General")
    public static boolean disabledNonPlayerPixelmonMovement = false;
    @Node(category="General")
    public static boolean allowShinyCharmFromPokedex = true;
    @Node(category="General", type=String.class)
    public static List<String> oreColors = Lists.newArrayList((Object[])new String[]{"minecraft:iron_ore;E2C0AA;0", "minecraft:gold_ore;FCEE4B;0", "minecraft:redstone_ore;FF0000;0", "minecraft:emerald_ore;17DD62;1", "minecraft:diamond_ore;65F5E3;0", "minecraft:lapis_ore;1855BD;2", "minecraft:quartz_ore;EAE5DE;3", "pixelmon:amethyst_ore;9543A9;4", "pixelmon:sun_stone_ore;E57742;5", "pixelmon:silicon_ore;E2DFEE;0", "pixelmon:sapphire_ore;4A73E7;1", "pixelmon:ruby_ore;DD1C33;1", "pixelmon:fossil;443D32;6", "pixelmon:crystal_ore;AFEEEE;4", "pixelmon:bauxite_ore;D1B584;0", "pixelmon:dawn_dusk_ore;000000;7", "pixelmon:water_stone_ore;5D719F;8", "pixelmon:thunder_stone_ore;F0FF01;9", "pixelmon:leaf_stone_ore;7EA167;10", "pixelmon:fire_stone_ore;CC7132;11"});
    @Node(category="General")
    public static int averageLureExpiryTicks = 17920;
    @Node(category="Healing")
    public static boolean usePassiveHealer = true;
    @Node(category="Healing")
    public static float chanceToRevivePassively = 0.001f;
    @Node(category="Healing")
    public static float chanceToHealStatusPassively = 0.005f;
    @Node(category="Healing")
    public static int stepsToHealHealthPassively = 75;
    @Node(category="Healing")
    public static float passiveHealingMaxHealthPercentage = 0.25f;
    @Node(category="OutsideEffects")
    public static boolean useOutsideEffects = true;
    @Node(category="OutsideEffects")
    public static int stepsToApplyEffects = 15;
    @Node(category="OutsideEffects")
    public static int poisonMaxDamage = 5;
    @Node(category="Spawning", nameOverride="shinySpawnRate", minValue=0.0)
    public static float shinyRate = 4096.0f;
    @Node(category="Spawning")
    public static float bossRate = 256.0f;
    @Node(category="Spawning", minValue=0.0)
    public static int bossSpawnTicks = 10000;
    @Node(category="Spawning", minValue=0.0, maxValue=1.0)
    public static float bossSpawnChance = 0.3f;
    @Node(category="Spawning", minValue=0.0)
    public static int legendarySpawnTicks = 25000;
    @Node(category="Spawning", minValue=0.0, maxValue=1.0)
    public static float legendarySpawnChance = 0.3f;
    @Node(category="Spawning", minValue=0.0)
    public static float spawnTicksPlayerMultiplier = 0.01f;
    @Node(category="Spawning")
    public static boolean spawnLevelsByDistance = false;
    @Node(category="Spawning")
    public static int maxLevelByDistance = 60;
    @Node(category="Spawning", minValue=0.0)
    public static int distancePerLevel = 30;
    @Node(category="Spawning")
    public static boolean spawnLevelsCloserToPlayerLevels = true;
    @Node(category="Spawning")
    public static double transformToDittoOnCatch = 5.0E-5;
    @Node(category="Spawning")
    public static int meltanSpawnChance = 8192;
    @Node(category="Spawning")
    public static double meltanTransformChance = 0.6;
    @Node(category="Spawning", type=String.class)
    public static List<String> canTransformToDittoOnCatch = Lists.newArrayList((Object[])new String[]{"Pidgey", "Rattata", "Gastly", "Zubat", "Mankey", "Yanma", "Hoothoot", "Sentret", "Zigzagoon", "Gulpin", "Whismur", "Taillow", "Remoraid", "Starly"});
    @Node(category="Spawning", nameOverride="hiddenAbilitySpawnRate", minValue=0.0)
    public static int hiddenAbilityRate = 150;
    @Node(category="Spawning", nameOverride="allowLegendarySpawn")
    public static boolean allowLegendariesSpawn = true;
    @Node(category="Spawning", nameOverride="displayLegendaryGlobalMessage")
    public static boolean doLegendaryEvent = true;
    @Node(category="Spawning")
    public static boolean useRecentLevelMoves = false;
    @Node(category="Spawning")
    public static boolean despawnOnFleeOrLoss = false;
    @Node(category="Spawning")
    public static int entitiesPerPlayer = 45;
    @Node(category="Spawning")
    public static int spawnsPerPass = 2;
    @Node(category="Spawning")
    public static float spawnFrequency = 60.0f;
    @Node(category="Spawning")
    public static float minimumDistanceBetweenSpawns = 15.0f;
    @Node(category="Spawning")
    public static int minimumDistanceFromCentre = 18;
    @Node(category="Spawning")
    public static int maximumDistanceFromCentre = 64;
    @Node(category="Spawning")
    public static float horizontalTrackFactor = 80.0f;
    @Node(category="Spawning")
    public static float verticalTrackFactor = 0.0f;
    @Node(category="Spawning")
    public static int horizontalSliceRadius = 10;
    @Node(category="Spawning")
    public static int verticalSliceRadius = 25;
    @Node(category="Spawning")
    public static int maximumSpawnedPokemon = 3000;
    @Node(category="Spawning")
    public static double bellSuccessChance = 0.01;
    @Node(category="Spawning")
    public static int bellInclusionRange = 10;
    @Node(category="Spawning.Gens")
    public static boolean Gen1 = true;
    @Node(category="Spawning.Gens")
    public static boolean Gen2 = true;
    @Node(category="Spawning.Gens")
    public static boolean Gen3 = true;
    @Node(category="Spawning.Gens")
    public static boolean Gen4 = true;
    @Node(category="Spawning.Gens")
    public static boolean Gen5 = true;
    @Node(category="Spawning.Gens")
    public static boolean Gen6 = true;
    @Node(category="Spawning.Gens")
    public static boolean Gen7 = true;
    @Node(category="PokeLoot")
    public static boolean spawnNormal = true;
    @Node(category="PokeLoot")
    public static boolean spawnHidden = true;
    @Node(category="PokeLoot")
    public static boolean spawnGrotto = true;
    @Node(category="PokeLoot")
    public static EnumPokelootRate spawnRate = EnumPokelootRate.NORMAL;
    @Node(category="PokeLoot")
    public static EnumPokelootModes spawnMode = EnumPokelootModes.FCFS;
    @Node(category="PokeLoot", nameOverride="timedLootReuseHours")
    public static int lootTime = 24;
    @Node(category="AFKHandler", nameOverride="enableAFKHandler")
    public static boolean afkHandlerOn = false;
    @Node(category="AFKHandler", nameOverride="afkActivateSeconds", minValue=0.0)
    public static int afkTimerActivateSeconds = 90;
    @Node(category="AFKHandler", nameOverride="afkHandlerTurnSeconds", minValue=0.0)
    public static int afkTimerTurnSeconds = 15;
    @Node(category="Graphics", minValue=0.0)
    public static double renderDistanceWeight = 2.0;
    @Node(category="Graphics", nameOverride="namePlateRange", minValue=0.0)
    public static int nameplateRangeModifier = 1;
    @Node(category="Graphics", nameOverride="renderWildLevels")
    public static boolean renderWildLevels = true;
    @Node(category="Graphics")
    public static boolean showWildNames = true;
    @Node(category="Graphics", nameOverride="scalePokemonModels", minValue=0.0)
    public static boolean scaleModelsUp = true;
    @Node(category="Graphics", nameOverride="useSmoothShadingOnPokeBalls")
    public static boolean enableSmoothPokeballShading = true;
    @Node(category="Graphics", nameOverride="useSmoothShadingOnPokemon")
    public static boolean enableSmoothPokemonShading = true;
    @Node(category="Graphics", nameOverride="showCurrentAttackTarget")
    public static boolean showTarget = true;
    @Node(category="Graphics")
    public static boolean drawHealthBars = false;
    @Node(category="Graphics")
    public static boolean useBattleCamera = true;
    @Node(category="Graphics")
    public static boolean playerControlCamera = true;
    @Node(category="Graphics")
    public static boolean onlyShowAttackEffectsToBattlers = true;
    @Node(category="Graphics", minValue=0.0)
    public static int rangeToDisplayAttackAnimations = 40;
    @Node(category="Breeding")
    public static boolean allowBreeding = true;
    @Node(category="Breeding")
    public static int maxCumulativePokemonInRanch = 0;
    @Node(category="Breeding")
    public static boolean allowDittoDittoBreeding = true;
    @Node(category="Breeding")
    public static boolean allowRandomBreedingEggsToBeLegendary = false;
    @Node(category="Breeding")
    public static boolean useBreedingEnvironment = true;
    @Node(category="Breeding", minValue=0.0)
    public static int stepsPerEggCycle = 255;
    @Node(category="Breeding", nameOverride="numBreedingStages", minValue=0.0)
    public static int numBreedingLevels = 5;
    @Node(category="Breeding", minValue=20.0)
    public static int breedingTicks = 18000;
    @Node(category="Breeding")
    public static boolean allowRanchExpansion = true;
    @Node(category="PixelUtilities")
    public static boolean scaleGrassBattles = false;
    @Node(category="PixelUtilities", nameOverride="pokeGiftReusable")
    public static boolean pokegiftMany = false;
    @Node(category="PixelUtilities", nameOverride="pokeGiftHaveEvents")
    public static boolean doPokegiftEvents = true;
    @Node(category="PixelUtilities", nameOverride="eventPokeGiftLoad")
    public static boolean isPokegiftEvent = false;
    @Node(category="PixelUtilities", nameOverride="eventHasLegendaries")
    public static boolean pokegiftEventLegendaries = false;
    @Node(category="PixelUtilities", nameOverride="eventHasShinies")
    public static boolean pokegiftEventShinies = false;
    @Node(category="PixelUtilities", nameOverride="eventMaxPokemon", minValue=0.0)
    public static int pokegiftEventMaxPokes = 1;
    @Node(category="PixelUtilities", nameOverride="eventShinyRate", minValue=0.0)
    public static int pokegiftEventShinyRate = 10;
    @Node(category="PixelUtilities", nameOverride="eventTime")
    public static String customPokegiftEventTime = "D/M";
    @Node(category="PixelUtilities", nameOverride="eventCoords", type=String.class)
    public static List<String> pokegiftEventCoords = Collections.singletonList("notConfigured");
    @Node(category="ExternalMoves")
    public static boolean allowExternalMoves = true;
    @Node(category="ExternalMoves")
    public static boolean allowDestructiveExternalMoves = true;
    @Node(category="Riding")
    public static boolean allowRiding = true;
    @Node(category="Riding", minValue=0.0)
    public static float ridingSpeedMultiplier = 1.0f;
    @Node(category="Riding")
    public static boolean enablePointToSteer = true;
    @Node(category="Riding")
    public static boolean landMount = true;
    @Node(category="Riding")
    public static boolean requireHM = false;
    @Node(category="Pokerus", nameOverride="pkrsEnabled")
    public static boolean pokerusEnabled = true;
    @Node(category="Pokerus", nameOverride="pkrsSpawnRate", minValue=0.0)
    public static float pokerusRate = 12288.0f;
    @Node(category="Pokerus", nameOverride="pkrsInformPlayers")
    public static boolean pokerusInformPlayers = true;
    @Node(category="Pokerus", nameOverride="pkrsSpreadRate", minValue=-1.0)
    public static int pokerusSpreadRate = 5;
    @Node(category="General")
    public static boolean spawnStructures = true;
    @Node(category="General")
    public static boolean spawnBirdShrines = true;
    @Node(category="Spawning")
    public static boolean replaceMCVillagers = true;
    @Node(category="Spawning", nameOverride="spawnPokeMarts")
    public static boolean spawnPokemarts = true;
    @Node(category="Spawning")
    public static boolean spawnGyms = true;
    @Node(category="Spawning")
    public static boolean injectIntoLootTables = true;
    @Node(category="Spawning", type=String.class)
    public static List<String> lootIgnoreList = Lists.newArrayList();
    @Node(category="Spawning")
    public static boolean spawnUltraSpaceExtraShrines = true;
    @Node(category="Spawning")
    public static boolean spawnUltraSpaceNetherForts = true;
    @Node(category="Spawning")
    public static boolean spawnUltraSpaceEndCities = true;
    @Node(category="Spawning")
    public static boolean spawnUltraSpaceExtraOres = true;
    @Node(category="Spawning")
    public static boolean spawnUltraSpaceExtraPlants = true;
    @Node(category="Spawning")
    public static boolean spawnUltraSpaceExtraLoots = true;
    @Node(category="UltraSpace")
    public static boolean ultraSpace = true;
    @Node(category="UltraSpace")
    public static int ultraSpaceDimId = 0;
    @Node(category="UltraSpace", minValue=0.0)
    public static float ultraSpaceShinyModifier = 0.5f;
    @Node(category="UltraSpace", minValue=0.0)
    public static float ultraSpaceBossModifier = 0.5f;
    @Node(category="UltraSpace", minValue=0.0)
    public static float ultraSpaceHiddenAbilityModifier = 0.5f;
    @Node(category="UltraSpace")
    public static boolean ultraSpaceColourblindMode = false;
    @Node(category="General")
    public static boolean useExternalJSONFilesDrops = false;
    @Node(category="General")
    public static boolean useExternalJSONFilesMoves = false;
    @Node(category="General")
    public static boolean useExternalJSONFilesNPCs = false;
    @Node(category="General")
    public static boolean useExternalJSONFilesRules = false;
    @Node(category="General")
    public static boolean useExternalJSONFilesSpawning = false;
    @Node(category="General")
    public static boolean useExternalJSONFilesStats = false;
    @Node(category="General")
    public static boolean useExternalJSONFilesStructures = false;
    @Node(category="Spawning")
    public static String spawnSetFolder = "default";
    @Node(category="Spawning")
    public static boolean useBetterSpawnerConfig = false;
    @Node(category="Storage")
    public static boolean useAsyncSaving = false;
    @Node(category="Storage")
    public static int asyncInterval = 60;
    @Node(category="Elevator")
    public static int elevatorSearchRange = 10;
    public static boolean allowWildPokemonFleeing = false;
    private static HoconConfigurationLoader configurationLoader;
    private static CommentedConfigurationNode mainNode;

    public static void init(File configFile) {
        configurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(configFile)).build();
        try {
            PixelmonConfig.reload(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void reload(boolean loadFromDisk) throws IOException {
        if (loadFromDisk) {
            mainNode = (CommentedConfigurationNode)configurationLoader.load(ConfigurationOptions.defaults().setShouldCopyDefaults(true));
        }
        try {
            CustomStarters.loadConfig(mainNode);
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
        }
        String[] categories = Category.getList();
        for (String category : categories) {
            CommentedConfigurationNode categoryNode = mainNode;
            for (String cat : category.split("\\.")) {
                categoryNode = categoryNode.getNode(cat);
            }
            categoryNode.setComment(I18n.func_74838_a((String)("pixelmon.config." + category.toLowerCase() + ".comment")));
        }
        for (Field field : PixelmonConfig.class.getDeclaredFields()) {
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || field.getAnnotation(Node.class) == null) continue;
            Node node = field.getAnnotation(Node.class);
            String category = node.category();
            String name = node.nameOverride().isEmpty() ? field.getName() : node.nameOverride();
            String comment = "pixelmon.config." + name + ".comment";
            CommentedConfigurationNode categoryNode = mainNode;
            for (String cat : category.split("\\.")) {
                categoryNode = categoryNode.getNode(cat);
            }
            CommentedConfigurationNode configNode = categoryNode.getNode(name);
            configNode.setComment(I18n.func_74838_a((String)comment));
            PixelmonConfig.set(field, configNode, node);
        }
        configurationLoader.save(mainNode);
        PixelmonServerConfig.load();
        Pixelmon.LOGGER.info("Checking for migrations..");
        if (PixelmonConfig.checkMigrations(PixelmonConfig.getConfig())) {
            PixelmonConfig.saveConfig();
        }
    }

    private static void set(Field field, CommentedConfigurationNode configNode, Node node) {
        try {
            Class<?> type = field.getType();
            if (type == Boolean.TYPE) {
                boolean value = configNode.getBoolean(field.getBoolean(null));
                field.setBoolean(null, value);
            } else if (type == Integer.TYPE) {
                int value = configNode.getInt(field.getInt(null));
                value = (double)value < node.minValue() ? (int)node.minValue() : ((double)value > node.maxValue() ? (int)node.maxValue() : value);
                field.setInt(null, value);
            } else if (type == Float.TYPE) {
                float value = configNode.getFloat(field.getFloat(null));
                value = (double)value < node.minValue() ? (float)node.minValue() : ((double)value > node.maxValue() ? (float)node.maxValue() : value);
                field.setFloat(null, value);
            } else if (type == Double.TYPE) {
                double value = configNode.getDouble(field.getDouble(null));
                value = value < node.minValue() ? node.minValue() : (value > node.maxValue() ? node.maxValue() : value);
                field.setDouble(null, value);
            } else if (type == String.class) {
                String value = configNode.getString((String)field.get(null));
                field.set(null, value);
            } else if (type == List.class) {
                List value = configNode.getList(TypeToken.of(node.type()), (List)field.get(null));
                field.set(null, value);
            } else if (Enum.class.isAssignableFrom(type)) {
                field.set(null, type.getEnumConstants()[configNode.getInt(((Enum)field.get(null)).ordinal())]);
            } else {
                Pixelmon.LOGGER.error("Cannot read config value " + configNode.getKey());
            }
        }
        catch (ObjectMappingException | IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void saveConfig() {
        try {
            configurationLoader.save(mainNode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static CommentedConfigurationNode getConfig() {
        return mainNode;
    }

    public static void disableEventLoading() {
        isPokegiftEvent = mainNode.getNode("PixelUtilities").getNode("eventPokeGiftLoad").setValue(false).getBoolean();
        PixelmonConfig.saveConfig();
    }

    public static float getShinyRate(int dimension) {
        if (dimension == UltraSpace.DIM_ID) {
            return shinyRate * ultraSpaceShinyModifier;
        }
        return shinyRate;
    }

    public static float getBossRate(int dimension) {
        if (dimension == UltraSpace.DIM_ID) {
            return bossRate * ultraSpaceBossModifier;
        }
        return bossRate;
    }

    public static float getHiddenAbilityRate(int dimension) {
        if (dimension == UltraSpace.DIM_ID) {
            return (float)hiddenAbilityRate * ultraSpaceHiddenAbilityModifier;
        }
        return hiddenAbilityRate;
    }

    public static float getLegendaryRate() {
        return legendarySpawnChance;
    }

    public static double getGrowthModifier() {
        return growthModifier;
    }

    public static boolean isGenerationEnabled(int generation) {
        switch (generation) {
            case 1: {
                return Gen1;
            }
            case 2: {
                return Gen2;
            }
            case 3: {
                return Gen3;
            }
            case 4: {
                return Gen4;
            }
            case 5: {
                return Gen5;
            }
            case 6: {
                return Gen6;
            }
            case 7: {
                return Gen7;
            }
        }
        return false;
    }

    public static boolean allGenerationsDisabled() {
        return !Gen1 && !Gen2 && !Gen3 && !Gen4 && !Gen5 && !Gen6 && !Gen7;
    }

    public static boolean allGenerationsEnabled() {
        return Gen1 && Gen2 && Gen3 && Gen4 && Gen5 && Gen6 && Gen7;
    }

    public static boolean checkMigrations(CommentedConfigurationNode configNode) {
        boolean shouldSave = false;
        if (configNode.hasMapChildren()) {
            for (CommentedConfigurationNode commentedConfigurationNode : configNode.getChildrenMap().values()) {
                shouldSave = shouldSave || PixelmonConfig.checkMigrations(commentedConfigurationNode);
            }
        }
        shouldSave = shouldSave || ConfigMigrationHandler.handleMigration(configNode);
        return shouldSave;
    }

    private static class Category {
        static final String GENERAL = "General";
        static final String SPAWNING = "Spawning";
        static final String SPAWNINGGENS = "Spawning.Gens";
        static final String POKELOOT = "PokeLoot";
        static final String AFKHANDLER = "AFKHandler";
        static final String GRAPHICS = "Graphics";
        static final String BREEDING = "Breeding";
        static final String PIXELUTILITIES = "PixelUtilities";
        static final String EXTERNALMOVES = "ExternalMoves";
        static final String POKERUS = "Pokerus";
        static final String ULTRASPACE = "UltraSpace";
        static final String STORAGE = "Storage";
        static final String ELEVATOR = "Elevator";
        static final String HEALING = "Healing";
        static final String RIDING = "Riding";
        static final String OUTSIDEEFFECTS = "OutsideEffects";

        private Category() {
        }

        static String[] getList() {
            ArrayList<String> values = new ArrayList<String>();
            Category category = new Category();
            Class<Category> clazz = Category.class;
            try {
                for (Field field : clazz.getDeclaredFields()) {
                    Object obj = field.get(category);
                    if (obj == null || !(obj instanceof String)) continue;
                    values.add((String)obj);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return values.toArray(new String[values.size()]);
        }
    }
}

