/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import info.pixelmon.repack.ninja.leaping.configurate.commented.CommentedConfigurationNode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;

public class ConfigMigrationHandler {
    public static HashMap<Object, Consumer<CommentedConfigurationNode>> consumers = new HashMap();

    public static boolean handleMigration(CommentedConfigurationNode configNode) {
        String key = Arrays.stream(configNode.getPath()).filter(o -> o instanceof String).collect(StringBuilder::new, (sb, k) -> {
            if (sb.length() == 0) {
                sb.append(k);
            } else {
                sb.append(".").append(k);
            }
        }, StringBuilder::append).toString();
        if (consumers.containsKey(key)) {
            Pixelmon.LOGGER.info("MigrationHandler: Migrating " + configNode.getKey());
            consumers.get(key).accept(configNode);
            Pixelmon.LOGGER.info("MigrationHandler: Migrated " + configNode.getKey());
            return true;
        }
        return false;
    }

    static {
        consumers.put("General.useExternalJSONFiles", cnf -> {
            boolean value = cnf.getBoolean();
            Pixelmon.LOGGER.info("MigrationHandler: Applying old value " + value + " of " + cnf.getKey() + " to new nodes.");
            CommentedConfigurationNode mainNode = PixelmonConfig.getConfig();
            mainNode.getNode("General").getNode("useExternalJSONFilesDrops").setValue(value);
            mainNode.getNode("General").getNode("useExternalJSONFilesNPCs").setValue(value);
            mainNode.getNode("General").getNode("useExternalJSONFilesRules").setValue(value);
            mainNode.getNode("General").getNode("useExternalJSONFilesSpawning").setValue(value);
            mainNode.getNode("General").getNode("useExternalJSONFilesStructures").setValue(value);
            PixelmonConfig.useExternalJSONFilesDrops = value;
            PixelmonConfig.useExternalJSONFilesNPCs = value;
            PixelmonConfig.useExternalJSONFilesRules = value;
            PixelmonConfig.useExternalJSONFilesSpawning = value;
            PixelmonConfig.useExternalJSONFilesStructures = value;
            cnf.getParent().removeChild(cnf.getKey());
        });
        consumers.put("General.allowRiding", cnf -> {
            boolean value = cnf.getBoolean();
            PixelmonConfig.getConfig().getNode("Riding").getNode("allowRiding").setValue(value);
            PixelmonConfig.allowRiding = value;
            cnf.getParent().removeChild(cnf.getKey());
        });
        consumers.put("General.needHMToRide", cnf -> {
            boolean value = cnf.getBoolean();
            PixelmonConfig.getConfig().getNode("Riding").getNode("requireHM").setValue(value);
            PixelmonConfig.requireHM = value;
            cnf.getParent().removeChild(cnf.getKey());
        });
        consumers.put("General.ridingSpeedMultiplier", cnf -> {
            float value = cnf.getFloat();
            PixelmonConfig.getConfig().getNode("Riding").getNode("ridingSpeedMultiplier").setValue(Float.valueOf(value));
            PixelmonConfig.ridingSpeedMultiplier = value;
            cnf.getParent().removeChild(cnf.getKey());
        });
        consumers.put("General.enablePointToSteer", cnf -> {
            boolean value = cnf.getBoolean();
            PixelmonConfig.getConfig().getNode("Riding").getNode("enablePointToSteer").setValue(value);
            PixelmonConfig.enablePointToSteer = value;
            cnf.getParent().removeChild(cnf.getKey());
        });
    }
}

