/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.spawning.CompositeSpawnCondition;
import com.pixelmonmod.pixelmon.api.spawning.conditions.RarityMultiplier;
import com.pixelmonmod.pixelmon.api.spawning.conditions.SpawnCondition;
import com.pixelmonmod.pixelmon.api.spawning.util.SpawnConditionTypeAdapter;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public class BetterSpawnerConfig {
    public static BetterSpawnerConfig INSTANCE = null;
    public static final String PATH = "config/pixelmon/BetterSpawnerConfig.json";
    public static final HashMap<String, Long> intervalTimes = new HashMap();
    public CompositeSpawnCondition globalCompositeCondition = new CompositeSpawnCondition();
    public ArrayList<RarityMultiplier> globalRarityMultipliers = new ArrayList();
    public HashMap<String, PokemonSpec> autoTagSpecs = new HashMap();
    public HashMap<String, Integer> intervalSeconds = new HashMap();
    private HashMap<String, ArrayList<String>> blockCategories = new HashMap();
    private HashMap<String, ArrayList<String>> biomeCategories = new HashMap();
    public transient ArrayList<Block> landBlockCategory = new ArrayList();
    public transient ArrayList<Block> waterBlockCategory = new ArrayList();
    public transient ArrayList<Block> airBlockCategory = new ArrayList();
    public transient ArrayList<Block> lavaBlockCategory = new ArrayList();
    public transient ArrayList<Block> seesSkyBlockCategory = new ArrayList();
    public transient ArrayList<Block> treeTopBlockCategory = new ArrayList();
    public transient HashMap<String, ArrayList<Block>> cachedBlockCategories = new HashMap();
    public transient HashMap<String, ArrayList<Biome>> cachedBiomeCategories = new HashMap();

    public static void load() {
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(SpawnCondition.class, (Object)new SpawnConditionTypeAdapter()).registerTypeAdapter(PokemonSpec.class, (Object)PokemonSpec.SPEC_ADAPTER).create();
            if (!PixelmonConfig.useBetterSpawnerConfig) {
                InputStream stream = ServerNPCRegistry.class.getResourceAsStream("/assets/pixelmon/spawning/BetterSpawnerConfig.json");
                INSTANCE = (BetterSpawnerConfig)gson.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), BetterSpawnerConfig.class);
            } else {
                File file = new File(PATH);
                file.getParentFile().mkdirs();
                INSTANCE = null;
                try {
                    if (file.exists()) {
                        INSTANCE = (BetterSpawnerConfig)gson.fromJson((Reader)new FileReader(PATH), BetterSpawnerConfig.class);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (INSTANCE == null) {
                    InputStream stream = ServerNPCRegistry.class.getResourceAsStream("/assets/pixelmon/spawning/BetterSpawnerConfig.json");
                    INSTANCE = (BetterSpawnerConfig)gson.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), BetterSpawnerConfig.class);
                    if (!file.exists()) {
                        PrintWriter pw = new PrintWriter(file);
                        pw.write(gson.toJson((Object)INSTANCE));
                        pw.flush();
                        pw.close();
                    } else {
                        Pixelmon.LOGGER.error("Could not parse the BetterSpawnerConfig.json. Check it in a JSON parser. Using default options.");
                    }
                }
            }
            BetterSpawnerConfig.INSTANCE.cachedBlockCategories = BetterSpawnerConfig.convert(BetterSpawnerConfig.INSTANCE.blockCategories, Block.class);
            BetterSpawnerConfig.INSTANCE.cachedBiomeCategories = BetterSpawnerConfig.convert(BetterSpawnerConfig.INSTANCE.biomeCategories, Biome.class);
            BetterSpawnerConfig.INSTANCE.landBlockCategory = BetterSpawnerConfig.INSTANCE.cachedBlockCategories.get("land");
            BetterSpawnerConfig.INSTANCE.waterBlockCategory = BetterSpawnerConfig.INSTANCE.cachedBlockCategories.get("water");
            BetterSpawnerConfig.INSTANCE.airBlockCategory = BetterSpawnerConfig.INSTANCE.cachedBlockCategories.get("air");
            BetterSpawnerConfig.INSTANCE.lavaBlockCategory = BetterSpawnerConfig.INSTANCE.cachedBlockCategories.get("lava");
            BetterSpawnerConfig.INSTANCE.seesSkyBlockCategory = BetterSpawnerConfig.INSTANCE.cachedBlockCategories.get("seesSkyException");
            BetterSpawnerConfig.INSTANCE.treeTopBlockCategory = BetterSpawnerConfig.INSTANCE.cachedBlockCategories.get("treeTop");
            if (BetterSpawnerConfig.INSTANCE.globalCompositeCondition != null) {
                BetterSpawnerConfig.INSTANCE.globalCompositeCondition.onImport();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static <T extends IForgeRegistryEntry<T>> HashMap<String, ArrayList<T>> convert(HashMap<String, ArrayList<String>> values, Class<T> clazz) {
        HashMap<String, ArrayList<T>> converted = new HashMap<String, ArrayList<T>>();
        IForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(clazz);
        for (Map.Entry<String, ArrayList<String>> entry : values.entrySet()) {
            ArrayList ts = new ArrayList();
            if (entry.getValue() != null) {
                block1: for (String string : entry.getValue()) {
                    for (Map.Entry entry2 : registry.getEntries()) {
                        if (!((ResourceLocation)entry2.getKey()).toString().equalsIgnoreCase(string) && !((ResourceLocation)entry2.getKey()).func_110623_a().equalsIgnoreCase(string)) continue;
                        ts.add(entry2.getValue());
                        continue block1;
                    }
                }
            }
            converted.put(entry.getKey(), ts);
        }
        return converted;
    }

    public static boolean checkInterval(String interval) {
        if (interval == null) {
            return true;
        }
        if (!BetterSpawnerConfig.INSTANCE.intervalSeconds.containsKey(interval)) {
            return true;
        }
        if (BetterSpawnerConfig.INSTANCE.intervalSeconds.get(interval) == -1) {
            return false;
        }
        Long last = intervalTimes.get(interval);
        if (last == null || !BetterSpawnerConfig.INSTANCE.intervalSeconds.containsKey(interval)) {
            return true;
        }
        return last < System.currentTimeMillis();
    }

    public static void consumeInterval(String interval) {
        if (BetterSpawnerConfig.INSTANCE.intervalSeconds.containsKey(interval)) {
            intervalTimes.put(interval, System.currentTimeMillis() + (long)(BetterSpawnerConfig.INSTANCE.intervalSeconds.get(interval) * 1000));
        }
    }

    public static ArrayList<Block> getLandBlocks() {
        return BetterSpawnerConfig.INSTANCE.landBlockCategory;
    }

    public static ArrayList<Block> getWaterBlocks() {
        return BetterSpawnerConfig.INSTANCE.waterBlockCategory;
    }

    public static ArrayList<Block> getLavaBlocks() {
        return BetterSpawnerConfig.INSTANCE.lavaBlockCategory;
    }

    public static ArrayList<Block> getAirBlocks() {
        return BetterSpawnerConfig.INSTANCE.airBlockCategory;
    }

    public static ArrayList<Block> getSeesSkyExceptionBlocks() {
        return BetterSpawnerConfig.INSTANCE.seesSkyBlockCategory;
    }

    public static ArrayList<Block> getTreeTopBlocks() {
        return BetterSpawnerConfig.INSTANCE.treeTopBlockCategory;
    }

    public static ArrayList<Block> getBlockCategory(String blockCategory) {
        if (BetterSpawnerConfig.INSTANCE.cachedBlockCategories.containsKey(blockCategory)) {
            return BetterSpawnerConfig.INSTANCE.cachedBlockCategories.get(blockCategory);
        }
        return new ArrayList<Block>();
    }

    public static boolean doesBlockSeeSky(IBlockState state) {
        if (state == null) {
            return false;
        }
        return !state.func_185904_a().func_76230_c() || BetterSpawnerConfig.getAirBlocks().contains(state.func_177230_c()) || BetterSpawnerConfig.getSeesSkyExceptionBlocks().contains(state.func_177230_c());
    }
}

