/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.comm.ISyncHandler;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.battles.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.rules.clauses.BattleClauseRegistry;
import com.pixelmonmod.pixelmon.comm.SetTrainerData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ClearTrainerPokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreen;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.UpdateClientRules;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.EnumNPCServerPacketType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCEditData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.StoreTrainerPokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.ChangePokemonOpenGUI;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.entities.npcs.NPCNurseJoy;
import com.pixelmonmod.pixelmon.entities.npcs.NPCRelearner;
import com.pixelmonmod.pixelmon.entities.npcs.NPCShopkeeper;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrader;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ClientNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.GeneralNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.NPCRegistryTrainers;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopkeeperData;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumEncounterMode;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleAIMode;
import com.pixelmonmod.pixelmon.items.ItemNPCEditor;
import com.pixelmonmod.pixelmon.storage.TrainerPartyStorage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class NPCServerPacket
implements IMessage {
    EnumNPCServerPacketType mode;
    int npcID;
    EnumTrainerAI ai;
    EnumBattleAIMode battleAI;
    EnumBossMode bm;
    EnumEncounterMode em;
    BattleRules battleRules;
    int modelIndex;
    String data;
    EnumSpecies pokemon;
    int pos;
    private int integer;
    EnumNPCType npcType;
    float floatData;
    BlockPos blockPos;
    ArrayList<String> pages;
    PokemonSpec exchange;
    PokemonSpec offer;
    String description;
    ClientNPCData npcData;
    String shopkeeperType;

    public NPCServerPacket() {
    }

    public NPCServerPacket(int npcID) {
        this.npcID = npcID;
    }

    public NPCServerPacket(EnumNPCType npcType, BlockPos pos, float rotationDirection) {
        this.mode = EnumNPCServerPacketType.ChooseNPC;
        this.npcType = npcType;
        this.floatData = rotationDirection;
        this.blockPos = pos;
    }

    public NPCServerPacket(int npcID, EnumTrainerAI ai) {
        this(npcID);
        this.mode = EnumNPCServerPacketType.AI;
        this.ai = ai;
    }

    public NPCServerPacket(int npcID, EnumBattleAIMode battleAI) {
        this(npcID);
        this.mode = EnumNPCServerPacketType.BattleAI;
        this.battleAI = battleAI;
    }

    public NPCServerPacket(int npcID, EnumBossMode bm) {
        this(npcID);
        this.mode = EnumNPCServerPacketType.BossMode;
        this.bm = bm;
    }

    public NPCServerPacket(int npcID, EnumEncounterMode bm) {
        this(npcID);
        this.mode = EnumNPCServerPacketType.EncounterMode;
        this.em = bm;
    }

    public NPCServerPacket(int npcID, BattleRules battleRules) {
        this(npcID);
        this.mode = EnumNPCServerPacketType.BattleRules;
        this.battleRules = battleRules;
    }

    public NPCServerPacket(int npcID, int modelIndex) {
        this(npcID);
        this.mode = EnumNPCServerPacketType.Model;
        this.modelIndex = modelIndex;
    }

    public NPCServerPacket(int npcID, EnumNPCServerPacketType mode, String data) {
        this(npcID);
        this.mode = mode;
        this.data = data;
    }

    public NPCServerPacket(int npcID, EnumSpecies pokemon, int pos) {
        this(npcID);
        this.mode = EnumNPCServerPacketType.Pokemon;
        this.pokemon = pokemon;
        this.pos = pos;
    }

    public NPCServerPacket(int npcID, EnumNPCServerPacketType mode, int textureIndex) {
        this(npcID);
        this.mode = mode;
        this.integer = textureIndex;
    }

    public NPCServerPacket(int npcID, EnumNPCServerPacketType mode) {
        this(npcID);
        this.mode = mode;
    }

    public NPCServerPacket(int npcID, ClientNPCData npcData) {
        this(npcID);
        this.mode = EnumNPCServerPacketType.CycleTexture;
        this.npcData = npcData;
    }

    public NPCServerPacket(int npcID, ArrayList<String> pages) {
        this(npcID);
        this.mode = EnumNPCServerPacketType.ChatPages;
        this.pages = pages;
    }

    public NPCServerPacket(int npcID, PokemonSpec offer, PokemonSpec exchange, String description) {
        this(npcID);
        this.mode = EnumNPCServerPacketType.Trader;
        this.offer = offer;
        this.exchange = exchange;
        this.description = description;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeShort(this.mode.ordinal());
        buffer.writeInt(this.npcID);
        switch (this.mode) {
            case AI: {
                buffer.writeInt(this.ai.ordinal());
                break;
            }
            case BattleAI: {
                buffer.writeInt(this.battleAI.ordinal());
                break;
            }
            case BossMode: {
                buffer.writeInt(this.bm.ordinal());
                break;
            }
            case EncounterMode: {
                buffer.writeInt(this.em.ordinal());
                break;
            }
            case BattleRules: {
                this.battleRules.encodeInto(buffer);
                break;
            }
            case Model: {
                buffer.writeInt(this.modelIndex);
                break;
            }
            case CustomSteveTexture: 
            case Name: 
            case CycleJson: {
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.data);
                break;
            }
            case Pokemon: {
                buffer.writeInt(this.pokemon.ordinal());
                buffer.writeInt(this.pos);
                break;
            }
            case TextureIndex: 
            case CycleName: {
                buffer.writeInt(this.integer);
                break;
            }
            case ChooseNPC: {
                buffer.writeShort(this.npcType.ordinal());
                buffer.writeInt(this.blockPos.func_177958_n());
                buffer.writeInt(this.blockPos.func_177956_o());
                buffer.writeInt(this.blockPos.func_177952_p());
                buffer.writeFloat(this.floatData);
                break;
            }
            case ChatPages: {
                buffer.writeInt(this.pages.size());
                for (String page : this.pages) {
                    ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)page);
                }
                break;
            }
            case Trader: {
                ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.offer.writeToNBT(new NBTTagCompound()));
                ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.exchange.writeToNBT(new NBTTagCompound()));
                if (this.description == null) {
                    this.description = "null";
                }
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.description);
                break;
            }
            case CycleTexture: {
                if (this.npcData == null) {
                    this.npcData = new ClientNPCData("");
                }
                this.npcData.encodeInto(buffer);
                break;
            }
        }
    }

    public void fromBytes(ByteBuf buffer) {
        this.mode = EnumNPCServerPacketType.values()[buffer.readShort()];
        this.npcID = buffer.readInt();
        switch (this.mode) {
            case AI: {
                this.ai = EnumTrainerAI.getFromOrdinal(buffer.readInt());
                break;
            }
            case BattleAI: {
                this.battleAI = EnumBattleAIMode.getFromIndex(buffer.readInt());
                break;
            }
            case BossMode: {
                this.bm = EnumBossMode.getMode(buffer.readInt());
                break;
            }
            case EncounterMode: {
                this.em = EnumEncounterMode.getFromIndex(buffer.readInt());
                break;
            }
            case BattleRules: {
                this.battleRules = new BattleRules(buffer);
                break;
            }
            case Model: {
                this.modelIndex = buffer.readInt();
                break;
            }
            case CustomSteveTexture: 
            case Name: 
            case CycleJson: {
                this.data = ByteBufUtils.readUTF8String((ByteBuf)buffer);
                break;
            }
            case Pokemon: {
                this.pokemon = EnumSpecies.getFromOrdinal(buffer.readInt());
                this.pos = buffer.readInt();
                break;
            }
            case TextureIndex: 
            case CycleName: {
                this.integer = buffer.readInt();
                break;
            }
            case ChooseNPC: {
                this.npcType = EnumNPCType.getFromOrdinal(buffer.readShort());
                this.blockPos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
                this.floatData = buffer.readFloat();
                break;
            }
            case ChatPages: {
                int numPages = buffer.readInt();
                this.pages = new ArrayList();
                for (int i = 0; i < numPages; ++i) {
                    this.pages.add(ByteBufUtils.readUTF8String((ByteBuf)buffer));
                }
                break;
            }
            case Trader: {
                this.offer = new PokemonSpec(new String[0]).readFromNBT(ByteBufUtils.readTag((ByteBuf)buffer));
                this.exchange = new PokemonSpec(new String[0]).readFromNBT(ByteBufUtils.readTag((ByteBuf)buffer));
                this.description = ByteBufUtils.readUTF8String((ByteBuf)buffer);
                if (!this.description.equals("null")) break;
                this.description = null;
                break;
            }
            case CycleTexture: {
                this.npcData = new ClientNPCData(buffer);
                break;
            }
        }
    }

    public static class Handler
    implements ISyncHandler<NPCServerPacket> {
        @Override
        public void onSyncMessage(NPCServerPacket message, MessageContext ctx) {
            EntityPlayerMP p = ctx.getServerHandler().field_147369_b;
            if (!ItemNPCEditor.checkPermission(p)) {
                return;
            }
            NPCTrader trader = null;
            switch (message.mode) {
                case ChooseNPC: {
                    this.spawnNPC(p, message.npcType, message.blockPos, message.floatData);
                    return;
                }
            }
            Optional<EntityNPC> npcOptional = EntityNPC.locateNPCServer(p.field_70170_p, message.npcID, EntityNPC.class);
            if (!npcOptional.isPresent()) {
                return;
            }
            EntityNPC npc = npcOptional.get();
            NPCTrainer trainer = null;
            if (npc instanceof NPCTrainer) {
                trainer = (NPCTrainer)npc;
            } else if (npc instanceof NPCTrader) {
                trader = (NPCTrader)npc;
            }
            switch (message.mode) {
                case AI: {
                    trainer.setAIMode(message.ai);
                    trainer.initAI();
                    break;
                }
                case BattleAI: {
                    trainer.setBattleAIMode(message.battleAI);
                    break;
                }
                case BossMode: {
                    trainer.setBossMode(message.bm);
                    break;
                }
                case EncounterMode: {
                    trainer.setEncounterMode(message.em);
                    break;
                }
                case BattleRules: {
                    message.battleRules.validateRules();
                    trainer.battleRules = message.battleRules;
                    break;
                }
                case Model: {
                    if (npc instanceof NPCTrainer) {
                        ((NPCTrainer)npc).setTrainerType(ServerNPCRegistry.trainers.getById(message.modelIndex), (EntityPlayer)p);
                        break;
                    }
                    npc.setBaseTrainer(ServerNPCRegistry.trainers.getById(message.modelIndex));
                    break;
                }
                case Name: {
                    if (message.data != null) {
                        npc.setName(message.data);
                    }
                    if (trainer == null) break;
                    trainer.initAI();
                    break;
                }
                case Pokemon: {
                    Object pokemon = Pixelmon.pokemonFactory.create(EnumSpecies.getFromNameAnyCase(message.pokemon.name));
                    TrainerPartyStorage storage = trainer.getPokemonStorage();
                    storage.set(message.pos, null);
                    storage.add((Pokemon)pokemon);
                    trainer.updateLvl();
                    List<Pokemon> storageList = storage.getTeam();
                    Pixelmon.network.sendTo((IMessage)new ClearTrainerPokemon(), p);
                    for (int i = 0; i < storageList.size(); ++i) {
                        Pixelmon.network.sendTo((IMessage)new StoreTrainerPokemon(storageList.get(i)), p);
                    }
                    Pixelmon.network.sendTo((IMessage)new ChangePokemonOpenGUI(message.pos), ctx.getServerHandler().field_147369_b);
                    break;
                }
                case TextureIndex: {
                    npc.setTextureIndex(message.integer);
                    break;
                }
                case CustomSteveTexture: {
                    npc.setCustomSteveTexture(message.data);
                    break;
                }
                case ChatPages: {
                    if (!(npc instanceof NPCChatting)) break;
                    ((NPCChatting)npc).setChat(message.pages);
                    break;
                }
                case Trader: {
                    if (trader == null) break;
                    trader.updateTrade(message.offer, message.exchange, message.description);
                    break;
                }
                case CycleTexture: {
                    if (!(npc instanceof NPCChatting)) break;
                    ((NPCChatting)npc).cycleTexture(p, message.npcData);
                    break;
                }
                case CycleJson: {
                    if (!(npc instanceof NPCShopkeeper)) break;
                    ((NPCShopkeeper)npc).cycleJson(p, message.data);
                    break;
                }
                case CycleName: {
                    if (!(npc instanceof NPCShopkeeper)) break;
                    ((NPCShopkeeper)npc).cycleName(p, message.integer);
                    break;
                }
                case RefreshItems: {
                    if (!(npc instanceof NPCShopkeeper)) break;
                    ((NPCShopkeeper)npc).loadItems();
                    break;
                }
            }
        }

        private void spawnNPC(EntityPlayerMP player, EnumNPCType npcType, BlockPos blockPos, float rotationYaw) {
            switch (npcType) {
                case Trainer: {
                    NPCTrainer trainer = new NPCTrainer(player.field_70170_p);
                    trainer.init(NPCRegistryTrainers.Steve);
                    trainer.func_70107_b((float)blockPos.func_177958_n() + 0.5f, blockPos.func_177956_o() + 1, (float)blockPos.func_177952_p() + 0.5f);
                    trainer.setAIMode(EnumTrainerAI.StandStill);
                    trainer.ignoreDespawnCounter = true;
                    trainer.initAI();
                    player.field_70170_p.func_72838_d((Entity)trainer);
                    trainer.func_70107_b((float)blockPos.func_177958_n() + 0.5f, blockPos.func_177956_o() + 1, (float)blockPos.func_177952_p() + 0.5f);
                    trainer.setStartRotationYaw(rotationYaw + 180.0f);
                    trainer.ignoreDespawnCounter = true;
                    Pixelmon.network.sendTo((IMessage)new ClearTrainerPokemon(), player);
                    for (int i = 0; i < trainer.getPokemonStorage().countAll(); ++i) {
                        Pixelmon.network.sendTo((IMessage)new StoreTrainerPokemon(trainer.getPokemonStorage().get(i)), player);
                    }
                    SetTrainerData trainerData = new SetTrainerData(trainer, player.field_71148_cg);
                    Pixelmon.network.sendTo((IMessage)new SetNPCEditData(trainerData), player);
                    if (BattleClauseRegistry.getClauseVersion() > 0) {
                        Pixelmon.network.sendTo((IMessage)new UpdateClientRules(), player);
                    }
                    OpenScreen.open((EntityPlayer)player, EnumGuiScreen.TrainerEditor, trainer.getId());
                    break;
                }
                case Trader: {
                    NPCTrader trader = new NPCTrader(player.field_70170_p);
                    trader.func_70107_b((float)blockPos.func_177958_n() + 0.5f, blockPos.func_177956_o() + 1, (float)blockPos.func_177952_p() + 0.5f);
                    player.field_70170_p.func_72838_d((Entity)trader);
                    trader.ignoreDespawnCounter = true;
                    break;
                }
                case ChattingNPC: {
                    NPCChatting npc = new NPCChatting(player.field_70170_p);
                    GeneralNPCData data = ServerNPCRegistry.villagers.getRandom();
                    npc.init(data);
                    npc.initDefaultAI();
                    npc.setCustomSteveTexture(data.getRandomTexture());
                    npc.func_70107_b((float)blockPos.func_177958_n() + 0.5f, blockPos.func_177956_o() + 1, (float)blockPos.func_177952_p() + 0.5f);
                    npc.ignoreDespawnCounter = true;
                    player.field_70170_p.func_72838_d((Entity)npc);
                    break;
                }
                case Relearner: {
                    NPCRelearner relearner = new NPCRelearner(player.field_70170_p);
                    relearner.func_70107_b((float)blockPos.func_177958_n() + 0.5f, blockPos.func_177956_o() + 1, (float)blockPos.func_177952_p() + 0.5f);
                    relearner.setAIMode(EnumTrainerAI.StandStill);
                    relearner.initAI();
                    relearner.ignoreDespawnCounter = true;
                    player.field_70170_p.func_72838_d((Entity)relearner);
                    break;
                }
                case Tutor: {
                    NPCTutor tutor = new NPCTutor(player.field_70170_p);
                    tutor.init("Tutor");
                    tutor.func_70107_b((float)blockPos.func_177958_n() + 0.5f, blockPos.func_177956_o() + 1, (float)blockPos.func_177952_p() + 0.5f);
                    tutor.setAIMode(EnumTrainerAI.StandStill);
                    tutor.initAI();
                    tutor.ignoreDespawnCounter = true;
                    player.field_70170_p.func_72838_d((Entity)tutor);
                    break;
                }
                case Shopkeeper: {
                    ShopkeeperData shopData = ServerNPCRegistry.shopkeepers.getRandom();
                    if (shopData == null) {
                        return;
                    }
                    NPCShopkeeper shopkeeper = new NPCShopkeeper(player.field_70170_p);
                    shopkeeper.init(shopData);
                    shopkeeper.initDefaultAI();
                    shopkeeper.func_70107_b((float)blockPos.func_177958_n() + 0.5f, blockPos.func_177956_o() + 1, (float)blockPos.func_177952_p() + 0.5f);
                    shopkeeper.ignoreDespawnCounter = true;
                    player.field_70170_p.func_72838_d((Entity)shopkeeper);
                    break;
                }
                case NurseJoy: {
                    NPCNurseJoy nursejoy = new NPCNurseJoy(player.field_70170_p, 1);
                    nursejoy.func_70107_b((float)blockPos.func_177958_n() + 0.5f, blockPos.func_177956_o() + 1, (float)blockPos.func_177952_p() + 0.5f);
                    nursejoy.initDefaultAI();
                    nursejoy.ignoreDespawnCounter = true;
                    player.field_70170_p.func_72838_d((Entity)nursejoy);
                    break;
                }
                case Doctor: {
                    NPCNurseJoy doctor = new NPCNurseJoy(player.field_70170_p, 0);
                    doctor.func_70107_b((float)blockPos.func_177958_n() + 0.5f, blockPos.func_177956_o() + 1, (float)blockPos.func_177952_p() + 0.5f);
                    doctor.initDefaultAI();
                    doctor.ignoreDespawnCounter = true;
                    player.field_70170_p.func_72838_d((Entity)doctor);
                    break;
                }
            }
        }
    }
}

