/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.itemDrops;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.comm.ISyncHandler;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.GuiItemDrops;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.BattleGuiClosed;
import com.pixelmonmod.pixelmon.comm.packetHandlers.itemDrops.ItemDropMode;
import com.pixelmonmod.pixelmon.comm.packetHandlers.itemDrops.ServerItemDropPacket;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DroppedItem;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDropPacket
implements IMessage {
    public DroppedItem[] items;
    public boolean hasCustomTitle = false;
    public ItemDropMode mode;
    public TextComponentTranslation customTitle;

    public ItemDropPacket() {
    }

    public ItemDropPacket(ItemDropMode mode, ArrayList<DroppedItem> givenDrops) {
        this.items = givenDrops.toArray(new DroppedItem[givenDrops.size()]);
        this.mode = mode;
    }

    public ItemDropPacket(ItemDropMode mode, TextComponentTranslation customTitle, ArrayList<DroppedItem> drops) {
        this(mode, drops);
        this.hasCustomTitle = true;
        this.customTitle = customTitle;
    }

    public ItemDropPacket(TextComponentTranslation customTitle, ArrayList<DroppedItem> drops) {
        this(ItemDropMode.Other, customTitle, drops);
    }

    public void fromBytes(ByteBuf buffer) {
        this.mode = ItemDropMode.values()[buffer.readInt()];
        this.items = new DroppedItem[buffer.readShort()];
        this.hasCustomTitle = buffer.readBoolean();
        int actualLength = this.items.length;
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = DroppedItem.fromBytes(buffer);
            if (this.items[i] != null) continue;
            --actualLength;
        }
        if (actualLength != this.items.length) {
            DroppedItem[] newItems = new DroppedItem[actualLength];
            int newItemIndex = 0;
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i] == null || newItemIndex >= actualLength) continue;
                newItems[newItemIndex++] = this.items[i];
            }
            this.items = newItems;
        }
        if (this.hasCustomTitle) {
            PacketBuffer pb = new PacketBuffer(buffer);
            try {
                this.customTitle = (TextComponentTranslation)ITextComponent.Serializer.func_150699_a((String)pb.func_150789_c(Short.MAX_VALUE));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.mode.ordinal());
        buffer.writeShort(this.items.length);
        buffer.writeBoolean(this.hasCustomTitle);
        for (DroppedItem item : this.items) {
            item.toBytes(buffer);
        }
        if (this.hasCustomTitle) {
            PacketBuffer pb = new PacketBuffer(buffer);
            try {
                pb.func_180714_a(ITextComponent.Serializer.func_150696_a((ITextComponent)this.customTitle));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class Handler
    implements ISyncHandler<ItemDropPacket> {
        @Override
        public void onSyncMessage(ItemDropPacket message, MessageContext ctx) {
            this.onClient(message);
        }

        @SideOnly(value=Side.CLIENT)
        private void onClient(ItemDropPacket message) {
            if (PixelmonConfig.useDropGUI || message.mode != ItemDropMode.NormalPokemon) {
                ServerStorageDisplay.bossDrops = message;
                if (ClientProxy.battleManager.battleEnded && !ClientProxy.battleManager.hasMoreMessages()) {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiItemDrops());
                }
            } else {
                Pixelmon.network.sendToServer((IMessage)new ServerItemDropPacket(ServerItemDropPacket.PacketMode.TakeAllItems));
                Pixelmon.network.sendToServer((IMessage)new BattleGuiClosed());
            }
        }
    }
}

