/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.dialogue;

import com.pixelmonmod.pixelmon.api.comm.ISyncHandler;
import com.pixelmonmod.pixelmon.api.dialogue.Dialogue;
import com.pixelmonmod.pixelmon.client.gui.dialogue.GuiDialogue;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SetDialogueData
implements IMessage {
    private boolean openGui = false;
    private int numDialogues = 0;
    private List<Dialogue> dialogues = new ArrayList<Dialogue>();

    public SetDialogueData() {
    }

    public SetDialogueData(List<Dialogue> dialogues) {
        if (dialogues != null) {
            this.numDialogues = dialogues.size();
        }
        this.dialogues = dialogues;
    }

    public SetDialogueData(List<Dialogue> dialogues, boolean openGui) {
        this(dialogues);
        this.openGui = openGui;
    }

    public void fromBytes(ByteBuf buffer) {
        this.openGui = buffer.readBoolean();
        this.numDialogues = buffer.readInt();
        for (int i = 0; i < this.numDialogues; ++i) {
            this.dialogues.add(new Dialogue(buffer));
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeBoolean(this.openGui);
        buffer.writeInt(this.numDialogues);
        for (Dialogue dialogue : this.dialogues) {
            dialogue.writeToBytes(buffer);
        }
    }

    public static class Handler
    implements ISyncHandler<SetDialogueData> {
        @Override
        public void onSyncMessage(SetDialogueData message, MessageContext ctx) {
            this.onClient(message);
        }

        @SideOnly(value=Side.CLIENT)
        private void onClient(SetDialogueData message) {
            GuiDialogue.setDialogues(message.dialogues);
            if (message.openGui) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiDialogue());
            }
        }
    }
}

